package com.artfess.data.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.DictionaryUtils;
import com.artfess.data.dao.BizEquipmentBaseDataDao;
import com.artfess.data.manager.BizEquipmentBaseDataManager;
import com.artfess.data.model.BizEquipmentBaseData;
import com.artfess.data.vo.TrainReqVo;
import com.artfess.examine.dao.ExamOrgEvaluationDao;
import com.artfess.examine.vo.OrgVo;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 装备基础资源数据 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Service
public class BizEquipmentBaseDataManagerImpl extends BaseManagerImpl<BizEquipmentBaseDataDao, BizEquipmentBaseData> implements BizEquipmentBaseDataManager {

    @Resource
    private ExamOrgEvaluationDao orgEvaluationDao;

    @Override
    public void saveList(List<BizEquipmentBaseData> list) {
        List<OrgVo> orgVos = orgEvaluationDao.orgList();
        Map<String, OrgVo> orgMap = orgVos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        list.forEach(data -> {
            Assert.hasText(data.getName(), "请填写装备名称");
            if (null != DictionaryUtils.getDictInfo("zblx", data.getType())) {
                String type = DictionaryUtils.getDictInfo("zblx", data.getType()).getValue();
                data.setType(type);
            }
            if (null != DictionaryUtils.getDictInfo("jldw", data.getType())) {
                String unit = DictionaryUtils.getDictInfo("jldw", data.getType()).getValue();
                data.setUnit(unit);
            }

            if (null != DictionaryUtils.getDictInfo("zbzt", data.getType())) {
                String unit = DictionaryUtils.getDictInfo("zbzt", data.getType()).getValue();
                data.setUnit(unit);
            }

            if (!CollectionUtils.isEmpty(orgMap) && null != orgMap.get(data.getOrgName())) {
                data.setOrgId(orgMap.get(data.getOrgName()).getId());
            }
        });

        this.saveBatch(list);
    }

    @Override
    public List<JSONObject> equipmentBasePancake(TrainReqVo reqVo) {
        return this.baseMapper.equipmentBasePancake(reqVo);
    }
}
