package com.artfess.data.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.DictionaryUtils;
import com.artfess.base.util.DmpBeanUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.data.manager.BizExamGeneralPlanManager;
import com.artfess.data.manager.BizExamPlanManager;
import com.artfess.data.model.BizExamGeneralPlan;
import com.artfess.data.model.BizExamPlan;
import com.artfess.data.vo.MonthPlanVo;
import com.artfess.data.vo.QuarterPlanVo;
import com.artfess.data.vo.WeekPlanVo;
import com.artfess.data.vo.YearPlanVo;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.io.ClassPathResource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 训练总计划 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-12-04
 */
@Slf4j
@RestController
@Api(tags = "训练数据-训练总计划")
@RequestMapping("/biz/exam/generalPlan/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizExamGeneralPlanController extends BaseController<BizExamGeneralPlanManager, BizExamGeneralPlan> {

    @Resource
    private BizExamPlanManager examPlanManager;


    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({AddGroup.class}) BizExamGeneralPlan t) {
        boolean result = baseService.saveInfo(t);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @Override
    @GetMapping("/{id}")
    @ApiOperation("根据id查询实体")
    public BizExamGeneralPlan getById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        return baseService.findById(id);
    }

    @Override
    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({UpdateGroup.class}) BizExamGeneralPlan t) {
        boolean result = baseService.updateInfo(t);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return new CommonResult<>();
    }


    @ApiOperation(value = "导入")
    @PostMapping("/importExcel/{planType}")
    public CommonResult<String> importExcel(@RequestParam("file") MultipartFile file, @PathVariable String planType) {
        try {
            List<BizExamGeneralPlan> planList = null;
            if ("1".equals(planType)) {
                ExcelUtils<YearPlanVo> excelUtil = new ExcelUtils<>(YearPlanVo.class);
                List<YearPlanVo> list = excelUtil.importExcel(null, file.getInputStream());
                planList = DmpBeanUtil.copyList(list, BizExamGeneralPlan.class);
            } else if ("2".equals(planType)) {

                ExcelUtils<QuarterPlanVo> excelUtil = new ExcelUtils<>(QuarterPlanVo.class);
                List<QuarterPlanVo> list = excelUtil.importExcel(null, file.getInputStream());
                planList = DmpBeanUtil.copyList(list, BizExamGeneralPlan.class);
            } else if ("3".equals(planType)) {
                ExcelUtils<MonthPlanVo> excelUtil = new ExcelUtils<>(MonthPlanVo.class);
                List<MonthPlanVo> list = excelUtil.importExcel(null, file.getInputStream());
                planList = DmpBeanUtil.copyList(list, BizExamGeneralPlan.class);
            } else if ("4".equals(planType)) {
                ExcelUtils<WeekPlanVo> excelUtil = new ExcelUtils<>(WeekPlanVo.class);
                List<WeekPlanVo> list = excelUtil.importExcel(null, file.getInputStream());
                planList = DmpBeanUtil.copyList(list, BizExamGeneralPlan.class);
            } else if ("5".equals(planType)) {
                ExcelUtils<YearPlanVo> excelUtil = new ExcelUtils<>(YearPlanVo.class);
                List<YearPlanVo> list = excelUtil.importExcel(null, file.getInputStream());
                planList = DmpBeanUtil.copyList(list, BizExamGeneralPlan.class);
            } else if ("6".equals(planType)) {
                ExcelUtils<YearPlanVo> excelUtil = new ExcelUtils<>(YearPlanVo.class);
                List<YearPlanVo> list = excelUtil.importExcel(null, file.getInputStream());
                planList = DmpBeanUtil.copyList(list, BizExamGeneralPlan.class);
            } else if ("7".equals(planType)) {
                ExcelUtils<YearPlanVo> excelUtil = new ExcelUtils<>(YearPlanVo.class);
                List<YearPlanVo> list = excelUtil.importExcel(null, file.getInputStream());
                planList = DmpBeanUtil.copyList(list, BizExamGeneralPlan.class);
            }

            baseService.saveList(planList, planType);
            return new CommonResult<>();
        } catch (Exception e) {
            throw new IllegalArgumentException("导入失败," + e.getMessage());
        }
    }

    @ApiOperation(value = "导出")
    @PostMapping("/export/{planType}")
    public void export(HttpServletResponse response, HttpServletRequest request,
                       @ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizExamPlan> queryFilter, @PathVariable String planType) throws Exception {
//        queryFilter.setPageBean(new PageBean(1, -1, true));
        PageList<BizExamPlan> page = examPlanManager.findByPage(queryFilter);
        page.getRows().forEach(data -> {
            if (null != DictionaryUtils.findByDictValue("xljb", data.getTrainLevel())) {
                String type = DictionaryUtils.findByDictValue("xljb", data.getTrainLevel()).getName();
                data.setTrainLevel(type);
            }

            if (null != DictionaryUtils.findByDictValue("xllb", data.getTrainType())) {
                String trainType = DictionaryUtils.findByDictValue("xllb", data.getTrainType()).getName();
                data.setTrainType(trainType);
            }

            if (null != DictionaryUtils.findByDictValue("jdmc", data.getQuarter())) {
                String type = DictionaryUtils.findByDictValue("jdmc", data.getQuarter()).getName();
                data.setQuarter(type);
            }

            if (null != DictionaryUtils.findByDictValue("xlfs", data.getWay())) {
                String way = DictionaryUtils.findByDictValue("xlfs", data.getWay()).getName();
                data.setWay(way);
            }
        });
        if ("1".equals(planType)) {
            ExcelUtils<YearPlanVo> util = new ExcelUtils<YearPlanVo>(YearPlanVo.class);
            List<YearPlanVo> list = DmpBeanUtil.copyList(page.getRows(), YearPlanVo.class);
            util.exportExcel(response, request, list, "年度训练计划数据");
        } else if ("2".equals(planType)) {

            ExcelUtils<QuarterPlanVo> util = new ExcelUtils<QuarterPlanVo>(QuarterPlanVo.class);
            List<QuarterPlanVo> list = DmpBeanUtil.copyList(page.getRows(), QuarterPlanVo.class);
            util.exportExcel(response, request, list, "阶段训练计划数据");
        } else if ("3".equals(planType)) {

            ExcelUtils<MonthPlanVo> util = new ExcelUtils<MonthPlanVo>(MonthPlanVo.class);
            List<MonthPlanVo> list = DmpBeanUtil.copyList(page.getRows(), MonthPlanVo.class);
            util.exportExcel(response, request, list, "月度训练计划数据");
        } else if ("4".equals(planType)) {
            ExcelUtils<WeekPlanVo> util = new ExcelUtils<WeekPlanVo>(WeekPlanVo.class);
            List<WeekPlanVo> list = DmpBeanUtil.copyList(page.getRows(), WeekPlanVo.class);
            util.exportExcel(response, request, list, "周训练计划数据");

        } else if ("5".equals(planType)) {
            ExcelUtils<YearPlanVo> util = new ExcelUtils<YearPlanVo>(YearPlanVo.class);
            List<YearPlanVo> list = DmpBeanUtil.copyList(page.getRows(), YearPlanVo.class);
            util.exportExcel(response, request, list, "排班训练计划数据");
        } else if ("6".equals(planType)) {
            ExcelUtils<YearPlanVo> util = new ExcelUtils<YearPlanVo>(YearPlanVo.class);
            List<YearPlanVo> list = DmpBeanUtil.copyList(page.getRows(), YearPlanVo.class);
            util.exportExcel(response, request, list, "集约专修训练计划数据");
        } else if ("7".equals(planType)) {
            ExcelUtils<YearPlanVo> util = new ExcelUtils<YearPlanVo>(YearPlanVo.class);
            List<YearPlanVo> list = DmpBeanUtil.copyList(page.getRows(), YearPlanVo.class);
            util.exportExcel(response, request, list, "补训计划数据");
        }

    }

    /**
     * 下载导入模板
     *
     * @param response
     * @return
     */
    @ApiOperation(value = "下载导入模板")
    @GetMapping("/downModel/{planType}")
    public void downTemplate(HttpServletResponse response, @PathVariable String planType) {
        try {
            if ("1".equals(planType)) {
                ClassPathResource classPathResource = new ClassPathResource("model/训练管理数据/年度训练计划数据.xlsx");
                FileDownloadUtil.fileDownload(response, classPathResource.getInputStream(), "年度训练计划数据模板.xlsx");
            } else if ("2".equals(planType)) {
                ClassPathResource classPathResource = new ClassPathResource("model/训练管理数据/阶段训练计划数据.xlsx");
                FileDownloadUtil.fileDownload(response, classPathResource.getInputStream(), "阶段训练计划数据.xlsx");
            } else if ("3".equals(planType)) {
                ClassPathResource classPathResource = new ClassPathResource("model/训练管理数据/月训练计划数据.xlsx");
                FileDownloadUtil.fileDownload(response, classPathResource.getInputStream(), "月训练计划数据.xlsx");
            } else if ("4".equals(planType)) {
                ClassPathResource classPathResource = new ClassPathResource("model/训练管理数据/周训练计划数据.xlsx");
                FileDownloadUtil.fileDownload(response, classPathResource.getInputStream(), "周训练计划数据.xlsx");
            } else if ("5".equals(planType)) {
                ClassPathResource classPathResource = new ClassPathResource("model/训练管理数据/排班训练计划数据.xlsx");
                FileDownloadUtil.fileDownload(response, classPathResource.getInputStream(), "排班训练计划数据模板.xlsx");
            } else if ("6".equals(planType)) {
                ClassPathResource classPathResource = new ClassPathResource("model/训练管理数据/集约专修训练计划数据.xlsx");
                FileDownloadUtil.fileDownload(response, classPathResource.getInputStream(), "集约专修训练计划数据.xlsx");
            } else if ("7".equals(planType)) {
                ClassPathResource classPathResource = new ClassPathResource("model/训练管理数据/补训计划数据.xlsx");
                FileDownloadUtil.fileDownload(response, classPathResource.getInputStream(), "补训计划数据.xlsx");
            }

        } catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException("你所下载的资源不存在");
        }
    }

    @ApiOperation(value = "训练计划下发")
    @GetMapping("/updateStatus")
    public CommonResult<String> updateStatus(String id) {
        try {
            baseService.updateStatus(id);
            return new CommonResult<>();
        } catch (Exception e) {
            throw new IllegalArgumentException("操作失败," + e.getMessage());
        }
    }

}
