package com.artfess.examine.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.SysTypeEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.examine.dao.ExamEquipmentSysDao;
import com.artfess.examine.dao.ExamPosSysDao;
import com.artfess.examine.dao.ExamSubjectInfoDao;
import com.artfess.examine.manager.ExamEquipmentSysManager;
import com.artfess.examine.model.ExamEquipmentSys;
import com.artfess.examine.model.ExamPosSys;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.model.ExamSubjectType;
import com.artfess.examine.vo.PositionVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * 装备系统表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Service
public class ExamEquipmentSysManagerImpl extends BaseManagerImpl<ExamEquipmentSysDao, ExamEquipmentSys> implements ExamEquipmentSysManager {

    @Resource
    private ExamPosSysDao posSysDao;

    @Resource
    private ExamSubjectInfoDao subjectInfoDao;

    @Override
    public List<ExamSubjectType> getTree(ExamEquipmentSys entity) {
        List<ExamSubjectType> treeList = Lists.newArrayList();
        List<ExamSubjectType> orgs = this.subjectInfoDao.getOrgList();
        orgs.forEach(org -> {
            org.setType("1");
        });
        treeList.addAll(orgs);
//        List<ExamSubjectType> list = this.subjectInfoDao.getExamSysInfo();
//        list.forEach(sys -> {
//            sys.setType("2");
//        });
//        treeList.addAll(list);
        List<ExamSubjectType> posts = this.subjectInfoDao.getPositions();
        posts.forEach(post -> {
            if(StringUtil.isNotEmpty(post.getSysId())){
                post.setParentId(post.getSysId());
            }else{
                post.setParentId(post.getOrgId());
            }

            post.setType("3");
        });
        treeList.addAll(posts);


        List<ExamSubjectType> tree = BeanUtils.listToTree(treeList);
        return tree;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void bindPosAndUserType(ExamEquipmentSys entity) {
        QueryWrapper<ExamPosSys> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("sys_id_", entity.getId());
        posSysDao.delete(queryWrapper);
        if(CollectionUtils.isEmpty(entity.getPositonVos())){
            return;
        }
        entity.getPositonVos().forEach(positionVo -> {
            ExamPosSys examPosSys = new ExamPosSys();

            examPosSys.setPosId(positionVo.getPositionId());
            examPosSys.setSysId(entity.getId());
            posSysDao.insert(examPosSys);
        });
    }

    @Override
    public List<PositionVo> findByBindPos(String ids) {
        Assert.hasText(ids, "请选择专业装备id");
        String[] split = ids.split(",");
        List<String> idList = Arrays.asList(split);

        List<PositionVo> list = this.posSysDao.findByBindPos(idList);
        //岗位编码 名称
        return list;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean createInfo(ExamEquipmentSys t) {
        int insert = this.baseMapper.insert(t);
        if(insert > 0) {
            processPosSysInfo(t);
            return true;
        }
        return false;
    }

    private void processPosSysInfo(ExamEquipmentSys entity) {
        QueryWrapper<ExamPosSys> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("sys_id_", entity.getId());
        posSysDao.delete(queryWrapper);
        if(CollectionUtils.isEmpty(entity.getPositonVos())){
            return;
        }
        entity.getPositonVos().forEach(positionVo -> {
            ExamPosSys examPosSys = new ExamPosSys();
            String orgId = posSysDao.getOrgId(positionVo.getPositionId());
            ExamEquipmentSys sys = baseMapper.findByNameAndOrgId(entity.getName(), orgId);
            if(null != sys) {
                throw new BaseException("当前组织下已有当前装备");
            }

            examPosSys.setOrgId(orgId);
            examPosSys.setPosId(positionVo.getPositionId());
            examPosSys.setSysId(entity.getId());
            posSysDao.insert(examPosSys);
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(ExamEquipmentSys t) {
        int insert = this.baseMapper.updateById(t);
        if(insert > 0) {
            processPosSysInfo(t);
            return true;
        }
        return false;
    }

    @Override
    public ExamEquipmentSys findById(String id) {
        ExamEquipmentSys examEquipmentSys = this.baseMapper.selectById(id);
        List<PositionVo> positionVoList = posSysDao.getPositionInfo(id);
        examEquipmentSys.setPositonVos(positionVoList);
        return examEquipmentSys;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean importExcel(List<ExamEquipmentSys> list) {
        list.forEach(sys -> {
            String orgId = posSysDao.findByOrgName(sys.getOrgName());
            ExamEquipmentSys examEquipmentSys = baseMapper.findByNameAndOrgId(sys.getName(), orgId);
            if (null != examEquipmentSys) {
                throw new RuntimeException(sys.getName() + "已重复，请检查！");
            }
            sys.setType(SysTypeEnum.getType(sys.getType()));
            this.baseMapper.insert(sys);
            if(!StringUtils.isEmpty(sys.getPositonNames())) {
                List<String> positionIds = this.subjectInfoDao.getPositionIds(Arrays.asList(sys.getPositonNames().split(",")));
                positionIds.forEach(positionId -> {
                    ExamPosSys examPosSys = new ExamPosSys();
                    examPosSys.setOrgId(orgId);
                    examPosSys.setPosId(positionId);
                    examPosSys.setSysId(sys.getId());
                    posSysDao.insert(examPosSys);
                });
            }
        });
        return true;
    }

    @Override
    public List<ExamSubjectInfo> getSubjectList(List<String> idList) {
        return this.baseMapper.getSubjectList(idList);
    }

    @Override
    public JSONObject summary() {
        Long orgCount = posSysDao.getOrgCount();
        Long userCount = posSysDao.getUserCount();
        Long jlyCount = posSysDao.getJlyCount();
        Long sysCount = posSysDao.getSysCount();
        Long subjectCount = posSysDao.getSubjectCount();
        JSONObject jsonObject =new JSONObject();
        jsonObject.put("orgCount", orgCount);
        jsonObject.put("userCount", userCount);
        jsonObject.put("jlyCount", jlyCount);
        jsonObject.put("sysCount", sysCount);
        jsonObject.put("subjectCount", subjectCount);
        return jsonObject;
    }
}
