package com.artfess.examine.manager;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.data.vo.ArchivesManagerVo;
import com.artfess.data.vo.UserExamVo;
import com.artfess.examine.model.ExamUserEvaluation;
import com.artfess.examine.model.ExamUserEvaluationDetail;
import com.artfess.examine.model.ExamUserRecord;
import com.artfess.examine.vo.SettingYearVo;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 年度考生综合评定表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-11-28
 */
public interface ExamUserEvaluationManager extends BaseManager<ExamUserEvaluation> {

    PageList<ExamUserEvaluation> findByPage(QueryFilter<ExamUserEvaluation> queryFilter);

    void userEvaluation(ExamUserRecord userRecord);

    PageList<ExamUserEvaluation> myYearPage(QueryFilter<ExamUserEvaluation> queryFilter);

    boolean addSubject(ExamUserEvaluation t);

    boolean delSubject(ExamUserEvaluation t);

    boolean settingYear(SettingYearVo t);

    List<ExamUserEvaluationDetail> evaluationDetail(String id);

    String getReportStatus();

    List<JSONObject> getSubjectInfo(SettingYearVo t);

    List<JSONObject> getPositionPaper(SettingYearVo t);

    void export(String orgId, HttpServletResponse response,String fileName) throws IOException;

    boolean batchSettingYear(SettingYearVo t);

    boolean importExcel(List<ExamUserEvaluationDetail> detail, String orgId);

    boolean delPositionSubject(String subjectIds, String positionId, String year);

    PageList<ArchivesManagerVo> positionArchives(QueryFilter<ExamUserEvaluation> queryFilter);

    PageList<ArchivesManagerVo> orgArchives(QueryFilter<ExamUserEvaluation> queryFilter);

    PageList<ArchivesManagerVo> subjectArchives(QueryFilter<ExamUserEvaluation> queryFilter);

    void subjectArchivesExport(QueryFilter<ExamUserEvaluation> queryFilter, HttpServletResponse response);

    void orgArchivesExport(QueryFilter<ExamUserEvaluation> queryFilter, HttpServletResponse response);

    void positionArchivesExport(QueryFilter<ExamUserEvaluation> queryFilter, HttpServletResponse response);

    PageList<UserExamVo> userQualityAnalyse(QueryFilter<ExamUserEvaluation> queryFilter);

    /**
     * 设置考生职业教育分数以及总体评价
     * @param t 考试记录
     * @return 设置成功与否
     */
    boolean setUserWorkEvaluation(ExamUserEvaluation t);
}
