package com.artfess.data.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.data.dao.BizTrainEquipmentDetailDao;
import com.artfess.data.manager.BizTrainEquipmentDataManager;
import com.artfess.data.manager.BizTrainEquipmentDetailManager;
import com.artfess.data.model.BizTrainEquipmentData;
import com.artfess.data.model.BizTrainEquipmentDetail;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/**
 * 训练器材使用明细 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-11-14
 */
@Service
public class BizTrainEquipmentDetailManagerImpl extends BaseManagerImpl<BizTrainEquipmentDetailDao, BizTrainEquipmentDetail> implements BizTrainEquipmentDetailManager {

    @Autowired
    private BizTrainEquipmentDataManager equipmentDataManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean saveInfo(BizTrainEquipmentDetail t) {
        BizTrainEquipmentData bizTrainEquipmentData = equipmentDataManager.get(t.getEquipmentId());
        Assert.notNull(bizTrainEquipmentData, "训练器材不存在");
        if("0".equals(t.getStatus())) {
            int i = t.getNum().compareTo(bizTrainEquipmentData.getUsableNum());
            if(i < 0){
                throw new BaseException("训练消耗指标库存不足，请查看库存进行出库!");
            }
            bizTrainEquipmentData.setUsableNum(bizTrainEquipmentData.getUsableNum().subtract(t.getNum()));
        }else{
            bizTrainEquipmentData.setUsableNum(bizTrainEquipmentData.getUsableNum().add(t.getNum()));
        }
        boolean update = this.equipmentDataManager.updateById(bizTrainEquipmentData);
        if(update) {
            return this.save(t);
        }

        return false;
    }
}
