/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.model.nodehandler;

import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.constant.DecideType;
import com.artfess.bpm.api.constant.FollowMode;
import com.artfess.bpm.api.constant.PrivilegeMode;
import com.artfess.bpm.api.constant.VoteType;
import com.artfess.bpm.api.model.process.nodedef.ext.BaseBpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.PrivilegeItem;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.SignRule;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.UserAssignRule;
import com.artfess.bpm.defxml.entity.ext.SignNode;
import com.artfess.bpm.persistence.model.nodehandler.UserTaskHandler;
import com.artfess.bpm.plugin.core.util.UserAssignRuleParser;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class SignTaskHandler
extends UserTaskHandler {
    @Override
    public void handNode(BaseBpmNodeDef nodeDef, Object baseNode) throws Exception {
        super.handNode(nodeDef, baseNode);
        SignNodeDef signNodeDef = (SignNodeDef)nodeDef;
        SignNode signNode = (SignNode)baseNode;
        this.handSignRule(signNodeDef, signNode);
    }

    private void handSignRule(SignNodeDef signNodeDef, SignNode signNode) {
        SignNode.SignSetting setting = signNode.getSignSetting();
        this.handRule(signNodeDef, setting);
        this.handPrivilege(signNodeDef, setting);
    }

    private void handRule(SignNodeDef signNodeDef, SignNode.SignSetting setting) {
        SignNode.SignSetting.SignRule signRule = setting.getSignRule();
        DecideType decideType = DecideType.fromKey(signRule.getDecideType().value());
        VoteType voteType = VoteType.fromKey(signRule.getVoteType().value());
        FollowMode flowMode = FollowMode.fromKey(signRule.getFollowMode().value());
        SignRule sign = new SignRule(decideType, voteType, flowMode, signRule.getVoteAmount());
        signNodeDef.setSignRule(sign);
    }

    private void handPrivilege(SignNodeDef signNodeDef, SignNode.SignSetting setting) {
        if (setting.getPrivilege() == null) {
            return;
        }
        List<SignNode.SignSetting.Privilege.Item> items = setting.getPrivilege().getItem();
        if (BeanUtils.isEmpty(items)) {
            return;
        }
        ArrayList<PrivilegeItem> privilegeList = new ArrayList<PrivilegeItem>();
        for (SignNode.SignSetting.Privilege.Item item : items) {
            PrivilegeItem priItem = new PrivilegeItem();
            priItem.setPrivilegeMode(PrivilegeMode.fromKey(item.getMode().value()));
            Object obj = item.getMembers();
            if (obj instanceof Element) {
                this.handPrivilegeItem(priItem, (Element)obj);
            }
            privilegeList.add(priItem);
        }
        signNodeDef.setPrivilegeList(privilegeList);
    }

    private void handPrivilegeItem(PrivilegeItem priItem, Element elMembers) {
        if (elMembers.getChildNodes() == null || elMembers.getChildNodes().getLength() == 0) {
            return;
        }
        List<UserAssignRule> assignRules = UserAssignRuleParser.parse(elMembers);
        priItem.setUserRuleList(assignRules);
    }
}

