/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.ueditor;

import com.artfess.base.util.JsonUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public class ConfigManager {
    private ObjectNode jsonConfig = null;
    private static final String SCRAWL_FILE_NAME = "scrawl";
    private static final String REMOTE_FILE_NAME = "remote";

    public ConfigManager(String config) {
        this.initEnv(config);
    }

    public boolean valid() {
        return this.jsonConfig != null;
    }

    public ObjectNode getAllConfig() {
        return this.jsonConfig;
    }

    public Map<String, Object> getConfig(int type) {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        String savePath = null;
        switch (type) {
            case 4: {
                conf.put("isBase64", "false");
                conf.put("maxSize", this.getLong("fileMaxSize"));
                conf.put("allowFiles", this.getArray("fileAllowFiles"));
                conf.put("fieldName", JsonUtil.getString((JsonNode)this.jsonConfig, (String)"fileFieldName"));
                savePath = JsonUtil.getString((JsonNode)this.jsonConfig, (String)"filePathFormat");
                break;
            }
            case 1: {
                conf.put("isBase64", "false");
                conf.put("maxSize", this.getLong("imageMaxSize"));
                conf.put("allowFiles", this.getArray("imageAllowFiles"));
                conf.put("fieldName", JsonUtil.getString((JsonNode)this.jsonConfig, (String)"imageFieldName"));
                savePath = JsonUtil.getString((JsonNode)this.jsonConfig, (String)"imagePathFormat");
                break;
            }
            case 3: {
                conf.put("maxSize", this.getLong("videoMaxSize"));
                conf.put("allowFiles", this.getArray("videoAllowFiles"));
                conf.put("fieldName", JsonUtil.getString((JsonNode)this.jsonConfig, (String)"videoFieldName"));
                savePath = JsonUtil.getString((JsonNode)this.jsonConfig, (String)"videoPathFormat");
                break;
            }
            case 2: {
                conf.put("filename", SCRAWL_FILE_NAME);
                conf.put("maxSize", this.getLong("scrawlMaxSize"));
                conf.put("fieldName", JsonUtil.getString((JsonNode)this.jsonConfig, (String)"scrawlFieldName"));
                conf.put("isBase64", "true");
                savePath = JsonUtil.getString((JsonNode)this.jsonConfig, (String)"scrawlPathFormat");
                break;
            }
            case 5: {
                conf.put("filename", REMOTE_FILE_NAME);
                conf.put("filter", this.getArray("catcherLocalDomain"));
                conf.put("maxSize", this.getLong("catcherMaxSize"));
                conf.put("allowFiles", this.getArray("catcherAllowFiles"));
                conf.put("fieldName", JsonUtil.getString((JsonNode)this.jsonConfig, (String)"catcherFieldName") + "[]");
                savePath = JsonUtil.getString((JsonNode)this.jsonConfig, (String)"catcherPathFormat");
                break;
            }
            case 7: {
                conf.put("allowFiles", this.getArray("imageManagerAllowFiles"));
                conf.put("dir", JsonUtil.getString((JsonNode)this.jsonConfig, (String)"imageManagerListPath"));
                conf.put("count", JsonUtil.getInt((ObjectNode)this.jsonConfig, (String)"imageManagerListSize"));
                break;
            }
            case 6: {
                conf.put("allowFiles", this.getArray("fileManagerAllowFiles"));
                conf.put("dir", JsonUtil.getString((JsonNode)this.jsonConfig, (String)"fileManagerListPath"));
                conf.put("count", JsonUtil.getInt((ObjectNode)this.jsonConfig, (String)"fileManagerListSize"));
                break;
            }
            case 8: {
                conf.put("dir", JsonUtil.getString((JsonNode)this.jsonConfig, (String)"fileManagerListPath"));
            }
        }
        conf.put("savePath", savePath);
        return conf;
    }

    private void initEnv(String config) {
        try {
            JsonNode jsonNode = JsonUtil.toJsonNode((String)config);
            this.jsonConfig = (ObjectNode)jsonNode;
        }
        catch (Exception e) {
            this.jsonConfig = null;
        }
    }

    private Long getLong(String key) {
        JsonNode jsonNode = this.jsonConfig.get(key);
        Assert.notNull((Object)jsonNode, (String)String.format("\u901a\u8fc7Key\uff1a%s\u672a\u80fd\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u503c\u3002", key));
        return jsonNode.asLong();
    }

    private String[] getArray(String key) {
        JsonNode jsonNode = this.jsonConfig.get(key);
        Assert.notNull((Object)jsonNode, (String)String.format("\u901a\u8fc7Key\uff1a%s\u672a\u80fd\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u503c\u3002", key));
        Assert.isTrue((boolean)jsonNode.isArray(), (String)String.format("Key\uff1a%s\u6240\u5bf9\u5e94\u7684\u503c\u4e0d\u662f\u6570\u7ec4\u683c\u5f0f", key));
        ArrayNode aryNode = (ArrayNode)jsonNode;
        int size = aryNode.size();
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            JsonNode node = aryNode.get(i);
            result[i] = node.asText();
        }
        return result;
    }
}

