/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.table.datasource;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Method;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class DataSourceUtil {
    public static final String DYNAMIC_DATASOURCE = "dataSource";

    public static void addDataSource(String key, DataSource dataSource, boolean replace) throws IllegalAccessException, NoSuchFieldException {
        DynamicRoutingDataSource dynamicDataSource = (DynamicRoutingDataSource)AppUtil.getBean((String)DYNAMIC_DATASOURCE);
        DataSource existDataSource = dynamicDataSource.getDataSource(key);
        if (BeanUtils.isNotEmpty((Object)existDataSource)) {
            if (!replace) {
                return;
            }
            dynamicDataSource.removeDataSource(key);
        }
        dynamicDataSource.addDataSource(key, dataSource);
    }

    public static void removeDataSource(String key) throws IllegalAccessException, NoSuchFieldException {
        DynamicRoutingDataSource dynamicDataSource = (DynamicRoutingDataSource)AppUtil.getBean((String)DYNAMIC_DATASOURCE);
        dynamicDataSource.removeDataSource(key);
    }

    public static Map<String, DataSource> getDataSources() throws IllegalAccessException, NoSuchFieldException {
        DynamicRoutingDataSource dynamicDataSource = (DynamicRoutingDataSource)AppUtil.getBean((String)DYNAMIC_DATASOURCE);
        return dynamicDataSource.getCurrentDataSources();
    }

    public static DataSource getDataSourceByAlias(String alias) throws IllegalAccessException, NoSuchFieldException {
        DatabaseContext databaseContext = (DatabaseContext)AppUtil.getBean(DatabaseContext.class);
        return databaseContext.getDataSourceByAlias(alias);
    }

    public static JdbcTemplate getJdbcTempByDsAlias(String alias) throws Exception {
        if (alias.equals("LOCAL")) {
            return (JdbcTemplate)AppUtil.getBean(JdbcTemplate.class);
        }
        return new JdbcTemplate(DataSourceUtil.getDataSourceByAlias(alias));
    }

    public static DataSource getDataSource(JsonNode jsonNode) {
        try {
            Class<?> _class = null;
            _class = Class.forName(jsonNode.get("classPath").asText());
            DataSource sqldataSource = null;
            sqldataSource = (DataSource)_class.newInstance();
            String settingJson = jsonNode.get("settingJson").asText();
            ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode((String)settingJson);
            for (int i = 0; i < arrayNode.size(); ++i) {
                ObjectNode jo = (ObjectNode)arrayNode.get(i);
                Object value = BeanUtils.convertByActType((String)JsonUtil.getString((JsonNode)jo, (String)"type"), (String)JsonUtil.getString((JsonNode)jo, (String)"value"));
                BeanUtils.setProperty((Object)sqldataSource, (String)JsonUtil.getString((JsonNode)jo, (String)"name"), (Object)value);
            }
            JsonNode jsonNode2 = jsonNode.get("initMethod");
            if (jsonNode2 != null && !(jsonNode2 instanceof NullNode)) {
                String initMethodStr = jsonNode.get("initMethod").asText();
                Method method = _class.getMethod(initMethodStr, new Class[0]);
                method.invoke((Object)sqldataSource, new Object[0]);
            }
            return sqldataSource;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

