/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.sysConfig.persistence.dao.SysCategoryDao;
import com.artfess.sysConfig.persistence.dao.SysTypeDao;
import com.artfess.sysConfig.persistence.manager.SysCategoryManager;
import com.artfess.sysConfig.persistence.model.SysCategory;
import com.artfess.sysConfig.persistence.model.SysType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="sysCategoryManager")
public class SysCategoryManagerImpl
extends BaseManagerImpl<SysCategoryDao, SysCategory>
implements SysCategoryManager {
    @Resource
    SysTypeDao sysTypeDao;

    public SysCategory get(Serializable id) {
        SysCategory category = null;
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            category = (SysCategory)super.get(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return category;
    }

    @Override
    public Boolean isKeyExist(String id, String groupKey) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("groupKey", groupKey);
        int i = ((SysCategoryDao)this.baseMapper).isKeyExist(params);
        return i > 0;
    }

    @Override
    public SysCategory getByTypeKey(String typeKey) {
        return ((SysCategoryDao)this.baseMapper).getByKey(typeKey);
    }

    public void remove(Serializable entityId) {
        List<SysType> sysTypes = this.sysTypeDao.getByParentId(entityId.toString());
        if (BeanUtils.isNotEmpty(sysTypes)) {
            String val = sysTypes.get(0).getTypeGroupKey();
            SysCategory sysCategory = ((SysCategoryDao)this.baseMapper).getByKey(val);
            if (BeanUtils.isNotEmpty((Object)((Object)sysCategory))) {
                val = sysCategory.getName();
            }
            throw new BaseException(String.format("\u5206\u7c7b\u6807\u8bc6[%s]\u4e0b\u5df2\u7ecf\u6dfb\u52a0\u5206\u7c7b\u4fe1\u606f\u6682\u65e0\u6cd5\u5220\u9664\u3002", val));
        }
        super.remove(entityId);
    }
}

