/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.manager.impl;

import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.form.FormType;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeForm;
import com.artfess.bpm.api.model.process.nodedef.ext.CallActivityNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.artfess.bpm.api.service.BpmFormService;
import com.artfess.bpm.api.service.BpmTaskService;
import com.artfess.bpm.engine.form.BpmFormFactory;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.DefaultBpmDefinitionAccessor;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.util.PublishAutoTestEventUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.artfess.workflow.runtime.dao.BpmTestCaseDao;
import com.artfess.workflow.runtime.manager.BpmTestCaseManager;
import com.artfess.workflow.runtime.manager.IProcessManager;
import com.artfess.workflow.runtime.manager.impl.MyCallable;
import com.artfess.workflow.runtime.model.BpmTestCase;
import com.artfess.workflow.runtime.params.BpmNodeDefVo;
import com.artfess.workflow.runtime.params.TestCaseBaseInfoVo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmTestCaseManager")
public class BpmTestCaseManagerImpl
extends BaseManagerImpl<BpmTestCaseDao, BpmTestCase>
implements BpmTestCaseManager {
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    IProcessManager processService;
    @Resource
    BpmTaskService bpmTaskService;
    @Resource
    IUserService userService;
    @Resource
    DefaultBpmDefinitionAccessor defaultBpmDefinitionAccessor;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;

    @Override
    @Transactional
    public void startTest(String ids) throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withDefaultPage().withQuery(new QueryField("id_", Arrays.asList(ids.split(",")), QueryOP.IN));
        PageList pageList = super.query(queryFilter);
        for (BpmTestCase bpmTestCase : pageList.getRows()) {
            this.startFlow(bpmTestCase);
        }
    }

    @Override
    @Transactional
    public void doNext(String id) {
        ContextThreadUtil.putCommonVars((String)"skipDebugger", (Object)true);
        PublishAutoTestEventUtil.publishAutoTestEvent((String)id);
    }

    @Override
    public TestCaseBaseInfoVo getBaseInfo(String defKey) throws Exception {
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getMainByDefKey(defKey);
        String defId = bpmDefinition.getId();
        HashMap<String, List<BpmNodeDefVo>> jo = new HashMap<String, List<BpmNodeDefVo>>();
        ArrayNode defKeys = JsonUtil.getMapper().createArrayNode();
        this.getAllNodeId(jo, defKeys, defKey);
        BpmFormService bpmFormService = BpmFormFactory.getFormService((FormType)FormType.PC);
        BpmNodeForm nodeForm = bpmFormService.getByDefId(defId);
        if (BeanUtils.isEmpty((Object)nodeForm)) {
            throw new BaseException(ResponseErrorEnums.EMPTY_FORM);
        }
        String formId = nodeForm.getForm().getId();
        return new TestCaseBaseInfoVo(formId, jo, defKeys);
    }

    @Override
    public ObjectNode getReportData(String ids) throws Exception {
        QueryFilter filter = QueryFilter.build().withDefaultPage().withQuery(new QueryField("id_", Arrays.asList(ids.split(",")), QueryOP.IN));
        PageList pageList = super.query(filter);
        ObjectNode jo = JsonUtil.getMapper().createObjectNode();
        ObjectNode procInstJo = JsonUtil.getMapper().createObjectNode();
        for (BpmTestCase bpmTestCase : pageList.getRows()) {
            ArrayList<String> entityIds = new ArrayList<String>();
            entityIds.add("bpmx_test_" + bpmTestCase.getId());
            QueryFilter queryFilter = QueryFilter.build().withQuery(new QueryField("sys_code_", entityIds, QueryOP.IN));
            PageList query = this.bpmProcessInstanceManager.query(queryFilter);
            List instances = query.getRows();
            ObjectNode _tmp = JsonUtil.getMapper().createObjectNode();
            for (DefaultBpmProcessInstance defaultBpmProcessInstance : instances) {
                if ("end".equals(defaultBpmProcessInstance.getStatus())) {
                    _tmp.put("end", JsonUtil.getInt((ObjectNode)_tmp, (String)"end", (int)0) + 1);
                }
                if ("manualend".equals(defaultBpmProcessInstance.getStatus())) {
                    _tmp.put("endProcess", JsonUtil.getInt((ObjectNode)_tmp, (String)"endProcess", (int)0) + 1);
                }
                if (!"running".equals(defaultBpmProcessInstance.getStatus())) continue;
                _tmp.put("unend", JsonUtil.getInt((ObjectNode)_tmp, (String)"unend", (int)0) + 1);
            }
            procInstJo.set(bpmTestCase.getId(), (JsonNode)_tmp);
        }
        ArrayNode xAxisJa = JsonUtil.getMapper().createArrayNode();
        ArrayNode endJa = JsonUtil.getMapper().createArrayNode();
        ArrayNode unendJa = JsonUtil.getMapper().createArrayNode();
        ArrayNode endProcessJa = JsonUtil.getMapper().createArrayNode();
        for (BpmTestCase bpmTestCase : pageList.getRows()) {
            ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode((Object)procInstJo.get(bpmTestCase.getId()));
            xAxisJa.add(bpmTestCase.getName());
            endJa.add(JsonUtil.getInt((ObjectNode)obj, (String)"end", (int)0));
            unendJa.add(JsonUtil.getInt((ObjectNode)obj, (String)"unend", (int)0));
            endProcessJa.add(JsonUtil.getInt((ObjectNode)obj, (String)"endProcess", (int)0));
        }
        jo.set("xAxis", (JsonNode)xAxisJa);
        jo.set("end", (JsonNode)endJa);
        jo.set("unend", (JsonNode)unendJa);
        jo.set("endProcess", (JsonNode)endProcessJa);
        return jo;
    }

    private void getAllNodeId(Map<String, List<BpmNodeDefVo>> jo, ArrayNode defKeys, String defKey) throws Exception {
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getMainByDefKey(defKey);
        String defId = bpmDefinition.getId();
        List allNodeDef = this.defaultBpmDefinitionAccessor.getAllNodeDef(defId);
        ArrayList<BpmNodeDefVo> ja = new ArrayList<BpmNodeDefVo>();
        ObjectNode defInfo = JsonUtil.getMapper().createObjectNode();
        defInfo.put("defKey", defKey);
        defInfo.put("defName", bpmDefinition.getName());
        defKeys.add((JsonNode)defInfo);
        for (BpmNodeDef bpmNodeDef : allNodeDef) {
            if (bpmNodeDef instanceof UserTaskNodeDef || bpmNodeDef instanceof SignNodeDef) {
                BpmNodeDefVo vo = BpmNodeDefVo.parseVo(bpmNodeDef);
                ja.add(vo);
            }
            if (!(bpmNodeDef instanceof CallActivityNodeDef)) continue;
            CallActivityNodeDef callActivityNodeDef = (CallActivityNodeDef)bpmNodeDef;
            this.getAllNodeId(jo, defKeys, callActivityNodeDef.getFlowKey());
        }
        jo.put(defKey, ja);
    }

    private Set<String> getStartors(String startor) throws Exception {
        HashSet<String> set = new HashSet<String>();
        if (StringUtil.isEmpty((String)startor)) {
            return set;
        }
        ArrayNode parseArray = (ArrayNode)JsonUtil.toJsonNode((String)startor);
        ArrayList<IUser> userList = new ArrayList<IUser>();
        for (Object object : parseArray) {
            String[] split;
            ObjectNode jo = (ObjectNode)JsonUtil.toJsonNode(object);
            if (!jo.has("id")) continue;
            String ids = jo.get("id").asText();
            for (String id : split = ids.split(",")) {
                if ("user".equals(jo.get("type").asText())) {
                    IUser user = this.userService.getUserById(id);
                    if (BeanUtils.isEmpty((Object)user)) continue;
                    userList.add(user);
                    continue;
                }
                List users = this.userService.getUserListByGroup(jo.get("type").asText(), id);
                if (BeanUtils.isEmpty((Object)users)) continue;
                userList.addAll(users);
            }
        }
        for (IUser iUser : userList) {
            if (BeanUtils.isEmpty((Object)iUser) || StringUtil.isEmpty((String)iUser.getAccount())) continue;
            set.add(iUser.getAccount());
        }
        return set;
    }

    private void startFlow(BpmTestCase bpmTestCase) throws Exception {
        String account = bpmTestCase.getStartorAccount();
        String startor = bpmTestCase.getStartor();
        Set<String> startors = this.getStartors(startor);
        if (StringUtil.isNotEmpty((String)account)) {
            startors.add(account);
        }
        if (BeanUtils.isEmpty(startors)) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u6d41\u7a0b\u542f\u52a8\u4eba\u5458");
        }
        ExecutorService pool = Executors.newFixedThreadPool(startors.size());
        ArrayList<Future<Object>> list = new ArrayList<Future<Object>>();
        for (String string : startors) {
            MyCallable c = new MyCallable(bpmTestCase, string, SecurityContextHolder.getContext().getAuthentication());
            Future<Object> f = pool.submit(c);
            list.add(f);
        }
        for (Future future : list) {
            String instId = future.get().toString();
            System.out.println(">>>" + future.get().toString());
            if (BeanUtils.isEmpty((Object)instId)) continue;
            PublishAutoTestEventUtil.publishAutoTestEvent((String)instId);
        }
        pool.shutdown();
    }
}

