/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.service;

import com.artfess.base.model.CommonResult;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bo.bodef.BoDefService;
import com.artfess.bo.context.FormContextThreadUtil;
import com.artfess.bo.instance.BoDataHandler;
import com.artfess.bo.instance.BoInstanceFactory;
import com.artfess.bo.model.BoAttribute;
import com.artfess.bo.model.BoData;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoDefXml;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.model.BoEntRel;
import com.artfess.bo.model.BoResult;
import com.artfess.bo.persistence.manager.BoDefManager;
import com.artfess.bo.persistence.manager.BoEntManager;
import com.artfess.bo.persistence.manager.BoEntRelManager;
import com.artfess.form.manager.FormRemindDataManager;
import com.artfess.form.model.Form;
import com.artfess.form.model.FormRight;
import com.artfess.form.model.FormRightXml;
import com.artfess.form.persistence.manager.FormDataTemplateManager;
import com.artfess.form.persistence.manager.FormManager;
import com.artfess.form.persistence.manager.FormRightManager;
import com.artfess.form.service.BpmFormRightsService;
import com.artfess.form.service.FormService;
import com.artfess.form.vo.FormRestfulModel;
import com.artfess.table.datasource.DataSourceUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javassist.NotFoundException;
import javax.annotation.Resource;
import javax.xml.bind.JAXBException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class DefaultFormService
implements FormService {
    @Resource
    private FormManager bpmFormManager;
    @Resource
    BoDefManager boDefManager;
    @Resource
    BoEntManager boEntManager;
    @Resource
    BoInstanceFactory boInstanceFactory;
    @Resource
    FormRightManager bpmFormRightManager;
    @Resource
    BoDefService boDefService;
    @Resource
    BoEntRelManager boEntRelManager;
    @Resource
    BpmFormRightsService bpmFormRightsService;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource
    FormRemindDataManager formRemindDataManager;

    @Override
    public Form getByFormKey(String formKey) {
        Form form = this.bpmFormManager.getMainByFormKey(formKey);
        if (BeanUtils.isNotEmpty((Object)((Object)form))) {
            return form;
        }
        return this.getByFormId(formKey);
    }

    @Override
    public Form getByFormId(String formId) {
        return (Form)this.bpmFormManager.get((Serializable)((Object)formId));
    }

    @Override
    public String getFormExportXml(String formKeyStr) {
        String[] formKeys;
        ArrayList<String> id = new ArrayList<String>();
        for (String formKey : formKeys = formKeyStr.split(",")) {
            Form form = this.bpmFormManager.getMainByFormKey(formKey);
            id.add(form.getId());
        }
        Map<String, String> map = this.bpmFormManager.exportForms(id, false);
        return map.get("form.xml");
    }

    @Override
    public void importForm(String formXmlStr) {
        try {
            this.bpmFormManager.importByFormXml(formXmlStr, null, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u5165\u8868\u5355\u5931\u8d25" + e.getMessage(), e);
        }
    }

    @Override
    public BoDef getBoDefByAlias(String alias) throws IOException {
        if (StringUtil.isEmpty((String)alias)) {
            throw new RuntimeException("Bo\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.boDefManager.getByAlias(alias);
    }

    @Override
    public List<BoResult> handlerBoData(String id, String defId, ObjectNode boData, String saveType) throws Exception {
        String permission;
        ObjectNode permissionObj;
        BoDataHandler handler = this.boInstanceFactory.getBySaveType(saveType);
        BoData curData = (BoData)JsonUtil.toBean((JsonNode)boData, BoData.class);
        if (BeanUtils.isNotEmpty((Object)boData.get("subMap"))) {
            this.handlerSubMap(curData, boData);
        }
        curData.setBoDefAlias(boData.get("boDef").get("alias").asText());
        HashMap<String, Map> boMap = new HashMap<String, Map>();
        boMap.put(boData.get("boDef").get("alias").asText(), curData.getData());
        String data = JsonUtil.toJson(boMap);
        if (StringUtil.isNotEmpty((String)id) && BeanUtils.isNotEmpty((Object)curData.getBoEnt()) && (BeanUtils.isNotEmpty((Object)curData.getBoEnt().getChildMap()) || BeanUtils.isNotEmpty((Object)curData.getSubMap())) && (permissionObj = (ObjectNode)JsonUtil.toJsonNode((String)(permission = this.bpmFormRightsService.getPermission((String)FormContextThreadUtil.getCommuVar((String)"formkey", (Object)""), AuthenticationUtil.getCurrentUserId(), (String)FormContextThreadUtil.getCommuVar((String)"flowKey", (Object)""), (String)FormContextThreadUtil.getCommuVar((String)"parentDefKey", (Object)""), (String)FormContextThreadUtil.getCommuVar((String)"nodeId", (Object)""))))).hasNonNull("subRowAuth")) {
            FormContextThreadUtil.putCommonVars((String)"subRowAuthJosn", (Object)JsonUtil.toJson((Object)permissionObj.get("subRowAuth")));
        }
        List list = handler.save(id, defId, curData);
        Object commuVar = FormContextThreadUtil.getCommuVar((String)"updateSubTableJson", (Object)"");
        ArrayNode updateArr = JsonUtil.getMapper().createArrayNode();
        if (BeanUtils.isNotEmpty((Object)commuVar)) {
            updateArr = (ArrayNode)JsonUtil.toJsonNode((String)((String)commuVar));
        }
        for (BoResult result : list) {
            if (JsonUtil.getString((JsonNode)((ObjectNode)updateArr.get(0)), (String)"boAlias", (String)"").equals(result.getBoAlias()) && "add".equals(result.getAction())) {
                FormDataTemplateManager dataTemplateManager = (FormDataTemplateManager)AppUtil.getBean(FormDataTemplateManager.class);
                for (JsonNode jsonNode : updateArr) {
                    ObjectNode updateObj = (ObjectNode)jsonNode;
                    updateObj.put("newValue", result.getPk());
                    dataTemplateManager.updateTempRefId(updateObj);
                }
            }
            if (!StringUtil.isNotEmpty((String)result.getModifyDetail())) continue;
            result.setData(data);
            break;
        }
        return list;
    }

    private void handlerSubMap(BoData curData, ObjectNode boData) throws JsonParseException, JsonMappingException, IOException {
        ObjectNode subMapNode = (ObjectNode)boData.get("subMap");
        Iterator fields = subMapNode.fields();
        while (fields.hasNext()) {
            Map.Entry next = (Map.Entry)fields.next();
            String key = (String)next.getKey();
            JsonNode jNode = (JsonNode)next.getValue();
            if (!jNode.isArray()) continue;
            ArrayList<BoData> datas = new ArrayList<BoData>();
            for (JsonNode jsonNode : jNode) {
                Iterator subFields = jsonNode.fields();
                BoData data = new BoData();
                HashMap sunBoDataMap = new HashMap();
                while (subFields.hasNext()) {
                    Map.Entry subNext = (Map.Entry)subFields.next();
                    String subkey = (String)subNext.getKey();
                    data.set(subkey, subNext.getValue());
                    if (!subkey.startsWith("sub_") || !BeanUtils.isNotEmpty(subNext.getValue())) continue;
                    JsonNode sunNode = (JsonNode)subNext.getValue();
                    ArrayList<BoData> sunBoDatas = new ArrayList<BoData>();
                    for (JsonNode itemNode : sunNode) {
                        BoData sunData = new BoData();
                        Iterator sunFields = itemNode.fields();
                        while (sunFields.hasNext()) {
                            Map.Entry sunNext = (Map.Entry)sunFields.next();
                            String sunkey = (String)sunNext.getKey();
                            sunData.set(sunkey, sunNext.getValue());
                        }
                        BoData bb = (BoData)JsonUtil.toBean((String)JsonUtil.toJson((Object)sunData), BoData.class);
                        sunBoDatas.add(bb);
                    }
                    sunBoDataMap.put(subkey, sunBoDatas);
                }
                BoData aa = (BoData)JsonUtil.toBean((String)JsonUtil.toJson((Object)data), BoData.class);
                if (!sunBoDataMap.isEmpty()) {
                    for (String sunKey : sunBoDataMap.keySet()) {
                        aa.setSubList(sunKey, (List)sunBoDataMap.get(sunKey));
                    }
                }
                datas.add(aa);
            }
            curData.setSubList(key, datas);
        }
    }

    @Override
    public BoData getBodataByDefCode(String saveMode, String code) {
        if (!this.boDefManager.getByAlias(code).isSupportDb()) {
            saveMode = "boObject";
        }
        BoDataHandler handler = this.boInstanceFactory.getBySaveType(saveMode);
        return handler.getByBoDefCode(code);
    }

    @Override
    public BoData getBodataById(String saveMode, String id, String code) throws IOException {
        BoDataHandler handler = this.boInstanceFactory.getBySaveType(saveMode);
        return handler.getById((Object)id, code);
    }

    @Override
    public String getBoDefExportXml(ObjectNode bodef) throws JAXBException, JsonParseException, JsonMappingException, IOException {
        ArrayNode arr = (ArrayNode)bodef.get("defList");
        BoDefXml bodefXml = new BoDefXml();
        List boList = (List)JsonUtil.toBean((String)JsonUtil.toJson((Object)arr), (TypeReference)new TypeReference<List<BoDef>>(){});
        bodefXml.setDefList(boList);
        String xml = JAXBUtil.marshall((Object)bodefXml, BoDefXml.class);
        return xml;
    }

    @Override
    public List<BoDef> importBo(String bodefXml) {
        List boDefs = this.boDefManager.parseXml(bodefXml);
        return this.boDefManager.importBoDef(boDefs);
    }

    @Override
    public List<BoDef> importBoDef(List<BoDef> bos) {
        return this.boDefManager.importBoDef(bos);
    }

    @Override
    public ObjectNode getBoJosn(String id) throws IOException {
        return this.boDefManager.getBOJson(id);
    }

    @Override
    public BoEnt getBoEntByName(String name) {
        return this.boDefService.getEntByName(name);
    }

    @Override
    public ObjectNode getMainBOEntByDefAliasOrId(String alias, String defId) throws IOException {
        List list = new ArrayList();
        if (BeanUtils.isNotEmpty((Object)defId)) {
            list = this.boEntManager.getByDefId(defId);
        } else {
            BoDef def = this.getBoDefByAlias(alias);
            if (BeanUtils.isNotEmpty((Object)def)) {
                defId = def.getId();
                list = this.boEntManager.getByDefId(def.getId());
            }
        }
        ObjectNode mainBoent = JsonUtil.getMapper().createObjectNode();
        ArrayNode childEntList = JsonUtil.getMapper().createArrayNode();
        for (BoEnt boEnt : list) {
            BoEntRel rel = this.boEntRelManager.getByDefIdAndEntId(defId, boEnt.getId());
            if (BeanUtils.isNotEmpty((Object)rel) && "main".equals(rel.getType())) {
                mainBoent = (ObjectNode)JsonUtil.toJsonNode((Object)boEnt);
                continue;
            }
            childEntList.add((JsonNode)((ObjectNode)JsonUtil.toJsonNode((Object)boEnt)));
        }
        if (BeanUtils.isNotEmpty((Object)mainBoent) && BeanUtils.isNotEmpty((Object)childEntList)) {
            mainBoent.set("childEnts", (JsonNode)childEntList);
        }
        return mainBoent;
    }

    @Override
    public List<BoData> getBoDataByBoKeys(List<String> boCode) {
        ArrayList<BoData> list = new ArrayList<BoData>();
        for (String code : boCode) {
            BoData bodataByDefCode = this.getBodataByDefCode("database", code);
            list.add(bodataByDefCode);
        }
        return list;
    }

    @Override
    public void removeDataByBusLink(JsonNode links) throws Exception {
        if (BeanUtils.isNotEmpty((Object)links)) {
            for (JsonNode jsonNode : links) {
                BoEnt ent;
                String idVal;
                ObjectNode link = (ObjectNode)jsonNode;
                String saveModel = link.get("saveMode").asText();
                String string = idVal = BeanUtils.isEmpty((Object)link.get("businesskeyStr")) ? link.get("businesskey").asText() : link.get("businesskeyStr").asText();
                if (link.get("saveMode").asText().equals("boObject")) {
                    String sql = "delete from form_bo_int where id_ = '" + idVal + "'";
                    this.jdbcTemplate.execute(sql);
                } else if (saveModel.equals("database") && BeanUtils.isNotEmpty((Object)(ent = this.boDefService.getEntByName(link.get("formIdentify").asText())))) {
                    String sql = "delete from " + ent.getTableName() + " where " + ent.getPkKey() + " = '" + idVal + "'";
                    if (ent.getIsExternal() == 1) {
                        try {
                            DataSourceUtil.getJdbcTempByDsAlias((String)ent.getDsName()).execute(sql);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        this.jdbcTemplate.execute(sql);
                    }
                }
                this.formRemindDataManager.deleteFormRemindDataByBoDataId((QueryWrapper)new QueryWrapper().eq((Object)"OPEM_ID", (Object)idVal));
            }
        }
    }

    @Override
    public Map<String, String> getFormAndBoExportXml(ObjectNode obj) throws JAXBException {
        String[] formKeys;
        String formKeyStr = obj.get("formKeys").asText();
        String defKeys = obj.get("defKeys").asText();
        ArrayList<String> id = new ArrayList<String>();
        for (String string : formKeys = formKeyStr.split(",")) {
            Form form = this.bpmFormManager.getMainByFormKey(string);
            if (!BeanUtils.isNotEmpty((Object)((Object)form))) continue;
            id.add(form.getId());
        }
        Map<String, String> map = this.bpmFormManager.exportForms(id, true);
        String[] defKeyArr = defKeys.split(",");
        FormRightXml formRightList = new FormRightXml();
        for (String defKey : defKeyArr) {
            List<FormRight> bpmFormRight = this.bpmFormRightsService.getFormRigthListByFlowKey(defKey);
            formRightList.addBpmFormRight(bpmFormRight);
        }
        String string = JAXBUtil.marshall((Object)formRightList, FormRightXml.class);
        map.put("formrights.xml", string);
        return map;
    }

    @Override
    public CommonResult<String> importFormAndBo(ObjectNode obj, String typeId) throws Exception {
        String formXmlStr = obj.get("formXmlStr").asText();
        String boXmlStr = obj.get("boXmlStr").asText();
        List boDefs = this.boDefManager.parseXml(boXmlStr);
        this.removeDuplicate(boDefs);
        Map<String, String> nameMap = this.getEntIdMap(boDefs, null);
        List importBoDef = this.boDefManager.importBoDef(boDefs);
        this.bpmFormManager.importByFormXml(formXmlStr, typeId, importBoDef, nameMap);
        if (obj.has("formRightsXml")) {
            String formRightsXml = obj.get("formRightsXml").asText();
            this.bpmFormRightManager.importFormRights(formRightsXml);
        }
        return new CommonResult("\u5bfc\u5165\u6210\u529f");
    }

    private void removeDuplicate(List<BoDef> boDefs) {
        if (BeanUtils.isNotEmpty(boDefs)) {
            HashSet<String> defCodes = new HashSet<String>();
            ArrayList<BoDef> defList = new ArrayList<BoDef>();
            for (BoDef boDef : boDefs) {
                if (defCodes.contains(boDef.getAlias())) continue;
                defCodes.add(boDef.getAlias());
                defList.add(boDef);
            }
            boDefs = defList;
        }
    }

    @Override
    public BoData getByFormRestfulModel(FormRestfulModel model) throws IOException {
        BoDef boDef = this.boDefManager.getPureByAlias(model.getCode());
        String saveType = model.getSaveType();
        if (boDef != null && !boDef.isSupportDb()) {
            saveType = "boObject";
        }
        FormContextThreadUtil.putCommonVars((String)"defId", (Object)model.getFlowDefId());
        FormContextThreadUtil.putCommonVars((String)"nodeId", (Object)model.getNodeId());
        FormContextThreadUtil.putCommonVars((String)"parentDefKey", (Object)model.getParentFlowKey());
        FormContextThreadUtil.putCommonVars((String)"subRowAuthJosn", (Object)model.getSubRowAuthJosn());
        BoData boData = this.getBodataById(saveType, model.getBoid(), model.getCode());
        boData.setBoDefAlias(boData.getBoDef().getAlias());
        return boData;
    }

    private Map<String, String> getEntIdMap(List<BoDef> importBoDef, Map<String, String> nameMap) {
        HashMap<String, String> entIdMap = new HashMap<String, String>();
        if (BeanUtils.isNotEmpty(importBoDef)) {
            for (BoDef def : importBoDef) {
                if (!BeanUtils.isNotEmpty((Object)def.getBoEnt())) continue;
                BoEnt ent = def.getBoEnt();
                if (BeanUtils.isNotEmpty((Object)ent.getBoAttrList())) {
                    if (BeanUtils.isNotEmpty(nameMap)) {
                        entIdMap.put(nameMap.get(ent.getName()), ent.getId());
                    } else {
                        entIdMap.put(ent.getName(), ((BoAttribute)ent.getBoAttrList().get(0)).getEntId());
                    }
                }
                if (!BeanUtils.isNotEmpty((Object)ent.getChildEntList())) continue;
                List subEnts = ent.getChildEntList();
                for (BoEnt subEnt : subEnts) {
                    if (BeanUtils.isNotEmpty((Object)subEnt.getBoAttrList())) {
                        if (BeanUtils.isNotEmpty(nameMap)) {
                            entIdMap.put(nameMap.get(subEnt.getName()), subEnt.getId());
                        } else {
                            entIdMap.put(subEnt.getName(), ((BoAttribute)subEnt.getBoAttrList().get(0)).getEntId());
                        }
                    }
                    if (!BeanUtils.isNotEmpty((Object)subEnt.getChildEntList())) continue;
                    List sunEnts = subEnt.getChildEntList();
                    for (BoEnt sunEnt : sunEnts) {
                        if (!BeanUtils.isNotEmpty((Object)sunEnt.getBoAttrList()) || !BeanUtils.isNotEmpty((Object)subEnt.getBoAttrList())) continue;
                        if (BeanUtils.isNotEmpty(nameMap)) {
                            entIdMap.put(nameMap.get(sunEnt.getName()), sunEnt.getId());
                            continue;
                        }
                        entIdMap.put(sunEnt.getName(), ((BoAttribute)sunEnt.getBoAttrList().get(0)).getEntId());
                    }
                }
            }
        }
        return entIdMap;
    }

    @Override
    public List<List<BoResult>> batchHandlerBoData(List<FormRestfulModel> models) throws Exception {
        ArrayList<List<BoResult>> list = new ArrayList<List<BoResult>>();
        for (FormRestfulModel model : models) {
            FormContextThreadUtil.putCommonVars((String)"defId", (Object)model.getFlowDefId());
            FormContextThreadUtil.putCommonVars((String)"nodeId", (Object)model.getNodeId());
            FormContextThreadUtil.putCommonVars((String)"flowKey", (Object)model.getFlowKey());
            FormContextThreadUtil.putCommonVars((String)"formkey", (Object)model.getFormkey());
            FormContextThreadUtil.putCommonVars((String)"parentDefKey", (Object)(StringUtil.isEmpty((String)model.getParentFlowKey()) ? "" : model.getParentFlowKey()));
            if (StringUtil.isNotEmpty((String)model.getUpdateSubTableJson())) {
                FormContextThreadUtil.putCommonVars((String)"updateSubTableJson", (Object)model.getUpdateSubTableJson());
            }
            if (StringUtil.isNotEmpty((String)model.getHasCheckFormDataRev())) {
                FormContextThreadUtil.putCommonVars((String)"hasCheckFormDataRev", (Object)model.getHasCheckFormDataRev());
            }
            List<BoResult> result = this.handlerBoData(model.getBoid(), model.getDefId(), model.getBoData(), model.getSaveType());
            list.add(result);
        }
        return list;
    }

    @Override
    public List<BoDef> getBodefWithMainEntByAlias(String alias) throws NotFoundException {
        if (StringUtil.isEmpty((String)alias)) {
            throw new RuntimeException("Bo\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<BoDef> list = new ArrayList<BoDef>();
        for (String boDef : alias.split(",")) {
            BoDef byAlias = this.boDefManager.getByAlias(boDef);
            if (BeanUtils.isEmpty((Object)byAlias)) {
                throw new NotFoundException(String.format("\u6839\u636e\u6570\u636e\u5efa\u6a21\u522b\u540d\u3010%s\u3011\u672a\u627e\u5230\u6570\u636e\u5efa\u6a21", byAlias));
            }
            list.add(byAlias);
        }
        return list;
    }
}

