/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.conf;

import com.artfess.base.util.Base64;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.UnsupportedEncodingException;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="sso")
public class SsoConfig {
    public static final String MODE_CAS = "cas";
    public static final String MODE_OAUTH = "oauth";
    public static final String MODE_JWT = "jwt";
    private boolean enable;
    private String mode;
    private Cas cas;
    private Oauth oauth;

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Cas getCas() {
        return this.cas;
    }

    public void setCas(Cas cas) {
        this.cas = cas;
    }

    public Oauth getOauth() {
        return this.oauth;
    }

    public void setOauth(Oauth oauth) {
        this.oauth = oauth;
    }

    public String getCasUrl() {
        return this.cas.getUrl();
    }

    public String getSsoUrl() {
        String ssoUrl = null;
        if (this.enable) {
            if (MODE_CAS.equals(this.mode)) {
                ssoUrl = this.cas.getUrl() + "?service=";
            } else if (MODE_OAUTH.equals(this.mode)) {
                String stufix = String.format("%s?response_type=code&client_id=%s&client_secret=%s&redirect_uri=", this.oauth.getLoginPath(), this.oauth.getClientId(), this.oauth.getSecret());
                ssoUrl = this.oauth.getUrl() + stufix;
            }
        }
        return ssoUrl;
    }

    public String getSsoLogoutUrl() {
        String ssoLogoutUrl = null;
        if (this.enable) {
            if (MODE_CAS.equals(this.mode)) {
                ssoLogoutUrl = this.cas.getUrl() + "/logout?service=";
            } else if (MODE_OAUTH.equals(this.mode)) {
                ssoLogoutUrl = this.oauth.getUrl() + "/logout?redirect_uri=";
            }
        }
        return ssoLogoutUrl;
    }

    public String getOauthTokenUrl() {
        String url = null;
        if (this.enable && MODE_OAUTH.equals(this.mode)) {
            String stufix = String.format("%s?grant_type=authorization_code&client_id=%s&client_secret=%s", this.oauth.getTokenPath(), this.oauth.getClientId(), this.oauth.getSecret());
            url = this.oauth.getUrl() + stufix;
        }
        return url;
    }

    public String getOauthCheckUrl() {
        String url = null;
        if (this.enable && MODE_OAUTH.equals(this.mode)) {
            String stufix = String.format("%s?%s=", this.oauth.getCheckPath(), StringUtil.isNotEmpty(this.oauth.getCheckPathKey()) ? this.oauth.getCheckPathKey() : "access_token");
            url = this.oauth.getUrl() + stufix;
        }
        return url;
    }

    public String getOauthUsernameKey() {
        String usernameKey = "";
        if (this.enable && MODE_OAUTH.equals(this.mode)) {
            usernameKey = StringUtil.isNotEmpty(this.oauth.getUsernameKey()) ? this.oauth.getUsernameKey() : "username";
        }
        return usernameKey;
    }

    public String getOauthAccesstokenKey() {
        String accesstokenKey = "";
        if (this.enable && MODE_OAUTH.equals(this.mode)) {
            accesstokenKey = StringUtil.isNotEmpty(this.oauth.getAccesstokenKey()) ? this.oauth.getAccesstokenKey() : "access_token";
        }
        return accesstokenKey;
    }

    public String getOauthBasicHeader() throws UnsupportedEncodingException {
        String basicStr = this.oauth.getClientId() + ":" + this.oauth.getSecret();
        ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
        objectNode.put("Authorization", "Basic " + Base64.getBase64(basicStr));
        String json = objectNode.toString();
        return Base64.getBase64(json);
    }

    static class Oauth {
        private String url;
        private String loginPath;
        private String tokenPath;
        private String checkPath;
        private String clientId;
        private String secret;
        private String checkPathKey;
        private String accesstokenKey;
        private String usernameKey;

        Oauth() {
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getLoginPath() {
            return this.loginPath;
        }

        public void setLoginPath(String loginPath) {
            this.loginPath = loginPath;
        }

        public String getTokenPath() {
            return this.tokenPath;
        }

        public void setTokenPath(String tokenPath) {
            this.tokenPath = tokenPath;
        }

        public String getCheckPath() {
            return this.checkPath;
        }

        public void setCheckPath(String checkPath) {
            this.checkPath = checkPath;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public String getCheckPathKey() {
            return this.checkPathKey;
        }

        public void setCheckPathKey(String checkPathKey) {
            this.checkPathKey = checkPathKey;
        }

        public String getAccesstokenKey() {
            return this.accesstokenKey;
        }

        public void setAccesstokenKey(String accesstokenKey) {
            this.accesstokenKey = accesstokenKey;
        }

        public String getUsernameKey() {
            return this.usernameKey;
        }

        public void setUsernameKey(String usernameKey) {
            this.usernameKey = usernameKey;
        }
    }

    static class Cas {
        private String url;

        Cas() {
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

