/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.query.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.query.manager.BizQueryTagConditionManager;
import com.artfess.query.model.BizQueryTagCondition;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u67e5\u67e5--\u6309\u6807\u7b7e\u5206\u7c7b\u67e5\u8be2\u6761\u4ef6\u8868"})
@ApiGroup(group={"group_biz_query"})
@RestController
@RequestMapping(value={"/query/tagCondition/v1/"})
public class BizQueryTagConditionController
extends BaseController<BizQueryTagConditionManager, BizQueryTagCondition> {
    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58\u6309\u6807\u7b7e\u5206\u7c7b\u67e5\u8be2\u6761\u4ef6\u8868")
    @PostMapping(value={"saveBatchTagCondition"})
    public CommonResult<String> saveBatchTagCondition(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) List<BizQueryTagCondition> tagList) throws Exception {
        boolean status = ((BizQueryTagConditionManager)this.baseService).saveOrUpdateBatch(tagList);
        return status ? CommonResult.success(null, (String)"\u6279\u91cf\u4fdd\u5b58\u6309\u6807\u7b7e\u5206\u7c7b\u67e5\u8be2\u6761\u4ef6\u8868\u6210\u529f") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation(value="\u6839\u636e\u6807\u7b7e\u67e5\u8be2\u5bf9\u5e94\u914d\u7f6e\u7684\u6761\u4ef6\u4fe1\u606f")
    @PostMapping(value={"qureyConditionByTag"})
    public CommonResult<String> qureyConditionByTag(@RequestParam String tagId) {
        List<BizQueryTagCondition> list = ((BizQueryTagConditionManager)this.baseService).qureyConditionByTag(tagId);
        ArrayList<Map> reList = new ArrayList<Map>();
        if (!CollectionUtils.isEmpty(list)) {
            Map<String, List<BizQueryTagCondition>> map = list.stream().collect(Collectors.groupingBy(BizQueryTagCondition::getQueryCatalogs));
            for (Map.Entry<String, List<BizQueryTagCondition>> entry : map.entrySet()) {
                String key = entry.getKey();
                List<BizQueryTagCondition> value = entry.getValue();
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("group", key);
                result.put("size", value.size());
                result.put("data", value);
                result.put("sn", value.get(0).getSn());
                reList.add(result);
            }
            reList.sort(Comparator.comparing(remap -> (Comparable)remap.get("sn"), Comparator.nullsFirst(Comparator.naturalOrder())));
        }
        return CommonResult.success(reList, (String)"\u83b7\u53d6\u6210\u529f\uff01");
    }
}

