/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataResource.ods.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataResource.ods.dao.BizOdsFieldDao;
import com.artfess.dataShare.dataResource.ods.manager.BizOdsFieldManager;
import com.artfess.dataShare.dataResource.ods.manager.BizOdsTableManager;
import com.artfess.dataShare.dataResource.ods.model.BizOdsField;
import com.artfess.dataShare.dataResource.ods.model.BizOdsTable;
import com.artfess.dataShare.dataResource.ods.vo.BizOdsFieldVo;
import com.artfess.dataShare.util.DorisUtils;
import com.artfess.dataShare.util.FieldUtil;
import com.artfess.poi.util.ExcelTool;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizOdsFieldManagerImpl
extends BaseManagerImpl<BizOdsFieldDao, BizOdsField>
implements BizOdsFieldManager {
    @Resource
    BizOdsTableManager tableManager;
    @Resource
    private BizOdsFieldManager fieldManager;

    @Override
    public List<BizOdsField> queryFieldByTableId(String tableId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"table_id_", (Object)tableId);
        queryWrapper.orderByAsc((Object)"sn_");
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void export(MultipartFile file, String tableId) throws Exception {
        BizOdsTable table = (BizOdsTable)this.tableManager.get((Serializable)((Object)tableId));
        if (null == table) {
            throw new ApplicationException("\u672a\u67e5\u8be2\u5230\u5b9e\u4f53\u8868");
        }
        String tableName = table.getTableNameEn();
        ExcelTool util = new ExcelTool(BizOdsFieldVo.class);
        List list = util.importExcel(file.getInputStream(), Integer.valueOf(2), Integer.valueOf(2));
        list = list.stream().filter(vo -> StringUtil.isNotEmpty((String)vo.getFieldName())).collect(Collectors.toList());
        List<BizOdsField> oldFields = this.fieldManager.queryFieldByTableId(tableId);
        Set<Object> manageFields = new HashSet();
        if (BeanUtils.isNotEmpty(oldFields) && oldFields.size() > 0) {
            manageFields = oldFields.stream().filter(entity -> "1".equals(entity.getFieldType())).map(entity -> entity.getFieldName()).collect(Collectors.toSet());
        }
        for (int i = 1; i < list.size(); ++i) {
            BizOdsFieldVo vo2 = (BizOdsFieldVo)list.get(i);
            if (manageFields.contains(vo2.getFieldName()) || !this.checkExistsField(tableId, vo2.getFieldName())) continue;
            throw new BaseException("\u8868\u3010" + table.getTableNameCh() + "\u4e2d\u5b58\u5728\u5b57\u6bb5(" + vo2.getName() + ")\u3011\u8bf7\u4fee\u6539\u540e\u5728\u5bfc\u5165");
        }
        List disFieldList = list.stream().map(p -> p.getFieldName()).distinct().collect(Collectors.toList());
        if (disFieldList.size() < list.size()) {
            throw new BaseException("\u8868" + table.getTableNameCh() + "\u4e2d\u5b58\u5728\u91cd\u590d\u5b57\u6bb5\u540d\u8bf7\u4fee\u6539\u540e\u5728\u4fdd\u5b58");
        }
        for (int i = 1; i < list.size(); ++i) {
            BizOdsFieldVo vo3 = (BizOdsFieldVo)list.get(i);
            if (StringUtil.isEmpty((String)vo3.getFieldName()) || manageFields.contains(vo3.getFieldName())) continue;
            BizOdsField field = BizOdsFieldVo.parse(vo3);
            field.setTableId(tableId);
            if ("\u7ba1\u7406\u5b57\u6bb5".equals(vo3.getFieldType())) {
                field.setFieldType("1");
            } else if ("\u4e1a\u52a1\u5b57\u6bb5".equals(vo3.getFieldType())) {
                field.setFieldType("2");
            }
            Integer attrLength = field.getAttrLength() == null ? 0 : field.getAttrLength();
            Integer decimalLen = field.getDecimalLen() == null ? 4 : field.getDecimalLen();
            String fieldSq = "ALTER TABLE `" + tableName + "` ADD COLUMN `" + field.getFieldName() + "` " + FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) + " NULL COMMENT '" + field.getDesc() + "' ";
            field.setDecimalLen(decimalLen);
            field.setFlSql(fieldSq);
            field.setCode(field.getFieldName());
            field.setMouldName(table.getName());
            field.setMouldCode(table.getCode());
            field.setIsDele("0");
            this.create((Model)field);
        }
    }

    @Override
    public void saveOrUpdates(List<BizOdsField> field) {
        List disFieldList = field.stream().map(p -> p.getFieldName()).distinct().collect(Collectors.toList());
        if (disFieldList.size() < field.size()) {
            throw new BaseException("\u8868\u4e2d\u5b58\u5728\u91cd\u590d\u5b57\u6bb5\u540d\u8bf7\u4fee\u6539\u540e\u5728\u4fdd\u5b58");
        }
        String tableId = field.get(0).getTableId();
        BizOdsTable table = (BizOdsTable)this.tableManager.get((Serializable)((Object)tableId));
        if (null == table) {
            throw new ApplicationException("\u672a\u67e5\u8be2\u5230\u5b9e\u4f53\u8868");
        }
        String tableName = table.getTableNameEn();
        List<BizOdsField> oldFields = this.queryFieldByTableId(tableId);
        if (BeanUtils.isNotEmpty(oldFields) && oldFields.size() > 0) {
            this.removeByIds(oldFields.stream().filter(p -> "2".equals(p.getFieldType())).map(entity -> entity.getId()).collect(Collectors.toList()));
        }
        if (oldFields.size() == 0) {
            this.addManageField(oldFields);
        }
        for (BizOdsField item : field) {
            if (StringUtil.isEmpty((String)item.getId())) {
                if (this.checkExistsField(tableId, item.getFieldName())) {
                    throw new BaseException("\u8868\u4e2d\u5b58\u5728\u5b57\u6bb5(" + item.getFieldName() + ")\u8bf7\u4fee\u6539\u540e\u5728\u5bfc\u5165");
                }
            } else if (this.checkExistsField(tableId, item.getFieldName(), item.getId())) {
                throw new BaseException("\u8868\u4e2d\u5b58\u5728\u5b57\u6bb5(" + item.getFieldName() + "\u8bf7\u4fee\u6539\u540e\u5728\u5bfc\u5165");
            }
            item.setTableId(tableId);
            item.setFieldName(item.getCode());
            item.setId(null);
            Integer attrLength = item.getAttrLength() == null ? 0 : item.getAttrLength();
            Integer decimalLen = item.getDecimalLen() == null ? 4 : item.getDecimalLen();
            String fieldSq = "ALTER TABLE `" + tableName + "` ADD COLUMN `" + item.getFieldName() + "` " + FieldUtil.getColumnType(item.getDataType(), attrLength, attrLength, decimalLen) + " NULL COMMENT '" + item.getDesc() + "' ";
            item.setFlSql(fieldSq);
        }
        if (field.size() > 0) {
            this.saveBatch(field);
        }
    }

    private void addManageField(List<BizOdsField> fieldList) {
        BizOdsField createBy = new BizOdsField();
        createBy.setFieldName("CREATE_BY_");
        createBy.setName("\u521b\u5efa\u4eba");
        createBy.setCode("CREATE_BY_");
        createBy.setDesc("\u521b\u5efa\u4eba");
        createBy.setDataType("varchar");
        createBy.setAttrLength(200);
        createBy.setIsPk("0");
        createBy.setIsRequired("0");
        createBy.setIsEncrypt("0");
        createBy.setDecimalLen(0);
        createBy.setFieldType("1");
        createBy.setIsDele("0");
        BizOdsField createOrgId = new BizOdsField();
        createOrgId.setFieldName("CREATE_ORG_ID_");
        createOrgId.setName("\u521b\u5efa\u5355\u4f4d");
        createOrgId.setCode("CREATE_ORG_ID_");
        createOrgId.setDesc("\u521b\u5efa\u5355\u4f4d");
        createOrgId.setDataType("varchar");
        createOrgId.setAttrLength(200);
        createOrgId.setIsPk("0");
        createOrgId.setIsRequired("0");
        createOrgId.setIsEncrypt("0");
        createOrgId.setDecimalLen(0);
        createOrgId.setFieldType("1");
        createOrgId.setIsDele("0");
        BizOdsField createTime = new BizOdsField();
        createTime.setFieldName("CREATE_TIME_");
        createTime.setName("\u521b\u5efa\u65f6\u95f4");
        createTime.setCode("CREATE_TIME_");
        createTime.setDesc("\u521b\u5efa\u65f6\u95f4");
        createTime.setDataType("date");
        createTime.setAttrLength(0);
        createTime.setIsPk("0");
        createTime.setIsRequired("0");
        createTime.setIsEncrypt("0");
        createTime.setDecimalLen(0);
        createTime.setFieldType("1");
        createTime.setIsDele("0");
        BizOdsField id = new BizOdsField();
        id.setFieldName("ID_");
        id.setName("\u4e3b\u952e");
        id.setCode("ID_");
        id.setDesc("\u4e3b\u952e");
        id.setDataType("varchar");
        id.setAttrLength(500);
        id.setIsPk("1");
        id.setIsRequired("0");
        id.setIsEncrypt("0");
        id.setDecimalLen(0);
        id.setFieldType("1");
        id.setIsDele("0");
        id.setSn(-1);
        Set set = fieldList.stream().map(entity -> entity.getCode()).collect(Collectors.toSet());
        if (!set.contains(createBy.getCode())) {
            fieldList.add(createBy);
        }
        if (!set.contains(createOrgId.getCode())) {
            fieldList.add(createOrgId);
        }
        if (!set.contains(createTime.getCode())) {
            fieldList.add(createTime);
        }
        if (!set.contains(id.getCode())) {
            fieldList.add(id);
        }
    }

    public boolean checkExistsField(String tableId, String fieldName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TABLE_ID_", (Object)tableId);
        queryWrapper.eq((Object)"FIELD_NAME_", (Object)fieldName);
        int count = this.count((Wrapper)queryWrapper);
        return count > 0;
    }

    public boolean checkExistsField(String tableId, String fieldName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TABLE_ID_", (Object)tableId);
        queryWrapper.eq((Object)"FIELD_NAME_", (Object)fieldName);
        queryWrapper.ne((Object)"ID_", (Object)id);
        int count = this.count((Wrapper)queryWrapper);
        return count > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateFields(List<BizOdsField> fields) throws Exception {
        if (fields.size() == 0) {
            throw new ApplicationException("\u6ca1\u6709\u4fee\u6539\u7684\u5b57\u6bb5");
        }
        String tableId = fields.get(0).getTableId();
        BizOdsTable table = (BizOdsTable)this.tableManager.get((Serializable)((Object)tableId));
        List disFieldList = fields.stream().map(p -> p.getCode()).distinct().collect(Collectors.toList());
        if (disFieldList.size() < fields.size()) {
            throw new BaseException("\u8868\u4e2d\u5b58\u5728\u91cd\u590d\u5b57\u6bb5\u540d\u8bf7\u4fee\u6539\u540e\u5728\u4fdd\u5b58");
        }
        String tableName = table.getTableNameEn();
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"ods");
        for (BizOdsField field : fields) {
            String fieldSq;
            field.setIsCreate("1");
            Integer attrLength = field.getAttrLength() == null ? 0 : field.getAttrLength();
            Integer decimalLen = field.getDecimalLen() == null ? 4 : field.getDecimalLen();
            field.setDecimalLen(decimalLen);
            field.setFieldName(field.getCode());
            if (StringUtil.isEmpty((String)field.getId())) {
                field.setMouldCode(fields.get(0).getMouldCode());
                field.setMouldName(fields.get(0).getMouldName());
                if (field.getSn() == null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("TABLE_ID_", tableId);
                    field.setSn(this.getNextSequence(map));
                }
                String fieldSq2 = "ALTER TABLE `" + tableName + "` ADD COLUMN `" + field.getFieldName() + "` " + FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) + " NULL COMMENT '" + field.getDesc() + "' ";
                field.setFlSql(fieldSq2);
                template.execute(fieldSq2);
                continue;
            }
            if (!this.fieldEquals(field)) continue;
            BizOdsField oldField = (BizOdsField)((Object)this.getById((Serializable)((Object)field.getId())));
            if (!field.getFieldName().equals(oldField.getFieldName())) {
                fieldSq = "ALTER TABLE `" + tableName + "` RENAME COLUMN `" + oldField.getFieldName() + "` `" + field.getFieldName() + "` ";
                template.execute(fieldSq);
            }
            if (field.getDesc().equals(oldField.getDesc())) continue;
            fieldSq = "ALTER TABLE `" + tableName + "` MODIFY COLUMN `" + field.getFieldName() + "`  COMMENT '" + field.getDesc() + "' ";
            template.execute(fieldSq);
        }
        this.saveOrUpdateBatch(fields);
        String createSql = DorisUtils.getOdsTableSql(table.getTableNameEn(), table.getTableDesc(), fields);
        table.setCreateTableSql(createSql);
        table.setFieldTotal(fields.size());
        this.tableManager.updateById((Object)table);
    }

    public boolean fieldEquals(BizOdsField field) {
        BizOdsField oldField = (BizOdsField)((Object)this.getById((Serializable)((Object)field.getId())));
        return !field.getFieldName().equals(oldField.getFieldName()) || !field.getDesc().equals(oldField.getDesc());
    }
}

