/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.def.impl.handler;

import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.model.process.def.BpmBoDef;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.ProcBoDef;
import com.artfess.bpm.engine.def.AbstractBpmDefXmlHandler;
import com.artfess.bpm.engine.def.DefXmlHandlerUtil;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.jamesmurty.utils.XMLBuilder;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class BoBpmDefXmlHandler
extends AbstractBpmDefXmlHandler<BpmBoDef> {
    @Override
    protected String getXml(String defId, String nodeId, BpmBoDef boDef) {
        String xml = this.getXml(boDef);
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        String defXml = def.getBpmnXml();
        String xParentPath = "//ext:extProcess";
        String xPath = "//ext:extProcess/ext:boList";
        String rtnXml = DefXmlHandlerUtil.getXml(defXml, xml, xParentPath, xPath);
        return rtnXml;
    }

    private String getXml(BpmBoDef bodef) {
        List<ProcBoDef> list = bodef.getBoDefs();
        if (BeanUtils.isEmpty(list)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("<ext:boList xmlns:ext=\"http://www.jee-soft.cn/bpm\" saveMode=\"" + bodef.getBoSaveMode() + "\" >\n");
            for (ProcBoDef boDef : list) {
                String isRequired = boDef.isRequired() ? "1" : "0";
                XMLBuilder xmlBuilder = XMLBuilder.create((String)"ext:boDef").a("name", boDef.getName()).a("isRequired", isRequired).a("key", boDef.getKey()).a("parentDefKey", boDef.getParentDefKey());
                sb.append(xmlBuilder.asString() + "\n");
            }
            sb.append("</ext:boList>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

