/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bpm.exception.BusinessException;
import com.artfess.workflow.runtime.constant.SignSequenceStatus;
import com.artfess.workflow.runtime.dao.BpmTaskSignSequenceDao;
import com.artfess.workflow.runtime.manager.BpmTaskSignSequenceManager;
import com.artfess.workflow.runtime.model.BpmTaskSignSequence;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmTaskSignSequenceManager")
public class BpmTaskSignSequenceManagerImpl
extends BaseManagerImpl<BpmTaskSignSequenceDao, BpmTaskSignSequence>
implements BpmTaskSignSequenceManager {
    @Override
    @Transactional
    public void updateStatus(String procInstId, String rootTaskId, String statusa, String statusb) {
        ((BpmTaskSignSequenceDao)this.baseMapper).updateStatus(procInstId, rootTaskId, statusa, statusb);
    }

    @Override
    public BpmTaskSignSequence getByTaskId(String id) {
        return ((BpmTaskSignSequenceDao)this.baseMapper).getByTaskId(id);
    }

    @Override
    @Transactional
    public Map<String, String> getNextExecutor(String taskId) {
        BpmTaskSignSequence curSignSequence = this.getByTaskId(taskId);
        String path = curSignSequence.getPath();
        curSignSequence.setStatus(SignSequenceStatus.COMPLETE.getKey());
        String nextTaskId = UniqueIdUtil.getSuid();
        curSignSequence.setNextTaskId(nextTaskId);
        super.update((Model)curSignSequence);
        List<BpmTaskSignSequence> pathSign = ((BpmTaskSignSequenceDao)this.baseMapper).getByStatusAndPath(SignSequenceStatus.WAITINGFORGENERATIONSIGNATURETASK.getKey(), path);
        while (BeanUtils.isEmpty(pathSign) && path.length() > 0 && path.contains(".")) {
            path = path.substring(0, path.lastIndexOf("."));
            ((BpmTaskSignSequenceDao)this.baseMapper).updateStatusByPath(path, SignSequenceStatus.HALF.getKey(), SignSequenceStatus.COMPLETE.getKey());
            pathSign = ((BpmTaskSignSequenceDao)this.baseMapper).getByStatusAndPath(SignSequenceStatus.WAITINGFORGENERATIONSIGNATURETASK.getKey(), path);
        }
        if (BeanUtils.isEmpty(pathSign)) {
            return null;
        }
        BpmTaskSignSequence nextBpmTaskSignSequence = pathSign.get(0);
        String executor = nextBpmTaskSignSequence.getExecutor();
        Map<String, String> resultMap = new HashMap();
        try {
            resultMap = JsonUtil.toMap((String)executor);
        }
        catch (IOException e) {
            throw new BusinessException("\u7b7e\u7f72\u5931\u8d25");
        }
        nextBpmTaskSignSequence.setTaskId(nextTaskId);
        nextBpmTaskSignSequence.setStatus(SignSequenceStatus.INAPPROVAL.getKey());
        this.update((Model)nextBpmTaskSignSequence);
        resultMap.put("taskId", nextBpmTaskSignSequence.getTaskId());
        return resultMap;
    }

    @Override
    public BpmTaskSignSequence getInApprovalByInstNodeId(String instId, String rootTaskId, String nodeId) {
        return ((BpmTaskSignSequenceDao)this.baseMapper).getInApprovalByInstNodeId(instId, rootTaskId, nodeId);
    }

    @Override
    @Transactional
    public void removeByPath(String path) {
        ((BpmTaskSignSequenceDao)this.baseMapper).removeByPath(path);
    }

    @Override
    @Transactional
    public void removeByInstNodeId(String instanceId, String rootTaskId, String nodeId) {
        ((BpmTaskSignSequenceDao)this.baseMapper).removeByInstNodeId(instanceId, rootTaskId, nodeId);
    }

    @Override
    public Map<String, String> demoNextExecutor(String taskId) {
        BpmTaskSignSequence curSignSequence = this.getByTaskId(taskId);
        String path = curSignSequence.getPath();
        List<BpmTaskSignSequence> pathSign = ((BpmTaskSignSequenceDao)this.baseMapper).getByStatusAndPath(SignSequenceStatus.WAITINGFORGENERATIONSIGNATURETASK.getKey(), path);
        while (BeanUtils.isEmpty(pathSign) && path.length() > 0 && path.contains(".")) {
            path = path.substring(0, path.lastIndexOf("."));
            pathSign = ((BpmTaskSignSequenceDao)this.baseMapper).getByStatusAndPath(SignSequenceStatus.WAITINGFORGENERATIONSIGNATURETASK.getKey(), path);
        }
        if (BeanUtils.isEmpty(pathSign)) {
            return null;
        }
        BpmTaskSignSequence nextBpmTaskSignSequence = pathSign.get(0);
        String executor = nextBpmTaskSignSequence.getExecutor();
        HashMap<String, String> resultMap = new HashMap();
        try {
            resultMap = JsonUtil.toMap((String)executor);
        }
        catch (IOException e) {
            throw new BusinessException("\u7b7e\u7f72\u5931\u8d25");
        }
        return resultMap;
    }
}

