/**
 * @fileoverview Collects the built-in rules into a map structure so that they can be imported all at once and without
 * using the file-system directly.
 * @author Peter (Somogyvari) Metz
 */

"use strict";

/* eslint sort-keys: ["error", "asc"] */

module.exports = {
    "accessor-pairs": require("./rules/accessor-pairs"),
    "array-bracket-newline": require("./rules/array-bracket-newline"),
    "array-bracket-spacing": require("./rules/array-bracket-spacing"),
    "array-callback-return": require("./rules/array-callback-return"),
    "array-element-newline": require("./rules/array-element-newline"),
    "arrow-body-style": require("./rules/arrow-body-style"),
    "arrow-parens": require("./rules/arrow-parens"),
    "arrow-spacing": require("./rules/arrow-spacing"),
    "block-scoped-var": require("./rules/block-scoped-var"),
    "block-spacing": require("./rules/block-spacing"),
    "brace-style": require("./rules/brace-style"),
    "callback-return": require("./rules/callback-return"),
    camelcase: require("./rules/camelcase"),
    "capitalized-comments": require("./rules/capitalized-comments"),
    "class-methods-use-this": require("./rules/class-methods-use-this"),
    "comma-dangle": require("./rules/comma-dangle"),
    "comma-spacing": require("./rules/comma-spacing"),
    "comma-style": require("./rules/comma-style"),
    complexity: require("./rules/complexity"),
    "computed-property-spacing": require("./rules/computed-property-spacing"),
    "consistent-return": require("./rules/consistent-return"),
    "consistent-this": require("./rules/consistent-this"),
    "constructor-super": require("./rules/constructor-super"),
    curly: require("./rules/curly"),
    "default-case": require("./rules/default-case"),
    "dot-location": require("./rules/dot-location"),
    "dot-notation": require("./rules/dot-notation"),
    "eol-last": require("./rules/eol-last"),
    eqeqeq: require("./rules/eqeqeq"),
    "for-direction": require("./rules/for-direction"),
    "func-call-spacing": require("./rules/func-call-spacing"),
    "func-name-matching": require("./rules/func-name-matching"),
    "func-names": require("./rules/func-names"),
    "func-style": require("./rules/func-style"),
    "function-paren-newline": require("./rules/function-paren-newline"),
    "generator-star-spacing": require("./rules/generator-star-spacing"),
    "getter-return": require("./rules/getter-return"),
    "global-require": require("./rules/global-require"),
    "guard-for-in": require("./rules/guard-for-in"),
    "handle-callback-err": require("./rules/handle-callback-err"),
    "id-blacklist": require("./rules/id-blacklist"),
    "id-length": require("./rules/id-length"),
    "id-match": require("./rules/id-match"),
    "implicit-arrow-linebreak": require("./rules/implicit-arrow-linebreak"),
    indent: require("./rules/indent"),
    "indent-legacy": require("./rules/indent-legacy"),
    "init-declarations": require("./rules/init-declarations"),
    "jsx-quotes": require("./rules/jsx-quotes"),
    "key-spacing": require("./rules/key-spacing"),
    "keyword-spacing": require("./rules/keyword-spacing"),
    "line-comment-position": require("./rules/line-comment-position"),
    "linebreak-style": require("./rules/linebreak-style"),
    "lines-around-comment": require("./rules/lines-around-comment"),
    "lines-around-directive": require("./rules/lines-around-directive"),
    "lines-between-class-members": require("./rules/lines-between-class-members"),
    "max-classes-per-file": require("./rules/max-classes-per-file"),
    "max-depth": require("./rules/max-depth"),
    "max-len": require("./rules/max-len"),
    "max-lines": require("./rules/max-lines"),
    "max-lines-per-function": require("./rules/max-lines-per-function"),
    "max-nested-callbacks": require("./rules/max-nested-callbacks"),
    "max-params": require("./rules/max-params"),
    "max-statements": require("./rules/max-statements"),
    "max-statements-per-line": require("./rules/max-statements-per-line"),
    "multiline-comment-style": require("./rules/multiline-comment-style"),
    "multiline-ternary": require("./rules/multiline-ternary"),
    "new-cap": require("./rules/new-cap"),
    "new-parens": require("./rules/new-parens"),
    "newline-after-var": require("./rules/newline-after-var"),
    "newline-before-return": require("./rules/newline-before-return"),
    "newline-per-chained-call": require("./rules/newline-per-chained-call"),
    "no-alert": require("./rules/no-alert"),
    "no-array-constructor": require("./rules/no-array-constructor"),
    "no-async-promise-executor": require("./rules/no-async-promise-executor"),
    "no-await-in-loop": require("./rules/no-await-in-loop"),
    "no-bitwise": require("./rules/no-bitwise"),
    "no-buffer-constructor": require("./rules/no-buffer-constructor"),
    "no-caller": require("./rules/no-caller"),
    "no-case-declarations": require("./rules/no-case-declarations"),
    "no-catch-shadow": require("./rules/no-catch-shadow"),
    "no-class-assign": require("./rules/no-class-assign"),
    "no-compare-neg-zero": require("./rules/no-compare-neg-zero"),
    "no-cond-assign": require("./rules/no-cond-assign"),
    "no-confusing-arrow": require("./rules/no-confusing-arrow"),
    "no-console": require("./rules/no-console"),
    "no-const-assign": require("./rules/no-const-assign"),
    "no-constant-condition": require("./rules/no-constant-condition"),
    "no-continue": require("./rules/no-continue"),
    "no-control-regex": require("./rules/no-control-regex"),
    "no-debugger": require("./rules/no-debugger"),
    "no-delete-var": require("./rules/no-delete-var"),
    "no-div-regex": require("./rules/no-div-regex"),
    "no-dupe-args": require("./rules/no-dupe-args"),
    "no-dupe-class-members": require("./rules/no-dupe-class-members"),
    "no-dupe-keys": require("./rules/no-dupe-keys"),
    "no-duplicate-case": require("./rules/no-duplicate-case"),
    "no-duplicate-imports": require("./rules/no-duplicate-imports"),
    "no-else-return": require("./rules/no-else-return"),
    "no-empty": require("./rules/no-empty"),
    "no-empty-character-class": require("./rules/no-empty-character-class"),
    "no-empty-function": require("./rules/no-empty-function"),
    "no-empty-pattern": require("./rules/no-empty-pattern"),
    "no-eq-null": require("./rules/no-eq-null"),
    "no-eval": require("./rules/no-eval"),
    "no-ex-assign": require("./rules/no-ex-assign"),
    "no-extend-native": require("./rules/no-extend-native"),
    "no-extra-bind": require("./rules/no-extra-bind"),
    "no-extra-boolean-cast": require("./rules/no-extra-boolean-cast"),
    "no-extra-label": require("./rules/no-extra-label"),
    "no-extra-parens": require("./rules/no-extra-parens"),
    "no-extra-semi": require("./rules/no-extra-semi"),
    "no-fallthrough": require("./rules/no-fallthrough"),
    "no-floating-decimal": require("./rules/no-floating-decimal"),
    "no-func-assign": require("./rules/no-func-assign"),
    "no-global-assign": require("./rules/no-global-assign"),
    "no-implicit-coercion": require("./rules/no-implicit-coercion"),
    "no-implicit-globals": require("./rules/no-implicit-globals"),
    "no-implied-eval": require("./rules/no-implied-eval"),
    "no-inline-comments": require("./rules/no-inline-comments"),
    "no-inner-declarations": require("./rules/no-inner-declarations"),
    "no-invalid-regexp": require("./rules/no-invalid-regexp"),
    "no-invalid-this": require("./rules/no-invalid-this"),
    "no-irregular-whitespace": require("./rules/no-irregular-whitespace"),
    "no-iterator": require("./rules/no-iterator"),
    "no-label-var": require("./rules/no-label-var"),
    "no-labels": require("./rules/no-labels"),
    "no-lone-blocks": require("./rules/no-lone-blocks"),
    "no-lonely-if": require("./rules/no-lonely-if"),
    "no-loop-func": require("./rules/no-loop-func"),
    "no-magic-numbers": require("./rules/no-magic-numbers"),
    "no-misleading-character-class": require("./rules/no-misleading-character-class"),
    "no-mixed-operators": require("./rules/no-mixed-operators"),
    "no-mixed-requires": require("./rules/no-mixed-requires"),
    "no-mixed-spaces-and-tabs": require("./rules/no-mixed-spaces-and-tabs"),
    "no-multi-assign": require("./rules/no-multi-assign"),
    "no-multi-spaces": require("./rules/no-multi-spaces"),
    "no-multi-str": require("./rules/no-multi-str"),
    "no-multiple-empty-lines": require("./rules/no-multiple-empty-lines"),
    "no-native-reassign": require("./rules/no-native-reassign"),
    "no-negated-condition": require("./rules/no-negated-condition"),
    "no-negated-in-lhs": require("./rules/no-negated-in-lhs"),
    "no-nested-ternary": require("./rules/no-nested-ternary"),
    "no-new": require("./rules/no-new"),
    "no-new-func": require("./rules/no-new-func"),
    "no-new-object": require("./rules/no-new-object"),
    "no-new-require": require("./rules/no-new-require"),
    "no-new-symbol": require("./rules/no-new-symbol"),
    "no-new-wrappers": require("./rules/no-new-wrappers"),
    "no-obj-calls": require("./rules/no-obj-calls"),
    "no-octal": require("./rules/no-octal"),
    "no-octal-escape": require("./rules/no-octal-escape"),
    "no-param-reassign": require("./rules/no-param-reassign"),
    "no-path-concat": require("./rules/no-path-concat"),
    "no-plusplus": require("./rules/no-plusplus"),
    "no-process-env": require("./rules/no-process-env"),
    "no-process-exit": require("./rules/no-process-exit"),
    "no-proto": require("./rules/no-proto"),
    "no-prototype-builtins": require("./rules/no-prototype-builtins"),
    "no-redeclare": require("./rules/no-redeclare"),
    "no-regex-spaces": require("./rules/no-regex-spaces"),
    "no-restricted-globals": require("./rules/no-restricted-globals"),
    "no-restricted-imports": require("./rules/no-restricted-imports"),
    "no-restricted-modules": require("./rules/no-restricted-modules"),
    "no-restricted-properties": require("./rules/no-restricted-properties"),
    "no-restricted-syntax": require("./rules/no-restricted-syntax"),
    "no-return-assign": require("./rules/no-return-assign"),
    "no-return-await": require("./rules/no-return-await"),
    "no-script-url": require("./rules/no-script-url"),
    "no-self-assign": require("./rules/no-self-assign"),
    "no-self-compare": require("./rules/no-self-compare"),
    "no-sequences": require("./rules/no-sequences"),
    "no-shadow": require("./rules/no-shadow"),
    "no-shadow-restricted-names": require("./rules/no-shadow-restricted-names"),
    "no-spaced-func": require("./rules/no-spaced-func"),
    "no-sparse-arrays": require("./rules/no-sparse-arrays"),
    "no-sync": require("./rules/no-sync"),
    "no-tabs": require("./rules/no-tabs"),
    "no-template-curly-in-string": require("./rules/no-template-curly-in-string"),
    "no-ternary": require("./rules/no-ternary"),
    "no-this-before-super": require("./rules/no-this-before-super"),
    "no-throw-literal": require("./rules/no-throw-literal"),
    "no-trailing-spaces": require("./rules/no-trailing-spaces"),
    "no-undef": require("./rules/no-undef"),
    "no-undef-init": require("./rules/no-undef-init"),
    "no-undefined": require("./rules/no-undefined"),
    "no-underscore-dangle": require("./rules/no-underscore-dangle"),
    "no-unexpected-multiline": require("./rules/no-unexpected-multiline"),
    "no-unmodified-loop-condition": require("./rules/no-unmodified-loop-condition"),
    "no-unneeded-ternary": require("./rules/no-unneeded-ternary"),
    "no-unreachable": require("./rules/no-unreachable"),
    "no-unsafe-finally": require("./rules/no-unsafe-finally"),
    "no-unsafe-negation": require("./rules/no-unsafe-negation"),
    "no-unused-expressions": require("./rules/no-unused-expressions"),
    "no-unused-labels": require("./rules/no-unused-labels"),
    "no-unused-vars": require("./rules/no-unused-vars"),
    "no-use-before-define": require("./rules/no-use-before-define"),
    "no-useless-call": require("./rules/no-useless-call"),
    "no-useless-catch": require("./rules/no-useless-catch"),
    "no-useless-computed-key": require("./rules/no-useless-computed-key"),
    "no-useless-concat": require("./rules/no-useless-concat"),
    "no-useless-constructor": require("./rules/no-useless-constructor"),
    "no-useless-escape": require("./rules/no-useless-escape"),
    "no-useless-rename": require("./rules/no-useless-rename"),
    "no-useless-return": require("./rules/no-useless-return"),
    "no-var": require("./rules/no-var"),
    "no-void": require("./rules/no-void"),
    "no-warning-comments": require("./rules/no-warning-comments"),
    "no-whitespace-before-property": require("./rules/no-whitespace-before-property"),
    "no-with": require("./rules/no-with"),
    "nonblock-statement-body-position": require("./rules/nonblock-statement-body-position"),
    "object-curly-newline": require("./rules/object-curly-newline"),
    "object-curly-spacing": require("./rules/object-curly-spacing"),
    "object-property-newline": require("./rules/object-property-newline"),
    "object-shorthand": require("./rules/object-shorthand"),
    "one-var": require("./rules/one-var"),
    "one-var-declaration-per-line": require("./rules/one-var-declaration-per-line"),
    "operator-assignment": require("./rules/operator-assignment"),
    "operator-linebreak": require("./rules/operator-linebreak"),
    "padded-blocks": require("./rules/padded-blocks"),
    "padding-line-between-statements": require("./rules/padding-line-between-statements"),
    "prefer-arrow-callback": require("./rules/prefer-arrow-callback"),
    "prefer-const": require("./rules/prefer-const"),
    "prefer-destructuring": require("./rules/prefer-destructuring"),
    "prefer-named-capture-group": require("./rules/prefer-named-capture-group"),
    "prefer-numeric-literals": require("./rules/prefer-numeric-literals"),
    "prefer-object-spread": require("./rules/prefer-object-spread"),
    "prefer-promise-reject-errors": require("./rules/prefer-promise-reject-errors"),
    "prefer-reflect": require("./rules/prefer-reflect"),
    "prefer-rest-params": require("./rules/prefer-rest-params"),
    "prefer-spread": require("./rules/prefer-spread"),
    "prefer-template": require("./rules/prefer-template"),
    "quote-props": require("./rules/quote-props"),
    quotes: require("./rules/quotes"),
    radix: require("./rules/radix"),
    "require-atomic-updates": require("./rules/require-atomic-updates"),
    "require-await": require("./rules/require-await"),
    "require-jsdoc": require("./rules/require-jsdoc"),
    "require-unicode-regexp": require("./rules/require-unicode-regexp"),
    "require-yield": require("./rules/require-yield"),
    "rest-spread-spacing": require("./rules/rest-spread-spacing"),
    semi: require("./rules/semi"),
    "semi-spacing": require("./rules/semi-spacing"),
    "semi-style": require("./rules/semi-style"),
    "sort-imports": require("./rules/sort-imports"),
    "sort-keys": require("./rules/sort-keys"),
    "sort-vars": require("./rules/sort-vars"),
    "space-before-blocks": require("./rules/space-before-blocks"),
    "space-before-function-paren": require("./rules/space-before-function-paren"),
    "space-in-parens": require("./rules/space-in-parens"),
    "space-infix-ops": require("./rules/space-infix-ops"),
    "space-unary-ops": require("./rules/space-unary-ops"),
    "spaced-comment": require("./rules/spaced-comment"),
    strict: require("./rules/strict"),
    "switch-colon-spacing": require("./rules/switch-colon-spacing"),
    "symbol-description": require("./rules/symbol-description"),
    "template-curly-spacing": require("./rules/template-curly-spacing"),
    "template-tag-spacing": require("./rules/template-tag-spacing"),
    "unicode-bom": require("./rules/unicode-bom"),
    "use-isnan": require("./rules/use-isnan"),
    "valid-jsdoc": require("./rules/valid-jsdoc"),
    "valid-typeof": require("./rules/valid-typeof"),
    "vars-on-top": require("./rules/vars-on-top"),
    "wrap-iife": require("./rules/wrap-iife"),
    "wrap-regex": require("./rules/wrap-regex"),
    "yield-star-spacing": require("./rules/yield-star-spacing"),
    yoda: require("./rules/yoda")
};
