/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.basedata.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.yhxt.basedata.manager.RouteManager;
import com.artfess.yhxt.basedata.model.Route;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/route/routemanage/v1"})
@Api(tags={"\u8def\u7ebf\u7ba1\u7406"})
@ApiGroup(group={"group_biz"})
public class RouteController
extends BaseController<RouteManager, Route> {
    @Resource
    RouteManager routeManager;

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u8def\u7ebf\u7ba1\u7406\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u8def\u7ebf\u7ba1\u7406\u5217\u8868")
    public PageList<Route> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Route> queryFilter) throws Exception {
        return this.routeManager.query(queryFilter);
    }

    @GetMapping(value={"/get/{id}"})
    @ApiOperation(value="\u8def\u7ebf\u7ba1\u7406\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u8def\u7ebf\u7ba1\u7406\u6570\u636e\u8be6\u60c5")
    public Route get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return (Route)this.routeManager.get((Serializable)((Object)id));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u8def\u7ebf\u7ba1\u7406\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u8def\u7ebf\u7ba1\u7406\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="Route", value="\u8def\u7ebf\u7ba1\u7406\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody Route Route2) throws Exception {
        String msg = "\u6dfb\u52a0\u8def\u7ebf\u7ba1\u7406\u6210\u529f";
        if (StringUtil.isEmpty((String)Route2.getId())) {
            Route2.setIsDele("0");
            HashMap<String, String> map = new HashMap<String, String>();
            IUser user = ContextUtil.getCurrentUser();
            if (ObjectUtils.isNotEmpty((Object)user)) {
                map.put("tenant_id_", user.getTenantId());
            }
            int nextSequence = ((RouteManager)this.baseService).getNextSequence(map);
            Route2.setSn(nextSequence);
            this.routeManager.create((Model)Route2);
        } else {
            this.routeManager.update((Model)Route2);
            msg = "\u66f4\u65b0\u8def\u7ebf\u7ba1\u7406\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @DeleteMapping(value={"/remove/{id}"})
    @ApiOperation(value="\u5220\u9664\u8def\u7ebf\u7ba1\u7406\u8bb0\u5f55", httpMethod="DELETE", notes="\u5220\u9664\u8def\u7ebf\u7ba1\u7406\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u4e1a\u52a1\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        this.routeManager.remove((Serializable)((Object)id));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/removes"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8def\u7ebf\u7ba1\u7406\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u8def\u7ebf\u7ba1\u7406\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.routeManager.removeByIds(Arrays.asList(ids));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/getList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0d\u5206\u9875\u67e5\u8be2\u8def\u7ebf\u4fe1\u606f", httpMethod="POST")
    public PageList<Route> getList(@ApiParam(name="queryFilter", value="\u4e0d\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<Route> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        PageList<Route> route = ((RouteManager)this.baseService).queryRoute(queryFilter);
        return route;
    }

    @RequestMapping(value={"/getJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8def\u7ebf\u4fe1\u606f", httpMethod="POST")
    public PageList<Route> getJson(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<Route> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        PageList<Route> pageList = ((RouteManager)this.baseService).queryRoute(queryFilter);
        return pageList;
    }

    @RequestMapping(value={"/updateBySn"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u6392\u5e8f\u53f7", httpMethod="POST")
    public CommonResult<String> updateBySn(@ApiParam(name="params", value="\u6392\u5e8f\u53c2\u6570\uff1aKey\uff1aID\uff0cValue\uff1a\u6392\u5e8f\u53f7") @RequestBody HashMap<String, Integer> params) throws Exception {
        ((RouteManager)this.baseService).updateSequence(params);
        return new CommonResult(true, "\u6392\u5e8f\u5b8c\u6210");
    }

    @RequestMapping(value={"updateBatch"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664", httpMethod="POST", notes="\u903b\u8f91\u5220\u9664")
    public CommonResult<String> updateBatchRoute(@ApiParam(name="id", value="\u8def\u7ebfID", required=true) @RequestParam(value="id", required=true) String id) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.routeManager.updateRoute(id);
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"updateRoute"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u903b\u8f91\u5220\u9664", httpMethod="DELETE", notes="\u6279\u91cf\u903b\u8f91\u5220\u9664")
    public CommonResult<String> updateRoute(@ApiParam(name="ids", value="\u8def\u7ebfID\u96c6\u5408\u4ee5\uff0c\u9694\u5f00", required=true) @RequestParam(value="ids", required=true) String ids) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"id_", idsList);
            updateWrapper.set((Object)"is_dele_", (Object)"1");
            this.routeManager.update(null, (Wrapper)updateWrapper);
        }
        return new CommonResult(true, "\u6279\u91cf\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"route/export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8def\u7ebf\u5bfc\u51fa", httpMethod="GET", notes="\u8def\u7ebf\u5bfc\u51fa")
    public void export(HttpServletResponse response, @ApiParam(name="ids", value="ids", required=true) @RequestParam String ids) throws Exception {
        QueryFilter filter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        filter.addFilter("id", (Object)ids.split(","), QueryOP.IN);
        PageList routes = this.routeManager.query(filter);
        ArrayList<Map> list = new ArrayList<Map>();
        if (BeanUtils.isNotEmpty((Object)routes.getRows())) {
            for (Route route : routes.getRows()) {
                list.add(JsonUtil.toMap((String)JsonUtil.toJson((Object)((Object)route))));
            }
        }
        LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
        exportMap.put("number", "\u8def\u7ebf\u7f16\u7801");
        exportMap.put("name", "\u8def\u7ebf\u540d\u79f0");
        exportMap.put("start", "\u8d77\u70b9");
        exportMap.put("end", "\u7ec8\u70b9");
        HSSFWorkbook exportFile = ExcelUtil.exportExcel((String)"\u8def\u7ebf\u5217\u8868", (int)22, exportMap, list);
        ExcelUtil.downloadExcel((HSSFWorkbook)exportFile, (String)"\u8def\u7ebf\u5bfc\u51fa", (HttpServletResponse)response);
    }
}

