/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.budget.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.budget.dao.YearBudgetDao;
import com.artfess.yhxt.budget.dao.YearBudgetDetailedDao;
import com.artfess.yhxt.budget.manager.YearBudgetDetailedManager;
import com.artfess.yhxt.budget.manager.YearBudgetManager;
import com.artfess.yhxt.budget.model.YearBudget;
import com.artfess.yhxt.budget.model.YearBudgetDetailed;
import com.artfess.yhxt.budget.vo.YearBudgetVo;
import com.artfess.yhxt.statistics.dao.YearBudgetSumDao;
import com.artfess.yhxt.statistics.model.YearBudgetSum;
import com.artfess.yhxt.statistics.vo.Org4BudgetVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class YearBudgetManagerImpl
extends BaseManagerImpl<YearBudgetDao, YearBudget>
implements YearBudgetManager {
    @Resource
    YearBudgetDetailedDao yearBudgetDetailedDao;
    @Resource
    YearBudgetDetailedManager yearBudgetDetailedManager;
    @Resource
    YearBudgetSumDao yearBudgetSumDao;
    @Resource
    private OrgDao orgDao;
    @Resource
    BaseContext baseContext;
    @Resource
    private RoadManager roadManager;

    @Override
    public List<Org4BudgetVO> getBudgetCount(String year) {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        List<Org4BudgetVO> lists = new ArrayList<Org4BudgetVO>();
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        List<Org> list = YearBudgetManagerImpl.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            Org4BudgetVO fvo = new Org4BudgetVO();
            BeanUtils.copyProperties((Object)org, (Object)fvo);
            lists.add(fvo);
        }
        lists = YearBudgetManagerImpl.getChild(lists, orgId);
        return this.setCount(lists, year);
    }

    public List<Org4BudgetVO> setCount(List<Org4BudgetVO> list, String year) {
        Iterator<Org4BudgetVO> it = list.iterator();
        while (it.hasNext()) {
            Org4BudgetVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                orgVO = this.newCountWorkOrder(roadList, orgVO, year);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setCount(orgVO.getChirldren(), year);
        }
        return list;
    }

    public Org4BudgetVO newCountWorkOrder(List<String> ids, Org4BudgetVO orgVO, String year) {
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        orderQueryWrapper.eq((Object)"IS_DELE_", (Object)0);
        orderQueryWrapper.eq((Object)"ASCRIPTION_YEAR_", (Object)year);
        orgVO.setAscriptionYear(Integer.valueOf(year));
        List list = this.list((Wrapper)orderQueryWrapper);
        if (list.size() > 0) {
            orgVO.setBudgetSum(list.stream().map(p -> p.getBudgetSum()).reduce(BigDecimal.ZERO, (b1, b2) -> b1.add((BigDecimal)b2)));
            orgVO.setAlreadyCount(list.stream().map(p -> p.getAlreadyCount()).reduce(BigDecimal.ZERO, (b1, b2) -> b1.add((BigDecimal)b2)));
            if ("4".equals(orgVO.getGrade())) {
                orgVO.setRoadSegmentId(((YearBudget)((Object)list.get(0))).getRoadSegmentId());
            }
        } else {
            orgVO.setBudgetSum(new BigDecimal("0"));
            orgVO.setAlreadyCount(new BigDecimal("0"));
        }
        return orgVO;
    }

    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            YearBudgetManagerImpl.getOrgChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    public static List<Org4BudgetVO> getChild(List<Org4BudgetVO> allList, String pCode) {
        ArrayList<Org4BudgetVO> returnList = new ArrayList<Org4BudgetVO>();
        for (Org4BudgetVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(YearBudgetManagerImpl.getChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    @Override
    public void checkYear(YearBudget yearBudget) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)yearBudget.getId())) {
            queryWrapper.notIn((Object)"ID_", new Object[]{yearBudget.getId()});
        }
        queryWrapper.eq((Object)"ASCRIPTION_YEAR_", (Object)yearBudget.getAscriptionYear());
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        queryWrapper.eq((Object)"COMPANY_ID_", (Object)yearBudget.getCompanyId());
        queryWrapper.eq((Object)"ROAD_SEGMENT_ID_", (Object)yearBudget.getRoadSegmentId());
        List list = ((YearBudgetDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (list.size() > 0) {
            throw new RuntimeException("\u8be5\u5e74\u4efd\u9884\u7b97\u5df2\u7ecf\u6dfb\u52a0");
        }
    }

    @Override
    public YearBudget getYearBudgetById(String id) {
        return (YearBudget)((Object)((YearBudgetDao)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateYear(BigDecimal bigDecimal, Integer ascriptionYear) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"ASCRIPTION_YEAR_", (Object)ascriptionYear);
        updateWrapper.set((Object)"BUDGET_SUM_", (Object)bigDecimal);
        ((YearBudgetDao)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    @Override
    public PageList<YearBudget> queryYearBuget(QueryFilter<YearBudget> queryFilter) {
        IPage<YearBudget> result = ((YearBudgetDao)this.baseMapper).queryYearBuget((IPage<YearBudget>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<YearBudget>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public YearBudgetVo getYearBudgetVoById(String id) {
        YearBudgetVo yearBudgetVo = new YearBudgetVo();
        YearBudget yearBudget = (YearBudget)((Object)this.getById((Serializable)((Object)id)));
        yearBudgetVo.setYearBudget(yearBudget);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"YEAR_BUDGET_ID_", (Object)id);
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        queryWrapper.orderByAsc((Object)"SORT_");
        List list = this.yearBudgetDetailedDao.selectList((Wrapper)queryWrapper);
        if (list.size() > 0) {
            yearBudgetVo.setYearBudgetDetaileds(list);
        }
        return yearBudgetVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveYearBudgetVo(YearBudgetVo yearBudgetVo) {
        YearBudget yearBudget = yearBudgetVo.getYearBudget();
        if (yearBudget.getAscriptionYear() == null) {
            throw new RuntimeException("\u8bf7\u586b\u5199\u5bf9\u5e94\u7684\u5e74\u4efd");
        }
        if (yearBudget != null) {
            yearBudget.setIsDele("0");
            yearBudget.setAlreadyCount(new BigDecimal("0.00"));
            this.save((Object)yearBudget);
            this.synchronizationBudget(yearBudget);
            List<YearBudgetDetailed> detailedList = yearBudgetVo.getYearBudgetDetaileds();
            if (detailedList.size() > 0) {
                for (YearBudgetDetailed yearBudgetDetailed : detailedList) {
                    yearBudgetDetailed.setYearBudgetId(yearBudget.getId());
                    yearBudgetDetailed.setIsDele("0");
                    yearBudgetDetailed.setImageProgress(new BigDecimal("0.00"));
                }
                this.yearBudgetDetailedManager.saveBatch(detailedList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateYearBudgetVo(YearBudgetVo yearBudgetVo) {
        List<YearBudgetDetailed> detailedList;
        YearBudget yearBudget = yearBudgetVo.getYearBudget();
        if (yearBudget != null && (detailedList = yearBudgetVo.getYearBudgetDetaileds()).size() > 0) {
            for (YearBudgetDetailed yearBudgetDetailed : detailedList) {
                yearBudgetDetailed.setYearBudgetId(yearBudget.getId());
                yearBudgetDetailed.setIsDele("0");
                BigDecimal imageProgress = detailedList.stream().filter(s -> s != null && s.getImageProgress() != null).map(YearBudgetDetailed::getImageProgress).reduce(BigDecimal.ZERO, BigDecimal::add);
                yearBudget.setAlreadyCount(imageProgress);
            }
            this.yearBudgetDetailedManager.saveOrUpdateBatch(detailedList);
            this.update((Model)yearBudget);
            this.synchronizationBudget(yearBudget);
        }
    }

    @Async
    public void synchronizationBudget(YearBudget yearBudget) {
        QueryWrapper yearBudgetSumQueryWrapper = new QueryWrapper();
        yearBudgetSumQueryWrapper.eq((Object)"ACC_DATE_YEAR_", (Object)yearBudget.getAscriptionYear());
        yearBudgetSumQueryWrapper.eq((Object)"ROAD_SEGMENT_ID_", (Object)yearBudget.getRoadSegmentId());
        YearBudgetSum yearBudgetSum = (YearBudgetSum)((Object)this.yearBudgetSumDao.selectOne((Wrapper)yearBudgetSumQueryWrapper));
        if (null == yearBudgetSum) {
            yearBudgetSum = new YearBudgetSum();
            yearBudgetSum.setAccDateYear(yearBudget.getAscriptionYear());
            yearBudgetSum.setRoadSegmentId(yearBudget.getRoadSegmentId());
            yearBudgetSum.setRoadSegmentName(yearBudget.getRoadSegmentName());
            yearBudgetSum.setCompanyId(yearBudget.getCompanyId());
            yearBudgetSum.setCompanyName(yearBudget.getCompanyName());
            if (yearBudget.getBudgetSum() != null) {
                yearBudgetSum.setBudgetSum(yearBudget.getBudgetSum().toString());
            }
            this.yearBudgetSumDao.insert((Object)yearBudgetSum);
        } else {
            if (yearBudget.getBudgetSum() != null) {
                yearBudgetSum.setBudgetSum(yearBudget.getBudgetSum().toString());
            }
            this.yearBudgetSumDao.updateById((Object)yearBudgetSum);
        }
    }
}

