/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.processManagermant.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.processManagermant.dao.ProgressManageDefiniteDao;
import com.artfess.cqxy.processManagermant.manager.ProgressManageDefiniteManager;
import com.artfess.cqxy.processManagermant.manager.ProgressManageManager;
import com.artfess.cqxy.processManagermant.model.ProgressManage;
import com.artfess.cqxy.processManagermant.model.ProgressManageDefinite;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProgressManageDefiniteManagerImpl
extends BaseManagerImpl<ProgressManageDefiniteDao, ProgressManageDefinite>
implements ProgressManageDefiniteManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private ProgressManageManager pmm;
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private GlobalRetrievalManager grm;

    public boolean saveOrUpdate(ProgressManageDefinite entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        String projectId = this.handleAmountTotal(entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(projectId);
            ele.setDirectory(ProjectStatusEnum.eleven.getCode());
            ele.setGroup("ProgressManageDefinite");
            ele.setNode(ProjectStatusEnum.eleven.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, ProgressManageDefinite entity) {
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setProjectId("");
        globalRetrieval.setFunctionCode(FunctionEnum.twentyOne.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.twentyOne.getName());
        globalRetrieval.setBizTableName(FunctionEnum.twentyOne.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.twentyOne.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.twentyOne.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.twentyOne.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.twentyOne.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.twentyOne.getFunctionPath());
        globalRetrieval.setSearchTitle(entity.getPayeeNum() + "_" + entity.getRemarks() + "_" + entity.getPayeeUnit() + "_" + entity.getBankOfDeposit());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public ProgressManageDefinite getById(String id) {
        ProgressManageDefinite result = ((ProgressManageDefiniteDao)this.baseMapper).getById(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<ProgressManageDefinite> queryAllByPage(QueryFilter<ProgressManageDefinite> queryFilter) {
        BizUtils.handleFilter(queryFilter, "bpmd", false);
        IPage<ProgressManageDefinite> result = ((ProgressManageDefiniteDao)this.baseMapper).queryAllByPage((IPage<ProgressManageDefinite>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ProgressManageDefinite>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (ProgressManageDefinite ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String progressManageId) {
        Assert.notNull((Object)progressManageId, (String)"\u8fdb\u5ea6\u7ba1\u7406ID\u4e0d\u80fd\u4e3a\u7a7a");
        List purposeType = this.sdm.queryDictListItemsByCode("jdgl-bkmx-zflx");
        List<ProgressManageDefinite> data = this.readExcelData(file);
        for (ProgressManageDefinite ele : data) {
            ele.setProgressManageId(progressManageId);
            ((ProgressManageDefiniteDao)this.baseMapper).insert((Object)ele);
            this.handleAmountTotal(ele);
            this.handleRetrieval(new GlobalRetrieval(), ele);
        }
    }

    @Override
    public List<ProgressManageDefinite> readExcelData(MultipartFile file) {
        try (InputStream inputStream = file.getInputStream();){
            List list = ExcelImportUtil.importExcel((InputStream)inputStream, ProgressManageDefinite.class, (ImportParams)new ImportParams());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<ProgressManageDefinite> result = new ArrayList<ProgressManageDefinite>();
        try {
            InputStream inputStream = file.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheetAt = workbook.getSheetAt(0);
            for (Row row : sheetAt) {
                if (row.getRowNum() == 0) continue;
                ProgressManageDefinite data = new ProgressManageDefinite();
                data.setPayeeUnit(null == row.getCell(1) ? row.createCell(1).getStringCellValue() : row.getCell(1).getStringCellValue());
                data.setBankOfDeposit(null == row.getCell(2) ? row.createCell(2).getStringCellValue() : row.getCell(2).getStringCellValue());
                data.setPayeeNum(null == row.getCell(3) ? row.createCell(3).getStringCellValue() : row.getCell(3).getStringCellValue());
                data.setPayeeAmount(BigDecimal.valueOf(null == row.getCell(4) ? row.createCell(4).getNumericCellValue() : row.getCell(4).getNumericCellValue()));
                data.setRemarks(null == row.getCell(8) ? row.createCell(8).getStringCellValue() : row.getCell(8).getStringCellValue());
                result.add(data);
            }
            workbook.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void exportDataToExcel(QueryFilter<ProgressManageDefinite> queryFilter, HttpServletResponse response) throws IOException {
        List purposeType = this.sdm.queryDictListItemsByCode("jdgl-bkmx-zflx");
        String fileName = "\u8fc7\u7a0b\u7ba1\u7406-\u8fdb\u5ea6\u7ba1\u7406-\u672c\u6b21\u62e8\u6b3e\u660e\u7ec6-\u5bfc\u51fa\u7ed3\u679c";
        BizUtils.handleFilter(queryFilter, "bpmd", false);
        List data = ((ProgressManageDefiniteDao)this.baseMapper).queryAllByPage((IPage<ProgressManageDefinite>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<ProgressManageDefinite>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        for (ProgressManageDefinite ele : data) {
            ele.setPurpose(BizUtils.getDicValueByCode((List<DictModel>)purposeType, ele.getPurpose()));
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, ProgressManageDefinite.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    private String handleAmountTotal(ProgressManageDefinite entity) {
        ProgressManage progressManage = (ProgressManage)((Object)this.pmm.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ID_", (Object)entity.getProgressManageId())).eq((Object)"IS_DELE_", (Object)"0")));
        List definites = ((ProgressManageDefiniteDao)this.baseMapper).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROGRESS_MANAGE_ID_", (Object)entity.getProgressManageId())).eq((Object)"IS_DELE_", (Object)"0"));
        BigDecimal payeeAmountTotal = new BigDecimal("0");
        for (ProgressManageDefinite ele : definites) {
            payeeAmountTotal.add(ele.getPayeeAmount());
        }
        progressManage.setPayeeAmountTotal(payeeAmountTotal);
        progressManage.setAmountTotalWords(BizUtils.changeMoney(payeeAmountTotal.doubleValue()));
        this.pmm.saveOrUpdate((Object)progressManage);
        return progressManage.getProjectId();
    }
}

