/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.ledger.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.bidManagement.manager.BiddingManagementManager;
import com.artfess.cqxy.bidManagement.model.BiddingManagement;
import com.artfess.cqxy.constructionPermit.manager.ConstructionPermitManager;
import com.artfess.cqxy.constructionPermit.manager.ConstructionPermitNewManager;
import com.artfess.cqxy.constructionPermit.model.ConstructionPermitNew;
import com.artfess.cqxy.contract.manager.ContractManager;
import com.artfess.cqxy.designEstimate.manager.PreliminaryDesignManager;
import com.artfess.cqxy.ledger.manager.ProjectLedgerManager;
import com.artfess.cqxy.ledger.vo.ProjectLedgerVo;
import com.artfess.cqxy.projectApproval.manager.DecisionBasisManager;
import com.artfess.cqxy.projectApproval.manager.ProjectEstablishmentManager;
import com.artfess.cqxy.projectApproval.model.DecisionBasis;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectLedgerManagerImpl
implements ProjectLedgerManager {
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    private ProjectManagementManager pmm;
    @Autowired
    private DecisionBasisManager dbm;
    @Autowired
    private BiddingManagementManager bmm;
    @Autowired
    private ContractManager contractManager;
    @Autowired
    private ConstructionPermitManager constructionPermitManager;
    @Autowired
    private ConstructionPermitNewManager constructionPermitNewManager;
    @Autowired
    private ProjectEstablishmentManager projectEstablishmentManager;
    @Autowired
    private PreliminaryDesignManager preliminaryDesignManager;

    @Override
    public List<Map<String, String>> getCollect(QueryFilter<ProjectManagement> queryFilter) {
        List sorter;
        if (null == queryFilter) {
            queryFilter = QueryFilter.build();
        }
        if (null != (sorter = queryFilter.getSorter()) && sorter.size() > 0) {
            sorter.clear();
        }
        queryFilter.addFilter("PARENT_ID_", (Object)"root", QueryOP.EQUAL);
        List pType = this.sdm.queryDictListItemsByCode("xmgl-xmlx");
        List<Map<String, Object>> projectMoneyGroupByTypeList = this.pmm.queryProjectMoneyGroupByType((QueryFilter<ProjectManagement>)queryFilter);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(pType.size() + 1);
        HashMap<String, String> countMap = new HashMap<String, String>();
        countMap.put("name", "\u603b\u8ba1");
        countMap.put("value", "all");
        result.add(countMap);
        BigDecimal count = BigDecimal.ZERO;
        for (DictModel ele : pType) {
            HashMap<String, String> temp = new HashMap<String, String>();
            String key = ele.getValue();
            String name = ele.getTitle();
            temp.put("name", name);
            temp.put("value", key);
            boolean notHave = true;
            for (Map<String, Object> projectMoneyMap : projectMoneyGroupByTypeList) {
                Object objTotal = projectMoneyMap.get("total");
                BigDecimal total = BigDecimal.ZERO;
                total = objTotal instanceof BigDecimal ? (BigDecimal)objTotal : (objTotal != null && StringUtils.isNotBlank((CharSequence)String.valueOf(objTotal)) ? new BigDecimal(String.valueOf(objTotal)) : BigDecimal.ZERO);
                total = total.setScale(2, 4);
                count = count.add(total);
                if (!key.equalsIgnoreCase(String.valueOf(projectMoneyMap.get("type")))) continue;
                temp.put("total", total.stripTrailingZeros().toPlainString());
                notHave = false;
            }
            if (notHave) {
                temp.put("total", "0");
            }
            result.add(temp);
        }
        ((Map)result.get(0)).put("total", count.stripTrailingZeros().toPlainString());
        return result;
    }

    public Map<String, String> getCollect2(QueryFilter<ProjectManagement> queryFilter) {
        List sorter;
        if (null == queryFilter) {
            queryFilter = QueryFilter.build();
        }
        if (null != (sorter = queryFilter.getSorter()) && sorter.size() > 0) {
            sorter.clear();
        }
        queryFilter.addFilter("PARENT_ID_", (Object)"root", QueryOP.EQUAL);
        List pType = this.sdm.queryDictListItemsByCode("xmgl-xmlx");
        List<Map<String, Object>> projectMoneyGroupByTypeList = this.pmm.queryProjectMoneyGroupByType((QueryFilter<ProjectManagement>)queryFilter);
        HashMap<String, String> result = new HashMap<String, String>();
        BigDecimal count = BigDecimal.ZERO;
        for (DictModel ele : pType) {
            String key = ele.getValue();
            String name = ele.getTitle();
            boolean notHave = true;
            for (Map<String, Object> projectMoneyMap : projectMoneyGroupByTypeList) {
                Object objTotal = projectMoneyMap.get("total");
                BigDecimal total = BigDecimal.ZERO;
                total = objTotal instanceof BigDecimal ? (BigDecimal)objTotal : (objTotal != null && StringUtils.isNotBlank((CharSequence)String.valueOf(objTotal)) ? new BigDecimal(String.valueOf(objTotal)) : BigDecimal.ZERO);
                total = total.setScale(2, 4);
                count = count.add(total);
                if (!key.equalsIgnoreCase(String.valueOf(projectMoneyMap.get("type")))) continue;
                result.put(key, ele.getTitle() + "\uff1a" + total.stripTrailingZeros().toPlainString());
                notHave = false;
            }
            if (!notHave) continue;
            result.put(key, ele.getTitle() + "\uff1a0.00");
        }
        result.put("all", "\u603b\u8ba1\uff1a" + count.stripTrailingZeros().toPlainString());
        return result;
    }

    private Map<String, String> collectType(List<ProjectLedgerVo> data) {
        LinkedHashMap<String, String> type = new LinkedHashMap<String, String>();
        List pType = this.sdm.queryDictListItemsByCode("xmgl-xmlx");
        for (DictModel dictModel : pType) {
            String key = dictModel.getValue();
            type.put(key, dictModel.getTitle() + "\uff1a0.00");
        }
        for (ProjectLedgerVo projectLedgerVo : data) {
            String projectType = projectLedgerVo.getProjectType() + "";
            BigDecimal num = new BigDecimal(((String)type.get(projectType)).split("\uff1a")[1]).add(new BigDecimal(StringUtils.isEmpty((CharSequence)projectLedgerVo.getProjectMoney()) ? "0.00" : projectLedgerVo.getProjectMoney()));
            type.put(projectType, BizUtils.getDicValueByCode((List<DictModel>)pType, projectLedgerVo.getProjectType()) + "\uff1a" + num);
        }
        BigDecimal all = new BigDecimal("0");
        for (Map.Entry ele : type.entrySet()) {
            all = all.add(new BigDecimal(((String)ele.getValue()).split("\uff1a")[1]));
        }
        type.put("all", "\u603b\u8ba1\uff1a" + all);
        return type;
    }

    @Override
    public Map<String, Object> getDataByPage(QueryFilter<ProjectManagement> queryFilter) {
        List bChargeType = this.sdm.queryDictListItemsByCode("zbfs");
        List dType = this.sdm.queryDictListItemsByCode("xmlx-jcyj-jcwjlx");
        List pStatus = this.sdm.queryDictListItemsByCode("xmgl-xmzt");
        List jldw = this.sdm.queryDictListItemsByCode("sgxk-jldw");
        List sgdw = this.sdm.queryDictListItemsByCode("sgxk-sgdw");
        List sjdw = this.sdm.queryDictListItemsByCode("sgxk-sjdw");
        List kcdw = this.sdm.queryDictListItemsByCode("sgxk-kcdw");
        PageList<ProjectManagement> project = this.pmm.queryAllByPage(queryFilter);
        List projectManagementList = null == project ? new ArrayList() : project.getRows();
        ArrayList<ProjectLedgerVo> data = new ArrayList<ProjectLedgerVo>();
        for (ProjectManagement ele : projectManagementList) {
            ProjectLedgerVo temp = new ProjectLedgerVo();
            DecisionBasis decisionBasis = (DecisionBasis)((Object)this.dbm.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)ele.getId())).eq((Object)"IS_DELE_", (Object)"0")).last("limit 1")));
            temp.setDecisionBasisType(BeanUtils.isEmpty((Object)((Object)decisionBasis)) ? "" : decisionBasis.getDecisionBasisType());
            BiddingManagement biddingManagement = (BiddingManagement)((Object)this.bmm.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)ele.getId())).eq((Object)"IS_DELE_", (Object)"0")).last("limit 1")));
            temp.setBiddingChargeType(BeanUtils.isEmpty((Object)((Object)biddingManagement)) ? "" : String.valueOf(biddingManagement.getBiddingChargeType()));
            temp.setContractAmount(this.contractManager.queryConstructionAmount(ele.getId()));
            temp = ProjectLedgerVo.convertVo(ele, temp, bChargeType, dType, pStatus);
            ConstructionPermitNew constructionPermit = (ConstructionPermitNew)((Object)this.constructionPermitNewManager.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ConstructionPermitNew::getProjectId, (Object)ele.getId())).eq(BizModel::getIsDele, (Object)"0")).last("limit 1")));
            if (null != constructionPermit) {
                if (StringUtils.isNotBlank((CharSequence)constructionPermit.getName())) {
                    temp.setResponsibleUnit(constructionPermit.getName());
                }
                if (StringUtils.isNotBlank((CharSequence)constructionPermit.getSurveyUnit())) {
                    temp.setGeologicalProspectingUnit(BizUtils.getDicValueByCode((List<DictModel>)kcdw, constructionPermit.getSurveyUnit()));
                }
                if (StringUtils.isNotBlank((CharSequence)constructionPermit.getDesignUnit())) {
                    temp.setDesignUnit(BizUtils.getDicValueByCode((List<DictModel>)sjdw, constructionPermit.getDesignUnit()));
                }
                if (StringUtils.isNotBlank((CharSequence)constructionPermit.getSupervisorUnit())) {
                    temp.setSupervisorUnit(BizUtils.getDicValueByCode((List<DictModel>)jldw, constructionPermit.getSupervisorUnit()));
                }
                if (StringUtils.isNotBlank((CharSequence)constructionPermit.getConstructionUnit())) {
                    temp.setConstructUnit(BizUtils.getDicValueByCode((List<DictModel>)sgdw, constructionPermit.getConstructionUnit()));
                }
                if (StringUtils.isNotBlank((CharSequence)constructionPermit.getProposedLandArea())) {
                    temp.setProjectContent(constructionPermit.getProposedLandArea());
                }
                if (StringUtils.isNotBlank((CharSequence)constructionPermit.getProposedLocation())) {
                    temp.setProjectAddress(constructionPermit.getProposedLocation());
                }
            }
            data.add(temp);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("data", data);
        result.put("total", project.getTotal());
        result.put("page", project.getPage());
        result.put("pageSize", project.getPageSize());
        return result;
    }

    @Override
    public void exportDatatoExcel(QueryFilter<ProjectManagement> queryFilter, HttpServletResponse response) throws Exception {
        List pType = this.sdm.queryDictListItemsByCode("xmgl-xmlx");
        List queryFieldList = queryFilter.getQuerys();
        queryFilter.getPageBean().setPageSize(-1);
        String year = BizUtils.getYearByQueryFields(queryFieldList);
        String fileName = (StringUtils.isEmpty((CharSequence)year) ? "" : year + "\u5e74") + "\u5efa\u8bbe\u9879\u76ee\u53f0\u8d26\u4fe1\u606f";
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFFont font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        cellStyle.setFont(font);
        HSSFDataFormat dataFormat = workbook.createDataFormat();
        cellStyle.setDataFormat(dataFormat.getFormat("@"));
        HSSFCellStyle cellNumStyle = workbook.createCellStyle();
        HSSFFont numFont = workbook.createFont();
        numFont.setFontName("\u5b8b\u4f53");
        cellNumStyle.setFont(numFont);
        cellNumStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0.00"));
        HSSFRow titleRow = sheet.createRow(0);
        BizUtils.handelCell(workbook, fileName, titleRow.createCell(0), fileName, true);
        HSSFRow titleRow1 = sheet.createRow(1);
        for (int i = 0; i < 17; ++i) {
            if (i == 0) {
                HSSFCell cell = titleRow1.createCell(i);
                BizUtils.handelCell(workbook, fileName, cell, "\u586b\u62a5\u5355\u4f4d\uff1a\u897f\u6c38\u5fae\u7535\u56ed\u516c\u53f8", new boolean[0]);
                HSSFCellStyle style = workbook.createCellStyle();
                style.setAlignment(HorizontalAlignment.LEFT);
                style.setVerticalAlignment(VerticalAlignment.CENTER);
                HSSFFont font1 = workbook.createFont();
                font1.setFontName("\u5b8b\u4f53");
                font1.setFontHeightInPoints((short)10);
                style.setFont(font1);
                cell.setCellStyle(style);
                continue;
            }
            if (i == 16) {
                BizUtils.handelCell(workbook, fileName, titleRow1.createCell(i), "\u5355\u4f4d\uff1a\u4e07\u5143", new boolean[0]);
                continue;
            }
            BizUtils.handelCell(workbook, fileName, titleRow1.createCell(i), "", new boolean[0]);
        }
        String[] heards = new String[]{"\u5e8f\u53f7", "\u9879\u76ee\u540d\u79f0", "\u9879\u76ee\u72b6\u6001", "\u9879\u76ee\u8d1f\u8d23\u4eba", "\u51b3\u7b56\u4f9d\u636e", "\u8d23\u4efb\u5355\u4f4d", "\u5730\u52d8\u5355\u4f4d", "\u8bbe\u8ba1\u5355\u4f4d", "\u76d1\u7406\u5355\u4f4d", "\u65bd\u5de5\u5355\u4f4d", "\u65bd\u5de5\u5408\u540c\u91d1\u989d", "\u53d1\u5305\u65b9\u5f0f", "\u5efa\u8bbe\u5730\u5740", "\u5efa\u8bbe\u89c4\u6a21\u53ca\u5185\u5bb9", "\u603b\u6295\u8d44", "\u5f00\u5de5\u65f6\u95f4", "\u5b8c\u5de5\u65f6\u95f4"};
        HSSFRow titleRow2 = sheet.createRow(2);
        for (int i = 0; i < heards.length; ++i) {
            BizUtils.handelCell(workbook, fileName, titleRow2.createCell(i), heards[i], true);
        }
        queryFilter.withSorter(new FieldSort("PROJECT_TYPE_", Direction.ASC));
        List result = (List)this.getDataByPage(queryFilter).get("data");
        List data = null == result ? new ArrayList() : result;
        Map<String, String> type = this.getCollect2(queryFilter);
        HSSFRow titleRow3 = sheet.createRow(3);
        for (int i = 0; i < 17; ++i) {
            if (i == 1) {
                BizUtils.handelCell(workbook, fileName, titleRow3.createCell(i), "\u603b\u8ba1", true);
                continue;
            }
            if (i == 14) {
                BizUtils.handelCell(workbook, fileName, titleRow3.createCell(i), Double.valueOf(type.get("all").split("\uff1a")[1]), true);
                continue;
            }
            BizUtils.handelCell(workbook, fileName, titleRow3.createCell(i), "", new boolean[0]);
        }
        int row = 4;
        int currentType = 0;
        int counter = 1;
        for (int j = 1; j < ((ProjectLedgerVo)data.get(0)).getProjectType(); ++j) {
            HSSFRow addRow = sheet.createRow(sheet.getLastRowNum() + 1);
            this.handleSubTitle(j, fileName, type, workbook, addRow);
            ++row;
        }
        for (int i = 0; i < data.size(); ++i) {
            HSSFRow listRow = sheet.createRow(row);
            if (currentType != ((ProjectLedgerVo)data.get(i)).getProjectType()) {
                currentType = ((ProjectLedgerVo)data.get(i)).getProjectType();
                this.handleSubTitle(currentType, fileName, type, workbook, listRow);
                counter = 1;
                --i;
            } else if (((ProjectLedgerVo)data.get(i)).getProjectType() - currentType > 1) {
                int j = currentType++;
                while (j < ((ProjectLedgerVo)data.get(i)).getProjectType()) {
                    HSSFRow addRow = sheet.createRow(sheet.getLastRowNum() + 1);
                    this.handleSubTitle(currentType, fileName, type, workbook, addRow);
                    j = currentType++;
                }
            } else {
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(0), String.valueOf(counter), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(1), ((ProjectLedgerVo)data.get(i)).getProjectName(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(2), ((ProjectLedgerVo)data.get(i)).getProjectStatus(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(3), ((ProjectLedgerVo)data.get(i)).getProjectManager(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(4), ((ProjectLedgerVo)data.get(i)).getDecisionBasisType(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(5), ((ProjectLedgerVo)data.get(i)).getResponsibleUnit(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(6), ((ProjectLedgerVo)data.get(i)).getGeologicalProspectingUnit(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(7), ((ProjectLedgerVo)data.get(i)).getDesignUnit(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(8), ((ProjectLedgerVo)data.get(i)).getSupervisorUnit(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(9), ((ProjectLedgerVo)data.get(i)).getConstructUnit(), new boolean[0]);
                HSSFCell cell10 = listRow.createCell(10);
                cell10.setCellType(CellType.NUMERIC);
                BizUtils.handelCell(workbook, cellNumStyle, font, fileName, cell10, null == ((ProjectLedgerVo)data.get(i)).getContractAmount() ? 0.0 : Double.valueOf(((ProjectLedgerVo)data.get(i)).getContractAmount().stripTrailingZeros().toPlainString()), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(11), ((ProjectLedgerVo)data.get(i)).getBiddingChargeType(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(12), ((ProjectLedgerVo)data.get(i)).getProjectAddress(), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(13), ((ProjectLedgerVo)data.get(i)).getProjectContent(), new boolean[0]);
                HSSFCell cell14 = listRow.createCell(14);
                cell14.setCellType(CellType.NUMERIC);
                BizUtils.handelCell(workbook, cellNumStyle, font, fileName, cell14, StringUtils.isBlank((CharSequence)((ProjectLedgerVo)data.get(i)).getProjectMoney()) ? null : Double.valueOf(((ProjectLedgerVo)data.get(i)).getProjectMoney()), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(15), BizUtils.handleDateFormat(((ProjectLedgerVo)data.get(i)).getCommencementTime()), new boolean[0]);
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(16), BizUtils.handleDateFormat(((ProjectLedgerVo)data.get(i)).getCompletionTime()), new boolean[0]);
                ++counter;
            }
            ++row;
        }
        int lastIndex = sheet.getLastRowNum() + 1;
        int i = currentType++;
        while (i < pType.size()) {
            HSSFRow lastRow = sheet.createRow(lastIndex++);
            this.handleSubTitle(currentType, fileName, type, workbook, lastRow);
            i = currentType++;
        }
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 16));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 1));
        sheet.setColumnWidth(1, 6000);
        sheet.setColumnWidth(5, 6000);
        for (i = 2; i < heards.length; ++i) {
            if (i == 5) continue;
            sheet.setColumnWidth(i, 4000);
        }
        ExcelUtil.downloadExcel((HSSFWorkbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    private void handleSubTitle(int currentType, String fileName, Map<String, String> type, HSSFWorkbook workbook, HSSFRow row) {
        for (int t = 0; t < 17; ++t) {
            String temp = type.get(String.valueOf(currentType));
            if (BeanUtils.isEmpty((Object)temp)) {
                return;
            }
            String[] typeData = temp.split("[\uff1a]");
            if (t == 0) {
                BizUtils.handelCell(workbook, fileName, row.createCell(t), BizUtils.converttoChinaNumber(currentType), new boolean[0]);
                continue;
            }
            if (t == 1) {
                BizUtils.handelCell(workbook, fileName, row.createCell(t), typeData[0], new boolean[0]);
                continue;
            }
            if (t == 14) {
                BizUtils.handelCell(workbook, fileName, row.createCell(t), typeData[1], new boolean[0]);
                continue;
            }
            BizUtils.handelCell(workbook, fileName, row.createCell(t), "", new boolean[0]);
        }
    }
}

