package com.artfess.cqxy.processManagermant.dao;

import com.artfess.cqxy.statistics.vo.StatisticsVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import com.artfess.cqxy.processManagermant.model.ProgressManageReport;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 过程管理 - 进度管理 - 工程月报(BizProgressManageReport)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-03-11 17:46:51
 */
public interface ProgressManageReportDao extends BaseMapper<ProgressManageReport> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    ProgressManageReport getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<ProgressManageReport> queryAllByPage(IPage<ProgressManageReport> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ProgressManageReport> convert2Wrapper);


    /**
     * 根据项目ID查询总投资额
     * @param projectId
     * @return
     */
    BigDecimal getInvestmentTotal(@Param("projectId") String projectId, @Param("portDate") String portDate, @Param("contractId") String contractId);

    /**
     * 根据条件查询每月的投资金额
     * @param statisticsVo
     * @return
     */
    List<Map<String, Object>> queryInvestment(@Param("statisticsVo") StatisticsVo statisticsVo);

    /**
     * 根据项目ID查询最新的一条项目月报信息
     * @param projectId
     * @return
     */
    ProgressManageReport getByProjectId(@Param("projectId") String projectId);

    /**
     * 根据项目ID查询本月进度及累计总投资
     * @param projectId
     * @return
     */
    ProgressManageReport getProjectOvervieByProjectId(@Param("projectId") String projectId, @Param("portDate") String portDate);

    List<String> selectProjectIds();

    List<ProgressManageReport> selectByProjectId(@Param("projectId")String projectId);


    BigDecimal selectProgressDescriptionSum(@Param("projectId")String projectId, @Param("portDate")Date portDate, @Param("id")String id);
}

