package com.artfess.xqxt.meeting.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description:
 * @Author: YangYong
 * @Date: 2022/11/6 22:11
 */
@Data
public class MeetFeedBackVO {


    @ApiModelProperty("会议ID")
    private String meetingId;

    @ApiModelProperty("用户ID，如果没有传则表示当前登录用户")
    private String userId;

    @ApiModelProperty("反馈状态，0：已反馈，1：未反馈，默认为1")
    private String feedBackStatus;

    @ApiModelProperty("反馈结果，1：准时参加会议，2：推迟参加会议，3：不能参加会议")
    private String feedBack;

    @ApiModelProperty("预计入会时间，当反馈结果为推迟参加会议时填写")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime estimatedArrivalDate;

    @ApiModelProperty("预计晚到时间，单位：分钟，通过预计入会时间和会议开始时间进行计算")
    private Integer estimatedArrivalTime;

    @ApiModelProperty("未入会原因，当反馈结果不为准时参加会议时填写")
    private String notJoiningReasons;

    @ApiModelProperty("附件集合信息，未入会时可以上传附件")
    List<String> accessoryIds;
}
