package com.artfess.xqxt.meeting.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import com.artfess.xqxt.meeting.dao.BizMeetingTopicDao;
import com.artfess.xqxt.meeting.manager.BizMeetingOptionManager;
import com.artfess.xqxt.meeting.manager.BizMeetingQuestionManager;
import com.artfess.xqxt.meeting.manager.BizMeetingTopicManager;
import com.artfess.xqxt.meeting.manager.BizMeetingVoteManager;
import com.artfess.xqxt.meeting.model.BizMeetingOption;
import com.artfess.xqxt.meeting.model.BizMeetingQuestion;
import com.artfess.xqxt.meeting.model.BizMeetingTopic;
import com.artfess.xqxt.meeting.model.BizMeetingVote;
import com.google.api.client.util.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 会议投票主题表 服务实现类
 *
 * @author 管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-11-03
 */
@Service
public class BizMeetingTopicManagerImpl extends BaseManagerImpl<BizMeetingTopicDao, BizMeetingTopic> implements BizMeetingTopicManager {

    @Autowired
    private BizMeetingQuestionManager questionManager;

    @Autowired
    private BizMeetingOptionManager optionManager;

    @Autowired
    private BizMeetingVoteManager voteManager;

    @Override
    public PageList<BizMeetingTopic> query(QueryFilter<BizMeetingTopic> queryFilter) {
        PageList<BizMeetingTopic> result = super.query(queryFilter);
        List<BizMeetingQuestion> allQuestions = questionManager.list();
        List<BizMeetingOption> allOptions = optionManager.list();
        result.getRows().forEach(r -> {
            fillRealate(r, allQuestions, allOptions);
        });

        User currentUser = ContextUtil.getCurrentUser();
        List<BizMeetingVote> allVote = voteManager.list();

        result.getRows().forEach(r -> {
            r.getQuestionList().forEach(ql -> {
                long count = allVote.stream().filter(v -> v.getUserId().equals(currentUser.getId()) && v.getQuestionId().equals(ql.getId())).count();
                ql.setIsVoted(count >= 1);
            });
        });

        return result;
    }

    @Override
    public BizMeetingTopic getById(Serializable id) {
        BizMeetingTopic result = super.getById(id);
        List<BizMeetingQuestion> allQuestions = questionManager.list();
        List<BizMeetingOption> allOptions = optionManager.list();
        fillRealate(result, allQuestions, allOptions);
        return result;
    }

    private void fillRealate(BizMeetingTopic topic, List<BizMeetingQuestion> allQuestions, List<BizMeetingOption> allOptions) {
        List<BizMeetingQuestion> questionTemp = Lists.newArrayList();
        allQuestions.forEach(q -> {
            if (q.getTopicId().equals(topic.getId())) {
                List<BizMeetingOption> optionTemp = Lists.newArrayList();
                allOptions.forEach(o -> {
                    if (o.getQuestionId().equals(q.getId())) {
                        optionTemp.add(o);
                    }
                });
                q.setOptionList(optionTemp);
                questionTemp.add(q);
            }
        });
        topic.setQuestionList(questionTemp);
    }

    @Override
    @Transactional
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        List<String> questionIds = Lists.newArrayList();
        List<String> optionIds = Lists.newArrayList();
        List<BizMeetingTopic> allTopic = list();
        idList.forEach(id -> {
            allTopic.forEach(at -> {
                if (id.equals(at.getId())) {
                    if (BeanUtils.isEmpty(at.getQuestionList())) {
                        return;
                    }
                    at.getQuestionList().forEach(ql -> {
                        questionIds.add(ql.getId());
                        if (BeanUtils.isEmpty(ql.getOptionList())) {
                            return;
                        }
                        ql.getOptionList().forEach(ol -> {
                            optionIds.add(ol.getId());
                        });
                    });
                }
            });
        });
        boolean result = super.removeByIds(idList) &&
                BeanUtils.isEmpty(questionIds) ? true : questionManager.removeByIds(questionIds) &&
                BeanUtils.isEmpty(optionIds) ? true : optionManager.removeByIds(optionIds);
        if (!result) {
            throw new RuntimeException("操作失败，回滚事务......");
        }

        return result;
    }
}
