package com.artfess.xqxt.meeting.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.xqxt.meeting.model.MeetingUser;
import com.artfess.xqxt.meeting.vo.FeedBackCountVo;
import com.artfess.xqxt.meeting.vo.MeetFeedBackVO;

public interface MeetingUserManager extends BaseManager<MeetingUser> {


    /**
     * 人员反馈接口，
     * @param meetFeedBackVO 人员反馈信息
     */
    void feedBack(MeetFeedBackVO meetFeedBackVO);

    /**
     * 人员反馈统计接口
     * @param meetingId 会议id
     * @return
     */
    FeedBackCountVo feedBackCount(String meetingId);

    PageList<MeetingUser> findList(QueryFilter<MeetingUser> queryFilter);
}
