package com.artfess.xqxt.meeting.vo;

import com.artfess.base.entity.BizModel;
import com.artfess.xqxt.meeting.model.MeetingPlace;
import com.artfess.xqxt.meeting.model.MeetingUser;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;

import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Data
@ApiOperation(value = "中兴历史会议实体类VO")
public class HistoryConferenceVO {

    @ApiModelProperty("会议发起人帐号")
    private String account;

    @ApiModelProperty("查询选项 0 表示按时间段查询（即历史会议定时同步到第三方系统中），1 表示一次性按页查询（即历史会议保存在MS90 中）")
    private int option;

    @ApiModelProperty("查询起始时间 按照会议开始时间在StartTime和当前时间之间进行查询")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startTime;

    @ApiModelProperty("1~  页号，如果为-1，则表示不进行分页查询，查询所有的")
    private int page;

    @ApiModelProperty("10~100 每页显示多少条记录，如果为-1，则表示不进行分页查询，查询所有的")
    private int numPerPage;

    @ApiModelProperty("会议名称")
    private String conferenceName;

    @ApiModelProperty("会议编号")
    private String conferenceNumber;
}
