package com.artfess.uc.model;
import com.artfess.base.entity.AutoFillModel;
import org.apache.commons.lang.builder.ToStringBuilder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.BaseModel;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 法定节假日
 * <pre> 
 * 描述：法定节假日 实体对象
 * 构建组：x7
 * 作者:qiuxd
 * 邮箱:qiuxd@jee-soft.cn
 * 日期:2020-08-03 15:50:17
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
 @TableName("uc_holiday")
 @ApiModel(value = "Holiday",description = "法定节假日") 
public class Holiday extends UcBaseModel<Holiday> {

	private static final long serialVersionUID = 1L;
	@XmlTransient
	@TableId("ID_")
	@ApiModelProperty(value="主键")
	protected String id; 
	
	@XmlAttribute(name = "name")
	@TableField("NAME_")
	@ApiModelProperty(value="节日名称")
	protected String name; 
	
	@XmlAttribute(name = "key")
	@TableField("KEY_")
	@ApiModelProperty(value="节日KEY")
	protected String key; 
	
	@XmlAttribute(name = "desc")
	@TableField("DESC_")
	@ApiModelProperty(value="描述")
	protected String desc;

	 @XmlAttribute(name = "time")
	 @TableField(exist = false)
	 @ApiModelProperty(value="描述")
	 protected List<HolidayTime> time;
	
	public void setId(String id) {
		this.id = id;
	}
	
	/**
	 * 返回 主键
	 * @return
	 */
	public String getId() {
		return this.id;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * 返回 节日名称
	 * @return
	 */
	public String getName() {
		return this.name;
	}
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 返回 节日KEY
	 * @return
	 */
	public String getKey() {
		return this.key;
	}
	public void setDesc(String desc) {
		this.desc = desc;
	}
	
	/**
	 * 返回 描述
	 * @return
	 */
	public String getDesc() {
		return this.desc;
	}

	public List<HolidayTime> getTime() {
		return time;
	}

	public void setTime(List<HolidayTime> time) {
		this.time = time;
	}

	/**
	 * @see Object#toString()
	 */
	public String toString() {
		return new ToStringBuilder(this)
		.append("id", this.id) 
		.append("name", this.name) 
		.append("key", this.key) 
		.append("desc", this.desc)
		.toString();
	}
}