package com.artfess.security.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 安全中心  ---  涉密计算机维护表
 *
 * @company 阿特菲斯
 * @author cs
 * @since 2021-03-04
 */
@ApiModel(value="SecurityMachine对象", description="安全中心  ---  涉密计算机维护表")
@TableName("uc_Security_Machine")
public class SecurityMachine extends BaseModel<SecurityMachine> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_")
    @ApiModelProperty(name = "id", notes = "id")
    private String id;

    @ApiModelProperty(value = "租户Id")
    @TableField("TENANT_ID_")
    private String tenantId;

    @ApiModelProperty(value = "设备编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "设备名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "密级")
    @TableField("SECURITY_GRADE")
    private String securityGrade;

    @ApiModelProperty(value = "IP地址")
    @TableField("IP_")
    private String ip;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO_")
    private String memo;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    @TableField(exist = false)
    @ApiModelProperty(value="机器人员关联")
    protected List<SecurityPersonloginlimit> persons;

    public String getId() {
        return id;
    }
    public void setId(String id) {
        this.id = id;
    }

    public String getTenantId() {
        return tenantId;
    }
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getCode() {
        return code;
    }
    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }

    public String getSecurityGrade() {
        return securityGrade;
    }
    public void setSecurityGrade(String securityGrade) {
        this.securityGrade = securityGrade;
    }

    public String getIp() {
        return ip;
    }
    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getMemo() {
        return memo;
    }
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public List<SecurityPersonloginlimit> getPersons() {
        return persons;
    }

    public void setPersons(List<SecurityPersonloginlimit> persons) {
        this.persons = persons;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "SecurityMachine{" +
            "id=" + id +
            ", tenantId=" + tenantId +
            ", code=" + code +
            ", name=" + name +
            ", securityGrade=" + securityGrade +
            ", ip=" + ip +
            ", memo=" + memo +
            ", sn=" + sn +
        "}";
    }
}
