var SketchRuler = (function (exports) {
  'use strict';

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

      return arr2;
    }
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  //
  var script = {
    name: 'LineRuler',
    data: function data() {
      return {
        startValue: 0,
        showLine: true
      };
    },
    props: {
      index: Number,
      start: Number,
      vertical: Boolean,
      scale: Number,
      value: Number,
      palette: Object,
      isShowReferLine: Boolean,
      thick: Number
    },
    computed: {
      offset: function offset() {
        var offset = (this.startValue - this.start) * this.scale;

        if (offset < 0) {
          this.showLine = false;
        } else {
          this.showLine = true;
        }

        var positionValue = offset + 'px';
        var position = this.vertical ? {
          top: positionValue
        } : {
          left: positionValue
        };
        return position;
      },
      borderCursor: function borderCursor() {
        var borderValue = "1px solid ".concat(this.palette.lineColor);
        var border = this.vertical ? {
          borderTop: borderValue
        } : {
          borderLeft: borderValue
        };
        var cursorValue = this.isShowReferLine ? this.vertical ? 'ns-resize' : 'ew-resize' : 'none';
        return _objectSpread2({
          cursor: cursorValue
        }, border);
      },
      actionStyle: function actionStyle() {
        var actionStyle = this.vertical ? {
          left: this.thick + 'px'
        } : {
          top: this.thick + 'px'
        };
        return actionStyle;
      }
    },
    methods: {
      handleDown: function handleDown(e) {
        var _this = this;

        var startD = this.vertical ? e.clientY : e.clientX;
        var initValue = this.startValue;
        this.$emit('onMouseDown');

        var onMove = function onMove(e) {
          var currentD = _this.vertical ? e.clientY : e.clientX;
          var newValue = Math.round(initValue + (currentD - startD) / _this.scale);
          _this.startValue = newValue;
        };

        var onEnd = function onEnd() {
          _this.$emit('onRelease', _this.startValue, _this.index);

          document.removeEventListener('mousemove', onMove);
          document.removeEventListener('mouseup', onEnd);
        };

        document.addEventListener('mousemove', onMove);
        document.addEventListener('mouseup', onEnd);
      },
      handleRemove: function handleRemove() {
        this.$emit('onRemove', this.index);
      },
      initStartValue: function initStartValue() {
        this.startValue = this.value;
      }
    },
    mounted: function mounted() {
      this.initStartValue();
    }
  };

  function normalizeComponent(template, style, script, scopeId, isFunctionalTemplate, moduleIdentifier /* server only */, shadowMode, createInjector, createInjectorSSR, createInjectorShadow) {
      if (typeof shadowMode !== 'boolean') {
          createInjectorSSR = createInjector;
          createInjector = shadowMode;
          shadowMode = false;
      }
      // Vue.extend constructor export interop.
      var options = typeof script === 'function' ? script.options : script;
      // render functions
      if (template && template.render) {
          options.render = template.render;
          options.staticRenderFns = template.staticRenderFns;
          options._compiled = true;
          // functional template
          if (isFunctionalTemplate) {
              options.functional = true;
          }
      }
      // scopedId
      if (scopeId) {
          options._scopeId = scopeId;
      }
      var hook;
      if (moduleIdentifier) {
          // server build
          hook = function (context) {
              // 2.3 injection
              context =
                  context || // cached call
                      (this.$vnode && this.$vnode.ssrContext) || // stateful
                      (this.parent && this.parent.$vnode && this.parent.$vnode.ssrContext); // functional
              // 2.2 with runInNewContext: true
              if (!context && typeof __VUE_SSR_CONTEXT__ !== 'undefined') {
                  context = __VUE_SSR_CONTEXT__;
              }
              // inject component styles
              if (style) {
                  style.call(this, createInjectorSSR(context));
              }
              // register component module identifier for async chunk inference
              if (context && context._registeredComponents) {
                  context._registeredComponents.add(moduleIdentifier);
              }
          };
          // used by ssr in case component is cached and beforeCreate
          // never gets called
          options._ssrRegister = hook;
      }
      else if (style) {
          hook = shadowMode
              ? function (context) {
                  style.call(this, createInjectorShadow(context, this.$root.$options.shadowRoot));
              }
              : function (context) {
                  style.call(this, createInjector(context));
              };
      }
      if (hook) {
          if (options.functional) {
              // register for functional component in vue file
              var originalRender = options.render;
              options.render = function renderWithStyleInjection(h, context) {
                  hook.call(context);
                  return originalRender(h, context);
              };
          }
          else {
              // inject component registration as beforeCreate hook
              var existing = options.beforeCreate;
              options.beforeCreate = existing ? [].concat(existing, hook) : [hook];
          }
      }
      return script;
  }

  var isOldIE = typeof navigator !== 'undefined' &&
      /msie [6-9]\\b/.test(navigator.userAgent.toLowerCase());
  function createInjector(context) {
      return function (id, style) { return addStyle(id, style); };
  }
  var HEAD;
  var styles = {};
  function addStyle(id, css) {
      var group = isOldIE ? css.media || 'default' : id;
      var style = styles[group] || (styles[group] = { ids: new Set(), styles: [] });
      if (!style.ids.has(id)) {
          style.ids.add(id);
          var code = css.source;
          if (css.map) {
              // https://developer.chrome.com/devtools/docs/javascript-debugging
              // this makes source maps inside style tags work properly in Chrome
              code += '\n/*# sourceURL=' + css.map.sources[0] + ' */';
              // http://stackoverflow.com/a/26603875
              code +=
                  '\n/*# sourceMappingURL=data:application/json;base64,' +
                      btoa(unescape(encodeURIComponent(JSON.stringify(css.map)))) +
                      ' */';
          }
          if (!style.element) {
              style.element = document.createElement('style');
              style.element.type = 'text/css';
              if (css.media)
                  { style.element.setAttribute('media', css.media); }
              if (HEAD === undefined) {
                  HEAD = document.head || document.getElementsByTagName('head')[0];
              }
              HEAD.appendChild(style.element);
          }
          if ('styleSheet' in style.element) {
              style.styles.push(code);
              style.element.styleSheet.cssText = style.styles
                  .filter(Boolean)
                  .join('\n');
          }
          else {
              var index = style.ids.size - 1;
              var textNode = document.createTextNode(code);
              var nodes = style.element.childNodes;
              if (nodes[index])
                  { style.element.removeChild(nodes[index]); }
              if (nodes.length)
                  { style.element.insertBefore(textNode, nodes[index]); }
              else
                  { style.element.appendChild(textNode); }
          }
      }
  }

  /* script */
  var __vue_script__ = script;
  /* template */

  var __vue_render__ = function __vue_render__() {
    var _vm = this;

    var _h = _vm.$createElement;

    var _c = _vm._self._c || _h;

    return _c("div", {
      directives: [{
        name: "show",
        rawName: "v-show",
        value: _vm.showLine,
        expression: "showLine"
      }],
      staticClass: "line",
      style: [_vm.offset, _vm.borderCursor],
      on: {
        mousedown: _vm.handleDown
      }
    }, [_c("div", {
      staticClass: "action",
      style: _vm.actionStyle
    }, [_c("span", {
      staticClass: "del",
      on: {
        click: this.handleRemove
      }
    }, [_vm._v("×")]), _vm._v(" "), _c("span", {
      staticClass: "value"
    }, [_vm._v(_vm._s(_vm.startValue))])])]);
  };

  var __vue_staticRenderFns__ = [];
  __vue_render__._withStripped = true;
  /* style */

  var __vue_inject_styles__ = function __vue_inject_styles__(inject) {
    if (!inject) { return; }
    inject("data-v-55fc60d9_0", {
      source: ".line[data-v-55fc60d9] {\n  position: absolute;\n}\n.line .action[data-v-55fc60d9] {\n  position: absolute;\n  display: -webkit-box;\n  display: flex;\n  -webkit-box-pack: center;\n          justify-content: center;\n  -webkit-box-align: center;\n          align-items: center;\n}\n.line .value[data-v-55fc60d9] {\n  pointer-events: none;\n  -webkit-transform: scale(0.83);\n          transform: scale(0.83);\n}\n.line .del[data-v-55fc60d9] {\n  cursor: pointer;\n  padding: 3px 5px;\n  visibility: hidden;\n}\n.line:hover .del[data-v-55fc60d9] {\n  visibility: visible;\n}\n.h-container .line[data-v-55fc60d9] {\n  height: 100vh;\n  top: 0;\n  padding-left: 5px;\n}\n.h-container .line .action[data-v-55fc60d9] {\n  -webkit-transform: translateX(-24px);\n          transform: translateX(-24px);\n}\n.h-container .line .action .value[data-v-55fc60d9] {\n  margin-left: 4px;\n}\n.v-container .line[data-v-55fc60d9] {\n  width: 100vw;\n  left: 0;\n  padding-top: 5px;\n}\n.v-container .line .action[data-v-55fc60d9] {\n  -webkit-transform: translateY(-24px);\n          transform: translateY(-24px);\n  -webkit-box-orient: vertical;\n  -webkit-box-direction: normal;\n          flex-direction: column;\n}\n.v-container .line .action .value[data-v-55fc60d9] {\n  margin-top: 4px;\n}\n",
      map: {
        "version": 3,
        "sources": ["line.vue"],
        "names": [],
        "mappings": "AAAA;EACE,kBAAkB;AACpB;AACA;EACE,kBAAkB;EAClB,oBAAa;EAAb,aAAa;EACb,wBAAuB;UAAvB,uBAAuB;EACvB,yBAAmB;UAAnB,mBAAmB;AACrB;AACA;EACE,oBAAoB;EACpB,8BAAsB;UAAtB,sBAAsB;AACxB;AACA;EACE,eAAe;EACf,gBAAgB;EAChB,kBAAkB;AACpB;AACA;EACE,mBAAmB;AACrB;AACA;EACE,aAAa;EACb,MAAM;EACN,iBAAiB;AACnB;AACA;EACE,oCAA4B;UAA5B,4BAA4B;AAC9B;AACA;EACE,gBAAgB;AAClB;AACA;EACE,YAAY;EACZ,OAAO;EACP,gBAAgB;AAClB;AACA;EACE,oCAA4B;UAA5B,4BAA4B;EAC5B,4BAAsB;EAAtB,6BAAsB;UAAtB,sBAAsB;AACxB;AACA;EACE,eAAe;AACjB",
        "file": "line.vue",
        "sourcesContent": [".line {\n  position: absolute;\n}\n.line .action {\n  position: absolute;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n}\n.line .value {\n  pointer-events: none;\n  transform: scale(0.83);\n}\n.line .del {\n  cursor: pointer;\n  padding: 3px 5px;\n  visibility: hidden;\n}\n.line:hover .del {\n  visibility: visible;\n}\n.h-container .line {\n  height: 100vh;\n  top: 0;\n  padding-left: 5px;\n}\n.h-container .line .action {\n  transform: translateX(-24px);\n}\n.h-container .line .action .value {\n  margin-left: 4px;\n}\n.v-container .line {\n  width: 100vw;\n  left: 0;\n  padding-top: 5px;\n}\n.v-container .line .action {\n  transform: translateY(-24px);\n  flex-direction: column;\n}\n.v-container .line .action .value {\n  margin-top: 4px;\n}\n"]
      },
      media: undefined
    });
  };
  /* scoped */


  var __vue_scope_id__ = "data-v-55fc60d9";
  /* module identifier */

  var __vue_module_identifier__ = undefined;
  /* functional template */

  var __vue_is_functional_template__ = false;
  /* style inject SSR */

  /* style inject shadow dom */

  var __vue_component__ = normalizeComponent({
    render: __vue_render__,
    staticRenderFns: __vue_staticRenderFns__
  }, __vue_inject_styles__, __vue_script__, __vue_scope_id__, __vue_is_functional_template__, __vue_module_identifier__, false, createInjector, undefined, undefined);

  // 标尺中每小格代表的宽度(根据scale的不同实时变化)
  var getGridSize = function getGridSize(scale) {
    if (scale <= 0.25) { return 40; }
    if (scale <= 0.5) { return 20; }
    if (scale <= 1) { return 10; }
    if (scale <= 2) { return 5; }
    if (scale <= 4) { return 2; }
    return 1;
  };

  var FONT_SCALE = 0.83; // 10 / 12

  var drawHorizontalRuler = function drawHorizontalRuler(ctx, start, shadow, options) {
    var scale = options.scale,
        width = options.width,
        height = options.height,
        canvasConfigs = options.canvasConfigs;
    var bgColor = canvasConfigs.bgColor,
        fontColor = canvasConfigs.fontColor,
        shadowColor = canvasConfigs.shadowColor,
        ratio = canvasConfigs.ratio,
        longfgColor = canvasConfigs.longfgColor,
        shortfgColor = canvasConfigs.shortfgColor; // 缩放ctx, 以简化计算

    ctx.scale(ratio, ratio);
    ctx.clearRect(0, 0, width, height); // 1. 画标尺底色

    ctx.fillStyle = bgColor;
    ctx.fillRect(0, 0, width, height); // 2. 画阴影

    if (shadow) {
      var shadowX = (shadow.x - start) * scale; // 阴影起点坐标

      var shadowWidth = shadow.width * scale; // 阴影宽度

      ctx.fillStyle = shadowColor;
      ctx.fillRect(shadowX, 0, shadowWidth, height * 3 / 8);
    }

    var gridSize = getGridSize(scale); // 每小格表示的宽度

    var gridPixel = gridSize * scale;
    var gridSize_10 = gridSize * 10; // 每大格表示的宽度

    var gridPixel_10 = gridSize_10 * scale;
    var startValue = Math.floor(start / gridSize) * gridSize; // 绘制起点的刻度(略小于start, 且是gridSize的整数倍)

    var startValue_10 = Math.floor(start / gridSize_10) * gridSize_10; // 长间隔绘制起点的刻度(略小于start, 且是gridSize_10的整数倍)

    var offsetX = (startValue - start) / gridSize * gridPixel; // 起点刻度距离ctx原点(start)的px距离

    var offsetX_10 = (startValue_10 - start) / gridSize_10 * gridPixel_10; // 长间隔起点刻度距离ctx原点(start)的px距离

    var endValue = start + Math.ceil(width / scale); // 终点刻度(略超出标尺宽度即可)
    // 3. 画刻度和文字(因为刻度遮住了阴影)

    ctx.beginPath(); // 一定要记得开关路径,因为clearRect并不能清除掉路径,如果不关闭路径下次绘制时会接着上次的绘制

    ctx.fillStyle = fontColor;
    ctx.strokeStyle = longfgColor; // 长间隔和短间隔需要两次绘制，才可以完成不同颜色的设置；分开放到两个for循环是为了节省性能，因为如果放到一个for循环的话，每次循环都会重新绘制操作dom
    // 绘制长间隔和文字

    for (var value = startValue_10, count = 0; value < endValue; value += gridSize_10, count++) {
      var x = offsetX_10 + count * gridPixel_10 + 0.5; // prevent canvas 1px line blurry

      ctx.moveTo(x, 0);
      ctx.save();
      ctx.translate(x, height * 0.4);
      ctx.scale(FONT_SCALE / ratio, FONT_SCALE / ratio);
      ctx.fillText(value, 4 * ratio, 7 * ratio);
      ctx.restore();
      ctx.lineTo(x, height * 9 / 16);
    }

    ctx.stroke();
    ctx.closePath(); // 绘制短间隔

    ctx.beginPath();
    ctx.strokeStyle = shortfgColor;

    for (var _value = startValue, _count = 0; _value < endValue; _value += gridSize, _count++) {
      var _x = offsetX + _count * gridPixel + 0.5; // prevent canvas 1px line blurry


      ctx.moveTo(_x, 0);

      if (_value % gridSize_10 !== 0) {
        ctx.lineTo(_x, height * 1 / 4);
      }
    }

    ctx.stroke();
    ctx.closePath(); // 恢复ctx matrix

    ctx.setTransform(1, 0, 0, 1, 0, 0);
  };
  var drawVerticalRuler = function drawVerticalRuler(ctx, start, shadow, options) {
    var scale = options.scale,
        width = options.width,
        height = options.height,
        canvasConfigs = options.canvasConfigs;
    var bgColor = canvasConfigs.bgColor,
        fontColor = canvasConfigs.fontColor,
        shadowColor = canvasConfigs.shadowColor,
        ratio = canvasConfigs.ratio,
        longfgColor = canvasConfigs.longfgColor,
        shortfgColor = canvasConfigs.shortfgColor; // 缩放ctx, 以简化计算

    ctx.scale(ratio, ratio);
    ctx.clearRect(0, 0, width, height); // 1. 画标尺底色

    ctx.fillStyle = bgColor;
    ctx.fillRect(0, 0, width, height); // 2. 画阴影

    if (shadow) {
      // 阴影起点坐标
      var posY = (shadow.y - start) * scale; // 阴影高度

      var shadowHeight = shadow.height * scale;
      ctx.fillStyle = shadowColor;
      ctx.fillRect(0, posY, width * 3 / 8, shadowHeight);
    }

    var gridSize = getGridSize(scale); // 每小格表示的宽度

    var gridPixel = gridSize * scale;
    var gridSize_10 = gridSize * 10; // 每大格表示的宽度

    var gridPixel_10 = gridSize_10 * scale;
    var startValue = Math.floor(start / gridSize) * gridSize; // 绘制起点的刻度(略小于start, 且是gridSize的整数倍)

    var startValue_10 = Math.floor(start / gridSize_10) * gridSize_10; // 长间隔单独绘制起点的刻度

    var offsetY = (startValue - start) / gridSize * gridPixel; // 起点刻度距离ctx原点(start)的px距离

    var offsetY_10 = (startValue_10 - start) / gridSize_10 * gridPixel_10; // 长间隔起点刻度距离ctx原点(start)的px距离

    var endValue = start + Math.ceil(height / scale); // 终点刻度(略超出标尺宽度即可)
    // 3. 画刻度和文字(因为刻度遮住了阴影)

    ctx.beginPath(); // 一定要记得开关路径,因为clearRect并不能清除掉路径,如果不关闭路径下次绘制时会接着上次的绘制

    ctx.fillStyle = fontColor;
    ctx.strokeStyle = longfgColor; // 设置长间隔的颜色

    for (var value = startValue_10, count = 0; value < endValue; value += gridSize_10, count++) {
      var y = offsetY_10 + count * gridPixel_10 + 0.5;
      ctx.moveTo(0, y);
      ctx.save(); // 这里先保存一下状态

      ctx.translate(width * 0.4, y); // 将原点转移到当前画笔所在点

      ctx.rotate(-Math.PI / 2); // 旋转 -90 度

      ctx.scale(FONT_SCALE / ratio, FONT_SCALE / ratio); // 缩放至10px

      ctx.fillText(value, 4 * ratio, 7 * ratio); // 绘制文字
      // 回复刚刚保存的状态

      ctx.restore();
      ctx.lineTo(width * 9 / 16, y);
    }

    ctx.stroke(); // 绘制

    ctx.closePath(); // 长间隔和文字绘制关闭

    ctx.beginPath(); // 开始绘制短间隔

    ctx.strokeStyle = shortfgColor;

    for (var _value2 = startValue, _count2 = 0; _value2 < endValue; _value2 += gridSize, _count2++) {
      var _y = offsetY + _count2 * gridPixel + 0.5;

      ctx.moveTo(0, _y);

      if (_value2 % gridSize_10 !== 0) {
        ctx.lineTo(width * 1 / 4, _y);
      }
    }

    ctx.stroke();
    ctx.closePath(); // 恢复ctx matrix

    ctx.setTransform(1, 0, 0, 1, 0, 0);
  };

  //

  var getValueByOffset = function getValueByOffset(offset, start, scale) {
    return Math.round(start + offset / scale);
  };

  var script$1 = {
    name: 'CanvasRuler',
    data: function data() {
      return {
        $canvas: {},
        canvasContext: {}
      };
    },
    props: {
      vertical: Boolean,
      start: Number,
      scale: Number,
      width: Number,
      height: Number,
      canvasConfigs: Object,
      selectStart: Number,
      selectLength: Number
    },
    watch: {
      start: function start() {
        this.drawRuler();
      },
      width: function width(val) {
        this.updateCanvasContext();
        this.drawRuler();
      },
      height: function height(val) {
        this.updateCanvasContext();
        this.drawRuler();
      }
    },
    methods: {
      initCanvasRef: function initCanvasRef() {
        this.$canvas = this.$refs.$canvas;
        this.canvasContext = this.$canvas && this.$canvas.getContext('2d');
      },
      updateCanvasContext: function updateCanvasContext() {
        var ratio = this.canvasConfigs.ratio; // 比例宽高

        this.$canvas.width = this.width * ratio;
        this.$canvas.height = this.height * ratio;
        var ctx = this.$canvas.getContext('2d');
        ctx.font = "".concat(12 * ratio, "px -apple-system, \n                \"Helvetica Neue\", \".SFNSText-Regular\", \n                \"SF UI Text\", Arial, \"PingFang SC\", \"Hiragino Sans GB\", \n                \"Microsoft YaHei\", \"WenQuanYi Zen Hei\", sans-serif");
        ctx.lineWidth = 1;
        ctx.textBaseline = 'middle';
      },
      drawRuler: function drawRuler() {
        var options = {
          scale: this.scale,
          width: this.width,
          height: this.height,
          canvasConfigs: this.canvasConfigs
        };

        if (this.vertical) {
          drawVerticalRuler(this.canvasContext, this.start, {
            y: this.selectStart,
            height: this.selectLength
          }, options);
        } else {
          drawHorizontalRuler(this.canvasContext, this.start, {
            x: this.selectStart,
            width: this.selectLength
          }, options);
        }
      },
      handleClick: function handleClick(e) {
        var offset = this.vertical ? e.offsetY : e.offsetX;
        var value = getValueByOffset(offset, this.start, this.scale);
        this.$emit('onAddLine', value);
      },
      handleEnter: function handleEnter(e) {
        var offset = this.vertical ? e.offsetY : e.offsetX;
        var value = getValueByOffset(offset, this.start, this.scale);
        this.$emit('onIndicatorShow', value);
      },
      handleMove: function handleMove(e) {
        var offset = this.vertical ? e.offsetY : e.offsetX;
        var value = getValueByOffset(offset, this.start, this.scale);
        this.$emit('onIndicatorMove', value);
      },
      handleLeave: function handleLeave() {
        this.$emit('onIndicatorHide');
      }
    },
    mounted: function mounted() {
      this.initCanvasRef();
      this.updateCanvasContext();
      this.drawRuler();
    }
  };

  /* script */
  var __vue_script__$1 = script$1;
  /* template */

  var __vue_render__$1 = function __vue_render__() {
    var _vm = this;

    var _h = _vm.$createElement;

    var _c = _vm._self._c || _h;

    return _c("canvas", {
      ref: "$canvas",
      staticClass: "ruler",
      on: {
        click: _vm.handleClick,
        mouseenter: _vm.handleEnter,
        mousemove: _vm.handleMove,
        mouseleave: _vm.handleLeave
      }
    });
  };

  var __vue_staticRenderFns__$1 = [];
  __vue_render__$1._withStripped = true;
  /* style */

  var __vue_inject_styles__$1 = undefined;
  /* scoped */

  var __vue_scope_id__$1 = undefined;
  /* module identifier */

  var __vue_module_identifier__$1 = undefined;
  /* functional template */

  var __vue_is_functional_template__$1 = false;
  /* style inject */

  /* style inject SSR */

  /* style inject shadow dom */

  var __vue_component__$1 = normalizeComponent({
    render: __vue_render__$1,
    staticRenderFns: __vue_staticRenderFns__$1
  }, __vue_inject_styles__$1, __vue_script__$1, __vue_scope_id__$1, __vue_is_functional_template__$1, __vue_module_identifier__$1, false, undefined, undefined, undefined);

  var script$2 = {
    name: 'RulerWrapper',
    components: {
      CanvasRuler: __vue_component__$1,
      LineRuler: __vue_component__
    },
    props: {
      vertical: Boolean,
      scale: Number,
      width: Number,
      thick: Number,
      height: Number,
      start: Number,
      lines: Array,
      selectStart: Number,
      selectLength: Number,
      canvasConfigs: Object,
      palette: Object,
      isShowReferLine: Boolean,
      onShowRightMenu: Function,
      handleShowReferLine: Function
    },
    data: function data() {
      return {
        isDraggingLine: false,
        showIndicator: false,
        value: 0
      };
    },
    computed: {
      rwClassName: function rwClassName() {
        var className = this.vertical ? 'v-container' : 'h-container';
        return className;
      },
      rwStyle: function rwStyle() {
        var hContainer = {
          width: "calc(100% - ".concat(this.thick, "px)"),
          height: "".concat(this.thick + 1, "px"),
          left: "".concat(this.thick) + 'px'
        };
        var vContainer = {
          width: "".concat(this.thick + 1, "px"),
          height: "calc(100% - ".concat(this.thick, "px)"),
          top: "".concat(this.thick) + 'px'
        };
        return this.vertical ? vContainer : hContainer;
      },
      lineStyle: function lineStyle() {
        return {
          borderTop: "1px solid ".concat(this.palette.lineColor),
          cursor: this.isShowReferLine ? 'ns-resize' : 'none'
        };
      },
      indicatorStyle: function indicatorStyle() {
        var _ref;

        var indicatorOffset = (this.value - this.start) * this.scale;
        var positionKey = 'top';
        var boderKey = 'borderLeft';
        positionKey = this.vertical ? 'top' : 'left';
        boderKey = this.vertical ? 'borderBottom' : 'borderLeft';
        return _ref = {}, _defineProperty(_ref, positionKey, indicatorOffset + 'px'), _defineProperty(_ref, boderKey, "1px solid ".concat(this.palette.lineColor)), _ref;
      }
    },
    methods: {
      handleNewLine: function handleNewLine(value) {
        this.lines.push(value);
        this.$emit('onLineChange', this.lines, this.vertical); // !isShowReferLine && handleShowReferLine()
      },
      handleIndicatorShow: function handleIndicatorShow(value) {
        if (!this.isDraggingLine) {
          this.showIndicator = true;
          this.value = value;
        }
      },
      handleIndicatorMove: function handleIndicatorMove(value) {
        if (this.showIndicator) {
          this.value = value;
        }
      },
      handleIndicatorHide: function handleIndicatorHide() {
        this.showIndicator = false;
      },
      handleLineDown: function handleLineDown() {
        this.isDraggingLine = true;
      },
      handleLineRelease: function handleLineRelease(value, index) {
        this.isDraggingLine = false; // 左右或上下超出时, 删除该条对齐线

        var offset = value - this.start;
        var maxOffset = (this.vertical ? this.height : this.width) / this.scale;

        if (offset < 0 || offset > maxOffset) {
          this.handleLineRemove(index);
        } else {
          this.lines[index] = value;
          this.$emit('onLineChange', this.lines, this.vertical);
        }
      },
      handleLineRemove: function handleLineRemove(index) {
        this.lines.splice(index, 1);
        this.$emit('onLineChange', this.lines, this.vertical);
      }
    }
  };

  /* script */
  var __vue_script__$2 = script$2;
  /* template */

  var __vue_render__$2 = function __vue_render__() {
    var _vm = this;

    var _h = _vm.$createElement;

    var _c = _vm._self._c || _h;

    return _c("div", {
      "class": _vm.rwClassName,
      style: _vm.rwStyle
    }, [_c("CanvasRuler", {
      attrs: {
        vertical: _vm.vertical,
        scale: _vm.scale,
        width: _vm.width,
        height: _vm.height,
        start: _vm.start,
        selectStart: _vm.selectStart,
        selectLength: _vm.selectLength,
        canvasConfigs: _vm.canvasConfigs
      },
      on: {
        onAddLine: _vm.handleNewLine,
        onIndicatorShow: _vm.handleIndicatorShow,
        onIndicatorMove: _vm.handleIndicatorMove,
        onIndicatorHide: _vm.handleIndicatorHide
      }
    }), _vm._v(" "), _c("div", {
      directives: [{
        name: "show",
        rawName: "v-show",
        value: _vm.isShowReferLine,
        expression: "isShowReferLine"
      }],
      staticClass: "lines"
    }, _vm._l(_vm.lines, function (v, i) {
      return _c("LineRuler", {
        key: v + i,
        attrs: {
          index: i,
          value: v >> 0,
          scale: _vm.scale,
          start: _vm.start,
          thick: _vm.thick,
          palette: _vm.palette,
          vertical: _vm.vertical,
          isShowReferLine: _vm.isShowReferLine
        },
        on: {
          onRemove: _vm.handleLineRemove,
          onMouseDown: _vm.handleLineDown,
          onRelease: _vm.handleLineRelease
        }
      });
    }), 1), _vm._v(" "), _c("div", {
      directives: [{
        name: "show",
        rawName: "v-show",
        value: _vm.showIndicator,
        expression: "showIndicator"
      }],
      staticClass: "indicator",
      style: _vm.indicatorStyle
    }, [_c("div", {
      staticClass: "value"
    }, [_vm._v(_vm._s(_vm.value))])])], 1);
  };

  var __vue_staticRenderFns__$2 = [];
  __vue_render__$2._withStripped = true;
  /* style */

  var __vue_inject_styles__$2 = function __vue_inject_styles__(inject) {
    if (!inject) { return; }
    inject("data-v-39addac4_0", {
      source: ".line[data-v-39addac4] {\n  position: absolute;\n}\n.h-container[data-v-39addac4],\n.v-container[data-v-39addac4] {\n  position: absolute;\n}\n.h-container .lines[data-v-39addac4],\n.v-container .lines[data-v-39addac4] {\n  pointer-events: none;\n}\n.h-container:hover .lines[data-v-39addac4],\n.v-container:hover .lines[data-v-39addac4] {\n  pointer-events: auto;\n}\n.h-container[data-v-39addac4] {\n  top: 0;\n}\n.h-container .line[data-v-39addac4] {\n  height: 100vh;\n  top: 0;\n  padding-left: 5px;\n}\n.h-container .line .action[data-v-39addac4] {\n  -webkit-transform: translateX(-24px);\n          transform: translateX(-24px);\n}\n.h-container .line .action .value[data-v-39addac4] {\n  margin-left: 4px;\n}\n.h-container .indicator[data-v-39addac4] {\n  top: 0;\n  height: 100vw;\n}\n.h-container .indicator .value[data-v-39addac4] {\n  padding: 0 2px;\n  width: auto;\n  margin-left: 4px;\n  margin-top: 4px;\n}\n.v-container[data-v-39addac4] {\n  left: 0;\n}\n.v-container .line[data-v-39addac4] {\n  width: 100vw;\n  left: 0;\n  padding-top: 5px;\n}\n.v-container .line .action[data-v-39addac4] {\n  -webkit-transform: translateY(-24px);\n          transform: translateY(-24px);\n  -webkit-box-orient: vertical;\n  -webkit-box-direction: normal;\n          flex-direction: column;\n}\n.v-container .line .action .value[data-v-39addac4] {\n  margin-top: 4px;\n}\n.v-container .indicator[data-v-39addac4] {\n  width: 100vw;\n}\n.v-container .indicator .value[data-v-39addac4] {\n  padding: 0 2px;\n  width: auto;\n  left: 0px;\n  margin-left: 2px;\n  margin-top: -5px;\n  -webkit-transform-origin: 0 0;\n          transform-origin: 0 0;\n  -webkit-transform: rotate(-90deg);\n          transform: rotate(-90deg);\n}\n",
      map: {
        "version": 3,
        "sources": ["rulerWrapper.vue"],
        "names": [],
        "mappings": "AAAA;EACE,kBAAkB;AACpB;AACA;;EAEE,kBAAkB;AACpB;AACA;;EAEE,oBAAoB;AACtB;AACA;;EAEE,oBAAoB;AACtB;AACA;EACE,MAAM;AACR;AACA;EACE,aAAa;EACb,MAAM;EACN,iBAAiB;AACnB;AACA;EACE,oCAA4B;UAA5B,4BAA4B;AAC9B;AACA;EACE,gBAAgB;AAClB;AACA;EACE,MAAM;EACN,aAAa;AACf;AACA;EACE,cAAc;EACd,WAAW;EACX,gBAAgB;EAChB,eAAe;AACjB;AACA;EACE,OAAO;AACT;AACA;EACE,YAAY;EACZ,OAAO;EACP,gBAAgB;AAClB;AACA;EACE,oCAA4B;UAA5B,4BAA4B;EAC5B,4BAAsB;EAAtB,6BAAsB;UAAtB,sBAAsB;AACxB;AACA;EACE,eAAe;AACjB;AACA;EACE,YAAY;AACd;AACA;EACE,cAAc;EACd,WAAW;EACX,SAAS;EACT,gBAAgB;EAChB,gBAAgB;EAChB,6BAAqB;UAArB,qBAAqB;EACrB,iCAAyB;UAAzB,yBAAyB;AAC3B",
        "file": "rulerWrapper.vue",
        "sourcesContent": [".line {\n  position: absolute;\n}\n.h-container,\n.v-container {\n  position: absolute;\n}\n.h-container .lines,\n.v-container .lines {\n  pointer-events: none;\n}\n.h-container:hover .lines,\n.v-container:hover .lines {\n  pointer-events: auto;\n}\n.h-container {\n  top: 0;\n}\n.h-container .line {\n  height: 100vh;\n  top: 0;\n  padding-left: 5px;\n}\n.h-container .line .action {\n  transform: translateX(-24px);\n}\n.h-container .line .action .value {\n  margin-left: 4px;\n}\n.h-container .indicator {\n  top: 0;\n  height: 100vw;\n}\n.h-container .indicator .value {\n  padding: 0 2px;\n  width: auto;\n  margin-left: 4px;\n  margin-top: 4px;\n}\n.v-container {\n  left: 0;\n}\n.v-container .line {\n  width: 100vw;\n  left: 0;\n  padding-top: 5px;\n}\n.v-container .line .action {\n  transform: translateY(-24px);\n  flex-direction: column;\n}\n.v-container .line .action .value {\n  margin-top: 4px;\n}\n.v-container .indicator {\n  width: 100vw;\n}\n.v-container .indicator .value {\n  padding: 0 2px;\n  width: auto;\n  left: 0px;\n  margin-left: 2px;\n  margin-top: -5px;\n  transform-origin: 0 0;\n  transform: rotate(-90deg);\n}\n"]
      },
      media: undefined
    });
  };
  /* scoped */


  var __vue_scope_id__$2 = "data-v-39addac4";
  /* module identifier */

  var __vue_module_identifier__$2 = undefined;
  /* functional template */

  var __vue_is_functional_template__$2 = false;
  /* style inject SSR */

  /* style inject shadow dom */

  var __vue_component__$2 = normalizeComponent({
    render: __vue_render__$2,
    staticRenderFns: __vue_staticRenderFns__$2
  }, __vue_inject_styles__$2, __vue_script__$2, __vue_scope_id__$2, __vue_is_functional_template__$2, __vue_module_identifier__$2, false, createInjector, undefined, undefined);

  var DEFAULTMENU = {
    bgColor: '#fff',
    dividerColor: '#DBDBDB',
    listItem: {
      textColor: '#415058',
      hoverTextColor: '#298DF8',
      disabledTextColor: 'rgba(65, 80, 88, 0.4)',
      bgColor: '#fff',
      hoverBgColor: '#F2F2F2'
    }
  };
  var script$3 = {
    name: 'SketchRuler',
    components: {
      RulerWrapper: __vue_component__$2
    },
    data: function data() {
      return {
        vertical: true
      };
    },
    props: {
      scale: {
        type: Number,
        "default": 1
      },
      ratio: {
        type: Number,
        "default": window.devicePixelRatio || 1
      },
      thick: {
        type: Number,
        "default": 16
      },
      width: Number,
      height: Number,
      startX: {
        type: Number,
        "default": 0
      },
      startY: {
        type: Number,
        "default": 0
      },
      shadow: {
        type: Object,
        "default": function _default() {
          return {
            x: 200,
            y: 100,
            width: 200,
            height: 400
          };
        }
      },
      horLineArr: {
        type: Array,
        "default": function _default() {
          return [100, 200];
        }
      },
      verLineArr: {
        type: Array,
        "default": function _default() {
          return [100, 200];
        }
      },
      cornerActive: Boolean,
      lang: String,
      isOpenMenuFeature: false,
      handleShowRuler: {
        type: Function,
        "default": function _default() {
          return function () {};
        }
      },
      isShowReferLine: {
        type: Boolean,
        "default": true
      },
      handleShowReferLine: {
        type: Function,
        "default": function _default() {
          return function () {};
        }
      },
      palette: {
        type: Object,
        "default": function _default() {
          return {
            bgColor: 'rgba(225,225,225, 0)',
            // ruler bg color
            longfgColor: '#BABBBC',
            // ruler longer mark color
            shortfgColor: '#C8CDD0',
            // ruler shorter mark color
            fontColor: '#7D8694',
            // ruler font color
            shadowColor: '#E8E8E8',
            // ruler shadow color
            lineColor: '#EB5648',
            borderColor: '#DADADC',
            cornerActiveColor: 'rgb(235, 86, 72, 0.6)',
            menu: DEFAULTMENU
          };
        }
      }
    },
    computed: {
      cornerActiveClass: function cornerActiveClass() {
        return this.cornerActive ? ' active' : '';
      },
      cornerStyle: function cornerStyle() {
        return {
          backgroundColor: this.palette.bgColor,
          width: this.thick + 'px',
          height: this.thick + 'px',
          borderRight: "1px solid ".concat(this.palette.borderColor),
          borderBottom: "1px solid ".concat(this.palette.borderColor)
        };
      },
      canvasConfigs: function canvasConfigs() {
        var _this$palette = this.palette,
            bgColor = _this$palette.bgColor,
            longfgColor = _this$palette.longfgColor,
            shortfgColor = _this$palette.shortfgColor,
            fontColor = _this$palette.fontColor,
            shadowColor = _this$palette.shadowColor,
            lineColor = _this$palette.lineColor,
            borderColor = _this$palette.borderColor,
            cornerActiveColor = _this$palette.cornerActiveColor;
        return {
          ratio: this.ratio,
          bgColor: bgColor,
          longfgColor: longfgColor,
          shortfgColor: shortfgColor,
          fontColor: fontColor,
          shadowColor: shadowColor,
          lineColor: lineColor,
          borderColor: borderColor,
          cornerActiveColor: cornerActiveColor
        };
      }
    },
    methods: {
      onCornerClick: function onCornerClick(e) {
        this.$emit('onCornerClick', e);
      },
      handleLineChange: function handleLineChange(arr, vertical) {
        var newLines = vertical ? {
          h: this.horLineArr,
          v: _toConsumableArray(arr)
        } : {
          h: _toConsumableArray(arr),
          v: this.verLineArr
        };
        this.$emit('handleLine', newLines);
      }
    }
  };

  /* script */
  var __vue_script__$3 = script$3;
  /* template */

  var __vue_render__$3 = function __vue_render__() {
    var _vm = this;

    var _h = _vm.$createElement;

    var _c = _vm._self._c || _h;

    return _c("div", {
      staticClass: "style-ruler mb-ruler",
      attrs: {
        id: "mb-ruler"
      }
    }, [_c("RulerWrapper", {
      attrs: {
        vertical: false,
        width: _vm.width,
        height: _vm.thick,
        isShowReferLine: _vm.isShowReferLine,
        thick: _vm.thick,
        start: _vm.startX,
        lines: _vm.horLineArr,
        selectStart: _vm.shadow.x,
        selectLength: _vm.shadow.width,
        scale: _vm.scale,
        palette: _vm.palette,
        canvasConfigs: _vm.canvasConfigs
      },
      on: {
        onLineChange: _vm.handleLineChange
      }
    }), _vm._v(" "), _c("RulerWrapper", {
      attrs: {
        vertical: true,
        width: _vm.thick,
        height: _vm.height,
        isShowReferLine: _vm.isShowReferLine,
        thick: _vm.thick,
        start: _vm.startY,
        lines: _vm.verLineArr,
        selectStart: _vm.shadow.y,
        selectLength: _vm.shadow.height,
        scale: _vm.scale,
        palette: _vm.palette,
        canvasConfigs: _vm.canvasConfigs
      },
      on: {
        onLineChange: _vm.handleLineChange
      }
    }), _vm._v(" "), _c("a", {
      staticClass: "corner",
      "class": _vm.cornerActiveClass,
      style: _vm.cornerStyle,
      on: {
        click: _vm.onCornerClick
      }
    })], 1);
  };

  var __vue_staticRenderFns__$3 = [];
  __vue_render__$3._withStripped = true;
  /* style */

  var __vue_inject_styles__$3 = function __vue_inject_styles__(inject) {
    if (!inject) { return; }
    inject("data-v-43134c46_0", {
      source: ".style-ruler {\n  position: absolute;\n  width: 100%;\n  /* scrollbar width */\n  height: 100%;\n  z-index: 3;\n  /* 需要比resizer高 */\n  pointer-events: none;\n  font-size: 12px;\n  overflow: hidden;\n}\n.style-ruler span {\n  line-height: 1;\n}\n.corner {\n  position: absolute;\n  left: 0;\n  top: 0;\n  pointer-events: auto;\n  cursor: pointer;\n  -webkit-transition: all 0.2s ease-in-out;\n  transition: all 0.2s ease-in-out;\n  box-sizing: content-box;\n}\n.indicator {\n  position: absolute;\n  pointer-events: none;\n}\n.indicator .value {\n  position: absolute;\n  background: white;\n}\n.corner {\n  position: absolute;\n  left: 0;\n  top: 0;\n  pointer-events: auto;\n  cursor: pointer;\n  -webkit-transition: all 0.2s ease-in-out;\n  transition: all 0.2s ease-in-out;\n  box-sizing: content-box;\n}\n.ruler {\n  width: 100%;\n  height: 100%;\n  pointer-events: auto;\n}\n",
      map: {
        "version": 3,
        "sources": ["sketchRuler.vue"],
        "names": [],
        "mappings": "AAAA;EACE,kBAAkB;EAClB,WAAW;EACX,oBAAoB;EACpB,YAAY;EACZ,UAAU;EACV,gBAAgB;EAChB,oBAAoB;EACpB,eAAe;EACf,gBAAgB;AAClB;AACA;EACE,cAAc;AAChB;AACA;EACE,kBAAkB;EAClB,OAAO;EACP,MAAM;EACN,oBAAoB;EACpB,eAAe;EACf,wCAAgC;EAAhC,gCAAgC;EAChC,uBAAuB;AACzB;AACA;EACE,kBAAkB;EAClB,oBAAoB;AACtB;AACA;EACE,kBAAkB;EAClB,iBAAiB;AACnB;AACA;EACE,kBAAkB;EAClB,OAAO;EACP,MAAM;EACN,oBAAoB;EACpB,eAAe;EACf,wCAAgC;EAAhC,gCAAgC;EAChC,uBAAuB;AACzB;AACA;EACE,WAAW;EACX,YAAY;EACZ,oBAAoB;AACtB",
        "file": "sketchRuler.vue",
        "sourcesContent": [".style-ruler {\n  position: absolute;\n  width: 100%;\n  /* scrollbar width */\n  height: 100%;\n  z-index: 3;\n  /* 需要比resizer高 */\n  pointer-events: none;\n  font-size: 12px;\n  overflow: hidden;\n}\n.style-ruler span {\n  line-height: 1;\n}\n.corner {\n  position: absolute;\n  left: 0;\n  top: 0;\n  pointer-events: auto;\n  cursor: pointer;\n  transition: all 0.2s ease-in-out;\n  box-sizing: content-box;\n}\n.indicator {\n  position: absolute;\n  pointer-events: none;\n}\n.indicator .value {\n  position: absolute;\n  background: white;\n}\n.corner {\n  position: absolute;\n  left: 0;\n  top: 0;\n  pointer-events: auto;\n  cursor: pointer;\n  transition: all 0.2s ease-in-out;\n  box-sizing: content-box;\n}\n.ruler {\n  width: 100%;\n  height: 100%;\n  pointer-events: auto;\n}\n"]
      },
      media: undefined
    });
  };
  /* scoped */


  var __vue_scope_id__$3 = undefined;
  /* module identifier */

  var __vue_module_identifier__$3 = undefined;
  /* functional template */

  var __vue_is_functional_template__$3 = false;
  /* style inject SSR */

  /* style inject shadow dom */

  var __vue_component__$3 = normalizeComponent({
    render: __vue_render__$3,
    staticRenderFns: __vue_staticRenderFns__$3
  }, __vue_inject_styles__$3, __vue_script__$3, __vue_scope_id__$3, __vue_is_functional_template__$3, __vue_module_identifier__$3, false, createInjector, undefined, undefined);

  // Import vue component

  function install(Vue) {
    if (install.installed) { return; }
    install.installed = true;
    Vue.component(__vue_component__$3.name, __vue_component__$3);
  } // Create module definition for Vue.use()

  var plugin = {
    install: install
  }; // Auto-install when vue is found (eg. in browser via <script> tag)

  var GlobalVue = null;

  if (typeof window !== 'undefined') {
    GlobalVue = window.Vue;
  } else if (typeof global !== 'undefined') {
    GlobalVue = global.Vue;
  }

  if (GlobalVue) {
    GlobalVue.use(plugin);
  } // To allow use as module (npm/webpack/etc.) export component

  exports.default = __vue_component__$3;
  exports.install = install;

  return exports;

}({}));
