/// <reference path="amap.d.ts" />
/// <reference path="global.d.ts" />

export declare type EditableOptions<
  T extends AMapComponent = AMapComponent,
  E extends AMapEditor = AMapEditor
> = {
  events: string[];
  loadEditor(): Promise<any>;
  initEditor(AMap: AMapGlobal, map: AMap.Map, target: T, opts: any): Promise<E>;
  onEdit(e: any): void;
  initEditing?(): Promise<E>;
  startEditing?(): Promise<any>;
  endEditing?(): void;
};

declare module './amap-vue' {
  interface AMapMeta<T extends AMapComponent = AMapComponent> {
    editable?: EditableOptions<T>;
  }
}
