/// <reference path="amap.d.ts" />
/// <reference path="global.d.ts" />
/// <reference path="amap-vue.d.ts" />
/// <reference path="editable.d.ts" />
/// <reference path="props.d.ts" />
/// <reference path="utils.d.ts" />

import AmapVue from '../index';
import { ExtractVue } from '../mixins/mixins';
import Amap from '../amap';
import Marker from '../marker';
import LabelMarker from '../label-marker';
import LabelsLayer from '../labels-layer';
import Polygon from '../polygon';
import Polyline from '../polyline';
import BezierCurve from '../bezier-curve';
import Circle from '../circle';
import CircleMarker from '../circle-marker';
import Ellipse from '../ellipse';
import Rectangle from '../rectangle';
import Text from '../text';
import InfoWindow from '../info-window';
import TileLayer from '../tile-layer';
import RoadNet from '../road-net-layer';
import Satellite from '../satellite-layer';
import Traffic from '../traffic-layer';
import Flexible from '../flexible-layer';
import ImageLayer from '../image-layer';
import CanvasLayer from '../canvas-layer';
import CustomLayer from '../canvas-layer';
import ControlBar from '../control-bar';
import HawkEye from '../hawk-eye';
import MapType from '../map-type';
import Scale from '../scale';
import ToolBar from '../tool-bar';
import MouseTool from '../mouse-tool';
import MarkerCluster from '../marker-cluster';

export declare type AmapVM = ExtractVue<typeof Amap>;
export declare type MarkerVM = ExtractVue<typeof Marker>;
export declare type LabelMarkerVM = ExtractVue<typeof LabelMarker>;
export declare type LabelsLayerVM = ExtractVue<typeof LabelsLayer>;
export declare type PolygonVM = ExtractVue<typeof Polygon>;
export declare type PolylineVM = ExtractVue<typeof Polyline>;
export declare type BezierCurveVM = ExtractVue<typeof BezierCurve>;
export declare type CircleVM = ExtractVue<typeof Circle>;
export declare type CircleMarkerVM = ExtractVue<typeof CircleMarker>;
export declare type EllipseVM = ExtractVue<typeof Ellipse>;
export declare type RectangleVM = ExtractVue<typeof Rectangle>;
export declare type TextVM = ExtractVue<typeof Text>;
export declare type InfoWindowVM = ExtractVue<typeof InfoWindow>;
export declare type TileLayerVM = ExtractVue<typeof TileLayer>;
export declare type TileLayerRoadNetVM = ExtractVue<typeof RoadNet>;
export declare type TileLayerSatelliteVM = ExtractVue<typeof Satellite>;
export declare type TileLayerTrafficVM = ExtractVue<typeof Traffic>;
export declare type TileLayerFlexibleVM = ExtractVue<typeof Flexible>;
export declare type ImageLayerVM = ExtractVue<typeof ImageLayer>;
export declare type CanvasLayerVM = ExtractVue<typeof CanvasLayer>;
export declare type CustomLayerVM = ExtractVue<typeof CustomLayer>;
export declare type ControlBarVM = ExtractVue<typeof ControlBar>;
export declare type HawkEyeVM = ExtractVue<typeof HawkEye>;
export declare type MapTypeVM = ExtractVue<typeof MapType>;
export declare type ScaleVM = ExtractVue<typeof Scale>;
export declare type ToolBarVM = ExtractVue<typeof ToolBar>;
export declare type MouseToolVM = ExtractVue<typeof MouseTool>;
export declare type MarkerClusterVM = ExtractVue<typeof MarkerCluster>;

export * from '../index';

export default AmapVue;
