/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.file.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.rescue.file.dao.BizRescueFileCommonDao;
import com.artfess.rescue.file.manager.BizRescueFileCommonManager;
import com.artfess.rescue.file.model.BizRescueFileCommon;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BizRescueFileCommonManagerImpl
implements BizRescueFileCommonManager {
    @Resource
    BaseContext baseContext;
    @Resource
    FileManager fileManager;
    @Autowired
    BizRescueFileCommonDao fileDao;

    @Override
    public List<BizRescueFileCommon> getFilePreviewLikeCommonIds(List<String> ids) {
        List<BizRescueFileCommon> files = this.fileDao.getFiles(ids);
        if (files != null && !files.isEmpty()) {
            for (BizRescueFileCommon file : files) {
                String previewFile = null;
                try {
                    previewFile = this.minioPreviewFile(file.getFilePath());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                file.setFilePreviewUrl(previewFile);
            }
        }
        return files;
    }

    @Override
    public List<BizRescueFileCommon> getFileByCommonId(String id) {
        List<BizRescueFileCommon> files = this.fileDao.getSysFiles(id);
        if (files != null && !files.isEmpty()) {
            for (BizRescueFileCommon file : files) {
                String previewFile = null;
                try {
                    previewFile = this.minioPreviewFile(file.getFilePath());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                file.setFilePreviewUrl(previewFile);
            }
        }
        return files;
    }

    @Override
    public void qrCodeSaveOrUpdate(BizRescueFileCommon fileCommon) {
        this.fileManager.updateFileBizIdByIds(Arrays.asList(fileCommon.getFileId()), fileCommon.getCommonId());
    }

    @Override
    public String minioPreviewFile(String fileName) {
        try {
            return this.fileManager.minioPreviewFile(null, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public BizRescueFileCommon viewQrCode() {
        String userId = this.baseContext.getCurrentUserId();
        BizRescueFileCommon fileCommon = this.fileDao.viewQrCode(userId);
        if (BeanUtils.isNotEmpty((Object)fileCommon) && StringUtils.isNotEmpty((CharSequence)fileCommon.getFilePath())) {
            String previewFile = null;
            try {
                previewFile = this.minioPreviewFile(fileCommon.getFilePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            fileCommon.setFilePreviewUrl(previewFile);
        }
        return fileCommon;
    }
}

