/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.external.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum TrafficEventTypeEnum {
    ADDCTRL("addctrl", "\u6dfb\u52a0\u7ba1\u5236", 4),
    SUBMIT("submit", "\u63d0\u4ea4\u4e8b\u4ef6", 1),
    REVJAM("revjam", "\u89e3\u9664\u62e5\u5835", 3),
    UPDATE("update", "\u66f4\u65b0\u4fee\u6539\u4e8b\u4ef6", 1),
    ADDJAM("addjam", "\u6dfb\u52a0\u62e5\u5835", 3),
    REVEVENT("revevent", "\u89e3\u9664\u4e8b\u4ef6", 1),
    RESUBMIT("resubmit", "\u7eed\u62a5", 2),
    REVCTRL("revctrl", "\u89e3\u9664\u7ba1\u5236", 4),
    DELCTRL("delctrl", "\u5220\u9664\u7ba1\u5236", 4),
    DELJAM("deljam", "\u5220\u9664\u62e5\u5835", 3),
    SYSTEM_UPDATE("systemUpdate", "\u7cfb\u7edf\u6dfb\u52a0\u7684\u8bb0\u5f55\u7528\u4e8e\u5411\u4ea4\u901a\u5c40\u63a8\u9001", 5);

    private final String optType;
    private final String desc;
    private final int group;

    public static Integer getGroupByOptType(String optType) {
        for (TrafficEventTypeEnum e : TrafficEventTypeEnum.values()) {
            if (!e.getOptType().equalsIgnoreCase(optType)) continue;
            return e.getGroup();
        }
        return 0;
    }

    public static List<String> getOptTypesByGroup(int group) {
        return Arrays.stream(TrafficEventTypeEnum.values()).filter(e -> e.getGroup() == group).map(TrafficEventTypeEnum::getOptType).collect(Collectors.toList());
    }

    public static String getGroupName(int group) {
        switch (group) {
            case 1: {
                return "\u4e09\u7c7b\u4e8b\u4ef6";
            }
            case 2: {
                return "\u7eed\u62a5\u4fe1\u606f";
            }
            case 3: {
                return "\u4e8b\u4ef6\u62e5\u5835";
            }
            case 4: {
                return "\u4ea4\u901a\u7ba1\u5236";
            }
            case 5: {
                return "\u7cfb\u7edf\u8bb0\u5f55";
            }
        }
        return "\u672a\u77e5\u7c7b\u578b";
    }

    public String getOptType() {
        return this.optType;
    }

    public String getDesc() {
        return this.desc;
    }

    public int getGroup() {
        return this.group;
    }

    private TrafficEventTypeEnum(String optType, String desc, int group) {
        this.optType = optType;
        this.desc = desc;
        this.group = group;
    }
}

