/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.event.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.rescue.event.dto.EventInfoDto;
import com.artfess.rescue.event.manager.BizEventHandleManager;
import com.artfess.rescue.event.model.BizEventHandle;
import com.artfess.rescue.event.vo.HandInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/event/bizEventHandle/v1/"})
@Api(tags={"\u4e8b\u4ef6\u5904\u7f6e\u8bb0\u5f55"})
@ApiGroup(group={"group_biz_rescue"})
public class BizEventHandleController
extends BaseController<BizEventHandleManager, BizEventHandle> {
    @RequestMapping(value={"/accept"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e8b\u4ef6\u63a5\u6536", httpMethod="POST", notes="\u4e8b\u4ef6\u63a5\u6536")
    public CommonResult<String> accept(@RequestBody EventInfoDto t) {
        boolean res;
        return new CommonResult(res, (res = ((BizEventHandleManager)this.baseService).accept(t)) ? "\u63a5\u6536\u6210\u529f" : "\u63a5\u6536\u5931\u8d25");
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={AddGroup.class}) @RequestBody BizEventHandle t) {
        ((BizEventHandleManager)this.baseService).saveInfo(t);
        return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/pc"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3(pc\u7ba1\u7406)")
    public CommonResult<String> createPc(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={AddGroup.class}) @RequestBody BizEventHandle t) {
        ((BizEventHandleManager)this.baseService).savePcInfo(t);
        return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f");
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={UpdateGroup.class}) @RequestBody BizEventHandle t) {
        boolean res = ((BizEventHandleManager)this.baseService).updateInfo(t);
        if (!res) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult("\u66f4\u65b0\u5b9e\u4f53\u6210\u529f");
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u6839\u636e\u4e8b\u4ef6id\u67e5\u8be2list\u96c6\u5408")
    public CommonResult<String> list(@RequestParam(value="eventId") String eventId) {
        List<HandInfoVO> hands = ((BizEventHandleManager)this.baseService).getHands(eventId);
        return CommonResult.success(hands, (String)"");
    }

    @GetMapping(value={"/handList"})
    @ApiOperation(value="\u6839\u636e\u4e8b\u4ef6id\u67e5\u8be2list\u96c6\u5408")
    public CommonResult<String> handList(@RequestParam(value="eventId") String eventId) {
        List<HandInfoVO> hands = ((BizEventHandleManager)this.baseService).getHandInfo(eventId);
        return CommonResult.success(hands, (String)"");
    }

    @PostMapping(value={"/finish"})
    @ApiOperation(value="\u4e8b\u4ef6\u6279\u91cf\u5b8c\u7ed3")
    public CommonResult<String> batchFinish(String ... ids) {
        return ((BizEventHandleManager)this.baseService).batchFinish(Arrays.asList(ids));
    }
}

