/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.event.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.rescue.event.manager.BizCompensationInfoManager;
import com.artfess.rescue.event.model.BizCompensationInfo;
import com.artfess.rescue.event.vo.CountCompensationNumVO;
import com.artfess.rescue.event.vo.CountCompensationTypeVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/event/bizCompensationInfo/v1/"})
@Api(tags={"\u8def\u635f\u8d54\u507f\u4fe1\u606f"})
@ApiGroup(group={"group_biz_rescue"})
public class BizCompensationInfoController
extends BaseController<BizCompensationInfoManager, BizCompensationInfo> {
    @ApiOperation(value="\u5bfc\u51fa")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizCompensationInfo> queryFilter) {
        ((BizCompensationInfoManager)this.baseService).export(response, request, queryFilter);
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={AddGroup.class}) @RequestBody BizCompensationInfo t) {
        boolean res = ((BizCompensationInfoManager)this.baseService).saveInfo(t);
        return new CommonResult(res ? "\u6dfb\u52a0\u6210\u529f" : "\u6dfb\u52a0\u5931\u8d25");
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={UpdateGroup.class}) @RequestBody BizCompensationInfo t) {
        boolean res = ((BizCompensationInfoManager)this.baseService).updateInfo(t);
        if (!res) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult("\u66f4\u65b0\u5b9e\u4f53\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public BizCompensationInfo getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizCompensationInfoManager)this.baseService).getById(id);
    }

    @RequestMapping(value={"/count/frequency"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8def\u635f\u7edf\u8ba1-\u8def\u4ea7\u5355\u6570\u91cf\u7edf\u8ba1", httpMethod="POST", notes="\u8def\u4ea7\u5355\u6570\u91cf\u7edf\u8ba1")
    public CommonResult<List<CountCompensationNumVO>> countFrequency(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizCompensationInfo> queryFilter) {
        return ((BizCompensationInfoManager)this.baseService).countFrequency(queryFilter);
    }

    @RequestMapping(value={"/count/type"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8def\u635f\u7edf\u8ba1-\u8def\u4ea7\u635f\u5931\u9879\u76ee\u7edf\u8ba1", httpMethod="POST", notes="\u8def\u4ea7\u635f\u5931\u9879\u76ee\u7edf\u8ba1")
    public CommonResult<List<CountCompensationTypeVO>> countType(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizCompensationInfo> queryFilter) {
        return ((BizCompensationInfoManager)this.baseService).countType(queryFilter);
    }
}

