/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.cloud.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.rescue.cloud.dto.CloudApplyAndSaveDTO;
import com.artfess.rescue.cloud.dto.CloudApplySaveDTO;
import com.artfess.rescue.cloud.manager.BizCloudApplyManager;
import com.artfess.rescue.cloud.model.BizCloudApply;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizCloudApply/v1/"})
@Api(tags={"\u79c1\u6709\u4e91\u8d44\u6e90\u7533\u8bf7"})
@ApiGroup(group={"group_biz_rescue"})
public class BizCloudApplyController
extends BaseController<BizCloudApplyManager, BizCloudApply> {
    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody BizCloudApply cloudApply) {
        return ((BizCloudApplyManager)this.baseService).saveInfo(cloudApply);
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<BizCloudApply> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizCloudApply> queryFilter) {
        return ((BizCloudApplyManager)this.baseService).queryInfoPage(queryFilter);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public BizCloudApply getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizCloudApplyManager)this.baseService).getInfoById(id);
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody BizCloudApply cloudApply) {
        return ((BizCloudApplyManager)this.baseService).updateInfoById(cloudApply);
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizCloudApplyManager)this.baseService).deleteInfoById(id);
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        return ((BizCloudApplyManager)this.baseService).deleteInfoByIds(Arrays.asList(ids));
    }

    @PostMapping(value={"save/apply"})
    @ApiOperation(value="\u4fdd\u5b58\u5e76\u63d0\u4ea4\u5ba1\u6838\u7533\u8bf7")
    public CommonResult<String> createAndApply(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody CloudApplyAndSaveDTO dto) {
        return ((BizCloudApplyManager)this.baseService).saveAndApply(dto);
    }

    @PostMapping(value={"/query/todo"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5f53\u524d\u7528\u6237\u81ea\u5df1\u5f85\u5ba1\u6838\u3001\u5f85\u6267\u884c\u7684\u7533\u8bf7\u5355")
    public PageList<BizCloudApply> queryTodo(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizCloudApply> queryFilter) {
        return ((BizCloudApplyManager)this.baseService).queryTodoPage(queryFilter);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u7533\u8bf7\u5355\u53ca\u4f7f\u7528\u60c5\u51b5\u65b0\u589e/\u4fdd\u5b58")
    public CommonResult<String> cloudApplySave(@ApiParam(name="CloudApplySaveDTO", value="\u79c1\u6709\u4e91\u8d44\u6e90\u7533\u8bf7\u53ca\u4f7f\u7528\u60c5\u51b5\u65b0\u589e") @RequestBody CloudApplySaveDTO dto) {
        if (StringUtil.isEmpty((String)dto.getCloudApply().getId())) {
            return ((BizCloudApplyManager)this.baseService).cloudApplySave(dto);
        }
        return ((BizCloudApplyManager)this.baseService).cloudApplyUpdate(dto);
    }

    @GetMapping(value={"getInfo/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u79c1\u6709\u4e91\u8d44\u6e90\u7533\u8bf7\u53ca\u4f7f\u7528\u60c5\u51b5")
    public CloudApplySaveDTO getCloudApplyInfo(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizCloudApplyManager)this.baseService).getCloudApplyInfo(id);
    }

    @GetMapping(value={"export/{id}"})
    @ApiOperation(value="\u79c1\u6709\u4e91\u8d44\u6e90\u7533\u8bf7\u8868\u5bfc\u51fa")
    public void export(@ApiParam(name="ID", value="\u79c1\u6709\u4e91\u8d44\u6e90\u7533\u8bf7ID") @PathVariable String id, HttpServletResponse response) {
        ((BizCloudApplyManager)this.baseService).export(id, response);
    }
}

