/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.monitor.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.rescue.base.manager.BizOrgReflectionManager;
import com.artfess.rescue.base.model.BizOrgReflection;
import com.artfess.rescue.monitor.dao.BizCallAgentsDao;
import com.artfess.rescue.monitor.manager.BizCallAgentsManager;
import com.artfess.rescue.monitor.model.BizCallAgents;
import com.artfess.rescue.monitor.vo.CountCallAgentsVO;
import com.artfess.rescue.report.dto.FilterDto;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizCallAgentsManagerImpl
extends BaseManagerImpl<BizCallAgentsDao, BizCallAgents>
implements BizCallAgentsManager {
    @Resource
    private BizOrgReflectionManager orgReflectionManager;

    @Override
    @Transactional(readOnly=true)
    public PageList<BizCallAgents> queryPage(QueryFilter<BizCallAgents> queryFilter) {
        for (QueryField query : queryFilter.getQuerys()) {
            if (!query.getProperty().equals("roadId")) continue;
            List roadIds = (List)query.getValue();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(BizOrgReflection::getRoadId, (Collection)roadIds);
            List list = this.orgReflectionManager.list((Wrapper)wrapper);
            if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
            List callAgentsRoadIds = list.stream().map(BizOrgReflection::getCallAgentsRoadId).collect(Collectors.toList());
            query.setValue(callAgentsRoadIds);
        }
        return this.query(queryFilter);
    }

    @Override
    public JSONObject countCall(FilterDto dto) {
        JSONObject object = new JSONObject();
        List voList = Optional.ofNullable(((BizCallAgentsDao)this.baseMapper).salesGroupedCall(dto)).orElseGet(ArrayList::new);
        object.put("data", (Object)voList);
        CountCallAgentsVO vo = ((BizCallAgentsDao)this.baseMapper).salesSummaryCall(dto);
        object.put("total", (Object)vo);
        return object;
    }
}

