/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.event.manager.impl;

import com.artfess.base.cache.CacheManager;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.rescue.event.dao.BizRescueAppraiseDao;
import com.artfess.rescue.event.manager.BizRescueAppraiseManager;
import com.artfess.rescue.event.manager.BizRescueHandleManager;
import com.artfess.rescue.event.model.BizRescueAppraise;
import com.artfess.rescue.event.model.BizRescueHandle;
import com.artfess.rescue.file.manager.BizRescueFileCommonManager;
import com.artfess.rescue.file.model.BizRescueFileCommon;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizRescueAppraiseManagerImpl
extends BaseManagerImpl<BizRescueAppraiseDao, BizRescueAppraise>
implements BizRescueAppraiseManager {
    @Resource
    BizRescueHandleManager handleManager;
    @Resource
    SysDictionaryDetailManager sysDictionaryDetailManager;
    @Resource
    FileManager fileManager;
    @Resource
    BizRescueFileCommonManager fileCommonManager;
    @Autowired
    CacheManager cacheManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveInfo(BizRescueAppraise t) {
        boolean save = this.save((Object)(t = this.dataGovern(t)));
        if (!save) {
            throw new BaseException("\u8bc4\u4ef7\u8bb0\u5f55\u5931\u8d25");
        }
        BizRescueHandle handle = this.handleManager.setHands();
        handle.setRescueNode("12");
        String rescueId = t.getRescueId();
        if (rescueId != null) {
            handle.setRescueId(rescueId);
            try {
                String resultText = this.sysDictionaryDetailManager.getTextByValue("hfjg", t.getRevisitResult().toString());
                handle.setHandleInfo("\u56de\u8bbf\u7ed3\u679c\uff1a" + resultText);
                boolean b = this.handleManager.save((Object)handle);
                if (!b) {
                    throw new BaseException("\u56de\u8bbf\u8bb0\u5f55\u5931\u8d25");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        List<BizRescueFileCommon> rescueFiles = t.getRescueFiles();
        this.specialFiles(rescueFiles, t.getId(), "rescueCost");
        List<BizRescueFileCommon> appraiseFiles = t.getAppraiseFiles();
        this.commonFiles(appraiseFiles, t.getId(), "rescueAppraise");
        return true;
    }

    private void specialFiles(List<BizRescueFileCommon> specialFiles, String bizId, String bizCode) {
        if (!CollectionUtils.isEmpty(specialFiles)) {
            List unboundFileIds;
            List existFileIds = specialFiles.stream().filter(f -> !StringUtil.isEmpty((String)f.getCommonId())).map(BizRescueFileCommon::getFileId).collect(Collectors.toList());
            if (!existFileIds.isEmpty()) {
                List existFiles = this.fileManager.list((Wrapper)new LambdaQueryWrapper().in(DefaultFile::getId, existFileIds));
                existFiles.forEach(f -> {
                    f.setId(null);
                    f.setBizCode(bizCode);
                    f.setBizId(bizId);
                });
                this.fileManager.saveBatch((Collection)existFiles);
            }
            if (!(unboundFileIds = specialFiles.stream().filter(f -> StringUtil.isEmpty((String)f.getCommonId())).map(BizRescueFileCommon::getFileId).collect(Collectors.toList())).isEmpty()) {
                this.fileManager.updateFileBizIdByIds(unboundFileIds, bizId, bizCode);
            } else {
                this.fileManager.removeFile(bizId, bizCode);
            }
        }
    }

    private void commonFiles(List<BizRescueFileCommon> commonFiles, String bizId, String bizCode) {
        if (!CollectionUtils.isEmpty(commonFiles)) {
            List fileIds = commonFiles.stream().map(BizRescueFileCommon::getFileId).collect(Collectors.toList());
            this.fileManager.updateFileBizIdByIds(fileIds, bizId, bizCode);
        } else {
            this.fileManager.removeFile(bizId, bizCode);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(BizRescueAppraise t) {
        boolean update = this.updateById((Object)(t = this.dataGovern(t)));
        if (!update) {
            return false;
        }
        List<BizRescueFileCommon> rescueFiles = t.getRescueFiles();
        if (CollectionUtils.isNotEmpty(rescueFiles)) {
            List fileIds = rescueFiles.stream().map(BizRescueFileCommon::getFileId).collect(Collectors.toList());
            this.fileManager.updateFileBizIdByIds(fileIds, t.getId(), "rescueCost");
        }
        this.commonFiles(rescueFiles, t.getId(), "rescueCost");
        List<BizRescueFileCommon> appraiseFiles = t.getAppraiseFiles();
        this.commonFiles(appraiseFiles, t.getId(), "rescueAppraise");
        return true;
    }

    BizRescueAppraise dataGovern(BizRescueAppraise t) {
        Integer revisitResult = t.getRevisitResult();
        Assert.notNull((Object)revisitResult, (String)"\u9700\u56de\u8bbf\u7684\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        if (revisitResult.equals(2) || revisitResult.equals(3)) {
            t.setAppraiseTime(null);
            t.setAppraiseScore(null);
            t.setAppraiseTel(null);
            t.setIsComplain(null);
            t.setIsCost(null);
            t.setIsInvoice(null);
            t.setIsInvoice(null);
            t.setAppraiseInfo(null);
        }
        return t;
    }

    @Override
    public BizRescueAppraise getInfo(String id) {
        BizRescueAppraise appraise = (BizRescueAppraise)this.get((Serializable)((Object)id));
        if (appraise == null) {
            return new BizRescueAppraise();
        }
        List<BizRescueFileCommon> files = this.fileCommonManager.getFileByCommonId(id);
        if (files != null && !files.isEmpty()) {
            Map<String, List<BizRescueFileCommon>> map = files.stream().filter(p -> p.getBizCode() != null).collect(Collectors.groupingBy(BizRescueFileCommon::getBizCode));
            appraise.setRescueFiles(map.get("rescueCost"));
            appraise.setAppraiseFiles(map.get("rescueAppraise"));
        }
        return appraise;
    }

    @Override
    public List<BizRescueFileCommon> getRescueFileCommons(String rescueId) {
        List<String> idList = this.handleManager.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizRescueHandle::getRescueId, (Object)rescueId)).in(BizRescueHandle::getRescueNode, Arrays.asList(10, 11))).eq(BizRescueHandle::getIsDele, (Object)"0")).stream().map(BizRescueHandle::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        return this.fileCommonManager.getFilePreviewLikeCommonIds(idList).stream().peek(file -> file.setBizCode("rescueCost")).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean bathRatings() {
        List<BizRescueAppraise> bizRescueAppraises = ((BizRescueAppraiseDao)this.baseMapper).defaultRatings();
        boolean saveBatch = this.saveBatch(bizRescueAppraises);
        if (!saveBatch) {
            return false;
        }
        ArrayList bizRescueHandles = new ArrayList();
        bizRescueAppraises.forEach(app -> {
            BizRescueHandle handle = new BizRescueHandle();
            handle.setRescueNode("12");
            String rescueId = app.getRescueId();
            if (rescueId != null) {
                handle.setRescueId(rescueId);
                handle.setHandleInfo("\u56de\u8bbf\u7ed3\u679c\uff1a\u6ee1\u610f");
                handle.setHandleTime(LocalDateTime.now());
                handle.setHandleUserId("1");
                handle.setHandleUserName("\u7cfb\u7edf\u7ba1\u7406\u5458");
            }
            bizRescueHandles.add(handle);
        });
        return this.handleManager.saveBatch(bizRescueHandles);
    }
}

