/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.workbench.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.rescue.event.dao.BizEventInfoDao;
import com.artfess.rescue.event.manager.BizEventInfoManager;
import com.artfess.rescue.event.manager.BizRescueInfoManager;
import com.artfess.rescue.event.model.BizEventInfo;
import com.artfess.rescue.event.model.BizRescueInfo;
import com.artfess.rescue.event.vo.EventNumVO;
import com.artfess.rescue.event.vo.PushTaskVO;
import com.artfess.rescue.patrol.dao.BizInspectionResultDetailDao;
import com.artfess.rescue.patrol.manager.BizInspectionResultDetailManager;
import com.artfess.rescue.patrol.manager.BizInspectionTaskManager;
import com.artfess.rescue.patrol.model.BizInspectionResultDetail;
import com.artfess.rescue.patrol.model.BizInspectionTask;
import com.artfess.rescue.patrol.vo.IssuePatrolVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDate;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/workbench/v1/"})
@Api(tags={"\u5de5\u4f5c\u53f0"})
@ApiGroup(group={"group_biz_rescue"})
public class WorkbenchController {
    @Resource
    BizEventInfoDao eventInfoDao;
    @Resource
    BizEventInfoManager eventInfoManager;
    @Resource
    BizRescueInfoManager rescueInfoManager;
    @Resource
    BizInspectionTaskManager inspectionTaskManager;
    @Resource
    BizInspectionResultDetailDao resultDetailDao;
    @Resource
    BizInspectionResultDetailManager resultDetailManager;

    @GetMapping(value={"/pushTaskNum"})
    @ApiOperation(value="\u6b63\u5728\u63a8\u8fdb\u7684\u4efb\u52a1\u6570")
    public CommonResult<?> pushTaskNum(@RequestParam(required=false) LocalDate startTime, @RequestParam(required=false) LocalDate endTime, @RequestParam(required=false) List<String> orgList) {
        PushTaskVO numVO = this.eventInfoDao.pushTaskNum(startTime, endTime, orgList);
        return CommonResult.success((Object)numVO, (String)"");
    }

    @GetMapping(value={"/eventNum"})
    @ApiOperation(value="\u4e8b\u4ef6\u6570")
    public CommonResult<?> eventNum(@RequestParam(required=false) LocalDate startTime, @RequestParam(required=false) LocalDate endTime, @RequestParam(required=false) List<String> orgList) {
        startTime = BeanUtils.isEmpty((Object)startTime) ? LocalDate.now() : startTime;
        endTime = BeanUtils.isEmpty((Object)endTime) ? LocalDate.now() : endTime;
        EventNumVO numVO = this.eventInfoDao.eventNum(startTime, endTime, orgList);
        return CommonResult.success((Object)numVO, (String)"");
    }

    @GetMapping(value={"/issuePatrol"})
    @ApiOperation(value="\u5f02\u5e38\u70b9\u4f4d\u60c5\u51b5")
    public CommonResult<?> issuePatrol(@RequestParam(required=false) LocalDate startTime, @RequestParam(required=false) LocalDate endTime, @RequestParam(required=false) List<String> orgList) {
        startTime = BeanUtils.isEmpty((Object)startTime) ? LocalDate.now() : startTime;
        endTime = BeanUtils.isEmpty((Object)endTime) ? LocalDate.now() : endTime;
        IssuePatrolVO numVO = this.resultDetailDao.issuePatrol(startTime, endTime, orgList);
        return CommonResult.success((Object)numVO, (String)"");
    }

    @PostMapping(value={"/pushTaskNumList"})
    @ApiOperation(value="\u6b63\u5728\u63a8\u8fdb\u7684\u4efb\u52a1\u5217\u8868")
    public PageList<?> pushTaskNumList(@RequestParam(required=true) Integer type, @RequestBody QueryFilter queryFilter) {
        switch (type) {
            case 1: {
                return this.inspectionTaskManager.pushInspectList((QueryFilter<BizInspectionTask>)queryFilter);
            }
            case 2: {
                return this.eventInfoManager.pushTaskList((QueryFilter<BizEventInfo>)queryFilter);
            }
            case 3: {
                return this.rescueInfoManager.pushTaskList((QueryFilter<BizRescueInfo>)queryFilter);
            }
        }
        return null;
    }

    @PostMapping(value={"/eventList"})
    @ApiOperation(value="\u4e8b\u4ef6\u5217\u8868")
    public PageList<?> eventNum(@RequestBody QueryFilter<BizEventInfo> queryFilter) {
        return this.eventInfoManager.eventList(queryFilter);
    }

    @PostMapping(value={"/issuePatrolList"})
    @ApiOperation(value="\u5f02\u5e38\u70b9\u4f4d\u60c5\u51b5\u5217\u8868")
    public PageList<?> issuePatrol(@RequestBody QueryFilter<BizInspectionResultDetail> queryFilter) {
        return this.resultDetailManager.issuePatrolList(queryFilter);
    }
}

