/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.base.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.rescue.base.dao.BizBaseRoadDao;
import com.artfess.rescue.base.manager.BizBaseRoadManager;
import com.artfess.rescue.base.manager.BizOrgReflectionManager;
import com.artfess.rescue.base.model.BizBaseRoad;
import com.artfess.rescue.base.model.BizOrgReflection;
import com.artfess.rescue.base.vo.OrgRoadVO;
import com.artfess.rescue.base.vo.RoadConfigVO;
import com.artfess.rescue.integrate.consts.YhxtConsts;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizBaseRoadManagerImpl
extends BaseManagerImpl<BizBaseRoadDao, BizBaseRoad>
implements BizBaseRoadManager {
    @Resource
    YhxtConsts yhxtConsts;
    @Resource
    BaseContext baseContext;
    @Resource
    private UCFeignService feignService;
    @Resource
    private BizOrgReflectionManager orgReflectionManager;
    private static final String ORG_ROAD_KEY = "org:road:key:grade4_xc:";
    private static final String ROAD_KEY = "road:key:grade4_xc:";
    private static final Integer GRADE = 5;
    private static final String ORG_ID_ADMIN = "1765985726257963008";

    @Override
    @Transactional
    public void SynchronizeData() {
        List<BizBaseRoad> roads = this.yhxtConsts.getRoad();
        Map<String, List<BizBaseRoad>> roadMap = roads.stream().collect(Collectors.groupingBy(BizBaseRoad::getId));
        if (roadMap.isEmpty()) {
            super.saveOrUpdateBatch(roads);
        } else {
            roads.forEach(road -> Optional.ofNullable(road.getId()).map(roadMap::get).filter(baseRoads -> !baseRoads.isEmpty()).ifPresent(baseRoads -> {
                BizBaseRoad baseRoad = (BizBaseRoad)((Object)((Object)((Object)baseRoads.get(0))));
                road.setXcUploadImage(baseRoad.getXcUploadImage());
                road.setXcTempClock(baseRoad.getXcTempClock());
                road.setSjUploadImage(baseRoad.getSjUploadImage());
                road.setJyUploadImage(baseRoad.getJyUploadImage());
            }));
            super.saveOrUpdateBatch(roads);
        }
    }

    @Override
    public List<OrgRoadVO> roadTree() {
        String orgId = this.baseContext.isAdmin() != false ? "1766017468444450816" : this.baseContext.getCurrentOrgId();
        List<OrgRoadVO> lists = this.getOrgTree(orgId);
        lists = BizBaseRoadManagerImpl.getChild(lists, orgId);
        return this.setCountRoadTree(lists);
    }

    @Override
    public void updateConfig(RoadConfigVO t) {
        Assert.notNull((Object)t, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)t.getId(), (String)"\u8def\u6bb5ID\u4e0d\u80fd\u4e3a\u7a7a");
        BizBaseRoad road = (BizBaseRoad)((Object)this.getById((Serializable)((Object)t.getId())));
        Assert.notNull((Object)((Object)road), (String)"\u8def\u6bb5\u4e0d\u5b58\u5728");
        road.setXcUploadImage(t.getXcUploadImage());
        road.setXcTempClock(t.getXcTempClock());
        road.setSjUploadImage(t.getSjUploadImage());
        road.setJyUploadImage(t.getJyUploadImage());
        this.update((Model)road);
    }

    @Override
    public RoadConfigVO getConfig(String id) {
        BizBaseRoad road = (BizBaseRoad)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)road), (String)"\u8def\u6bb5\u4e0d\u5b58\u5728");
        RoadConfigVO vo = new RoadConfigVO();
        vo.setId(id);
        vo.setCode(road.getCode());
        vo.setName(road.getName());
        vo.setSimplicity(road.getSimplicity());
        vo.setXcUploadImage(road.getXcUploadImage() == null ? 0 : road.getXcUploadImage());
        vo.setXcTempClock(road.getXcTempClock() == null ? 0 : road.getXcTempClock());
        vo.setSjUploadImage(road.getSjUploadImage() == null ? 0 : road.getSjUploadImage());
        vo.setJyUploadImage(road.getJyUploadImage() == null ? 0 : road.getJyUploadImage());
        return vo;
    }

    @Override
    @Transactional(readOnly=true)
    public PageList<BizBaseRoad> queryInfoPage(QueryFilter<BizBaseRoad> queryFilter) {
        PageList query = this.query(queryFilter);
        query.getRows().forEach(bizBaseRoad -> {
            String path = bizBaseRoad.getCompanyIds();
            String[] ids = path.split("\\.");
            if (ids.length >= 4) {
                String fourthId = ids[3];
                bizBaseRoad.setOrgId(fourthId);
            }
        });
        return query;
    }

    private List<OrgRoadVO> setCountRoadTree(List<OrgRoadVO> list) {
        Iterator<OrgRoadVO> it = list.iterator();
        while (it.hasNext()) {
            OrgRoadVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<BizBaseRoad> roadList = new ArrayList<BizBaseRoad>();
            if (grade < 5) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.list((Wrapper)roadQueryWrapper);
            } else if (grade == 5) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.list((Wrapper)roadByNameQueryWrapper);
            }
            if (roadList.size() > 0) {
                orgVO = this.newCountWorkOrder(roadList, orgVO);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.parseInt(orgVO.getGrade()) >= 5) continue;
            this.setCount(orgVO.getChirldren());
        }
        return list;
    }

    public List<OrgRoadVO> setCount(List<OrgRoadVO> list) {
        Iterator<OrgRoadVO> it = list.iterator();
        while (it.hasNext()) {
            OrgRoadVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<BizBaseRoad> roadList = new ArrayList<BizBaseRoad>();
            if (grade < 5) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.list((Wrapper)roadQueryWrapper);
            } else if (grade == 5) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.list((Wrapper)roadByNameQueryWrapper);
            }
            if (roadList.size() > 0) {
                orgVO = this.newCountWorkOrder(roadList, orgVO);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 5) continue;
            this.setCount(orgVO.getChirldren());
        }
        return list;
    }

    public OrgRoadVO newCountWorkOrder(List<BizBaseRoad> ids, OrgRoadVO orgVO) {
        orgVO.setRoadCount(ids.size());
        orgVO.setRoadLength(BigDecimal.valueOf(ids.stream().mapToDouble(BizBaseRoad::getLength).sum()));
        if ("5".equals(orgVO.getGrade())) {
            orgVO.setRoadSegmentId(ids.get(0).getId());
        }
        return orgVO;
    }

    public static List<OrgRoadVO> getChild(List<OrgRoadVO> allList, String pCode) {
        ArrayList<OrgRoadVO> returnList = new ArrayList<OrgRoadVO>();
        for (OrgRoadVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(BizBaseRoadManagerImpl.getChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    private OrgRoadVO countRoadTree(List<BizBaseRoad> ids, OrgRoadVO orgVO) {
        orgVO.setRoadCount(ids.size());
        orgVO.setRoadLength(BigDecimal.valueOf(ids.stream().mapToDouble(BizBaseRoad::getLength).sum()));
        orgVO.setOrgId(orgVO.getId());
        if ("5".equals(orgVO.getGrade())) {
            orgVO.setRoadSegmentId(ids.get(0).getId());
            orgVO.setId(orgVO.getRoadSegmentId());
        }
        return orgVO;
    }

    private List<OrgRoadVO> getOrgTree(String orgId) {
        ArrayNode treeData = this.feignService.getOrgListByParentId(orgId);
        ArrayList<OrgRoadVO> allList = new ArrayList<OrgRoadVO>();
        ArrayList<OrgRoadVO> rtnList = new ArrayList<OrgRoadVO>();
        List orgReflections = this.orgReflectionManager.getAll();
        Map<String, List<BizOrgReflection>> orgReflectionMap = orgReflections.stream().collect(Collectors.groupingBy(BizOrgReflection::getOrgId));
        for (JsonNode node : treeData) {
            OrgRoadVO vo = new OrgRoadVO();
            vo.setId(node.get("id").asText());
            vo.setName(node.get("name").asText());
            vo.setParentId(node.get("parentId").asText());
            vo.setCode(node.get("code").asText());
            vo.setGrade(node.get("grade").asText());
            vo.setOrgKind(node.get("orgKind").asText());
            vo.setDemId(node.get("demId").asText());
            vo.setIsMaster(node.get("isMaster").asInt());
            vo.setPath(node.get("path").asText());
            vo.setPathName(node.get("pathName").asText());
            vo.setIsIsParent(node.get("isParent").asInt());
            if (orgReflectionMap.containsKey(vo.getId())) {
                vo.setOrganizationId(orgReflectionMap.get(vo.getId()).get(0).getOrganizationId());
            }
            allList.add(vo);
        }
        List<OrgRoadVO> list = BizBaseRoadManagerImpl.getOrgChild(allList, orgId, rtnList);
        return list;
    }

    public static List<OrgRoadVO> getOrgChild(List<OrgRoadVO> orgList, String parentId, List<OrgRoadVO> rtnList) {
        for (OrgRoadVO org : orgList) {
            if (!parentId.equals(org.getParentId()) || Integer.valueOf(org.getGrade()) >= 6) continue;
            BizBaseRoadManagerImpl.getOrgChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }
}

