import { dictionaryEscape, getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = []
    const fixedOptionList: IOption[] = [
        {
            title: '供方名称',
            prop: 'companyName',
            type: 'input',
            span: 4,
            value: ''
        }
        // {
        //     title: '法定代表人',
        //     prop: 'legalRepresentative',
        //     type: 'input',
        //     span: 4,
        //     value: ''
        // },
        // {
        //     title: '注册资本',
        //     prop: 'registeredCapital',
        //     type: 'input',
        //     value: '',
        //     span: 4
        // },
        // {
        //     title: '准入时间',
        //     prop: 'createTime',
        //     type: 'date',
        //     dateOption: {
        //         type: 'datetimerange',
        //         format: 'YYYY-MM-DD HH:mm:ss',
        //         valueFormat: 'YYYY-MM-DD HH:mm:ss',
        //         defaultTime: [new Date(0, 0, 0, 0, 0, 0), new Date(0, 0, 0, 23, 59, 59)]
        //     },
        //     span: 6,
        //     value: []
        // }
    ]
    const columnsList: COption[] = [
        {
            title: '供方名称',
            prop: 'companyName',
            minWidth: 160,
            sortable: true
        },
        {
            title: '类型',
            prop: 'ownerType',
            minWidth: 120,
            sortable: true
        },
        {
            title: '法定代表人',
            prop: 'companyEbe',
            minWidth: 120,
            sortable: true
        },
        {
            title: '注册资本(万元)',
            prop: 'registeredCapital',
            minWidth: 120,
            sortable: true
        },
        {
            title: '淘汰原因',
            prop: 'dismissalReason',
            minWidth: 160,
            sortable: true
        },
        {
            title: '淘汰时间',
            prop: 'createTime',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
