import request from '@/requset/axios'

// 获取未读消息数量
export function getMsgbadge() {
    return new Promise((resolve, reject) => {
        request
            .get(`/msg/messageReceiver/v1/getMsgbadge`)
            .then((res) => {
                resolve(res.data || {})
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}

// 获取消息列表
export function messageReceiver(data = {}) {
    return new Promise((resolve, reject) => {
        request
            .post(`/msg/messageReceiver/v1/list`, data)
            .then((res) => {
                resolve(res.data || {})
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}

// 删除消息
export function removeMessage(ids: string) {
    return new Promise((resolve, reject) => {
        request
            .delete(`/msg/messageReceiver/v1/remove?ids=${ids}`)
            .then((res) => {
                resolve(res.data || {})
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}

// 标记已读
export function markMessage(ids: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/msg/messageReceiver/v1/mark?ids=${ids}`)
            .then((res) => {
                resolve(res.data || {})
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}

// 消息详情
export function detailData(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/msg/messageReceiver/v1/get?id=${id}`)
            .then((res) => {
                resolve(res || {})
            })
            .catch((err: unknown) => {
                reject(err)
            })
    })
}
