/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.manager.impl;

import com.artfess.base.enums.ScoreLevelEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.examine.dao.ExamOrgEvaluationDao;
import com.artfess.examine.manager.ExamOrgEvaluationManager;
import com.artfess.examine.model.ExamOrgEvaluation;
import com.artfess.examine.vo.OrgVo;
import com.artfess.examine.vo.UserEvaluationVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.api.client.util.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ExamOrgEvaluationManagerImpl
extends BaseManagerImpl<ExamOrgEvaluationDao, ExamOrgEvaluation>
implements ExamOrgEvaluationManager {
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createOrgEvaluation() {
        List orgList = ((ExamOrgEvaluationDao)this.baseMapper).orgList();
        if (CollectionUtils.isEmpty(orgList)) {
            return;
        }
        orgList = BeanUtils.listToTree(orgList);
        Map<String, OrgVo> orgMap = orgList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        int year = LocalDate.now().getYear();
        List<UserEvaluationVo> userList = ((ExamOrgEvaluationDao)this.baseMapper).getOrgUserList(String.valueOf(year));
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ExamOrgEvaluation::getYear, (Object)String.valueOf(year));
        List list = this.list((Wrapper)queryWrapper);
        Map<String, ExamOrgEvaluation> OrgEvaluationMap = list.stream().collect(Collectors.toMap(item -> item.getOrgId(), item -> item));
        ArrayList orgEvaluations = Lists.newArrayList();
        Map<String, List<UserEvaluationVo>> orgUserListMap = userList.stream().collect(Collectors.groupingBy(user -> user.getOrgId()));
        orgMap.forEach((orgId, org) -> {
            List userEvaluationVos = (List)orgUserListMap.get(orgId);
            if (CollectionUtils.isEmpty((Collection)userEvaluationVos)) {
                return;
            }
            List chargeUser = userEvaluationVos.stream().filter(item -> "2".equals(item.getIsCharge())).collect(Collectors.toList());
            Integer chargeLevlel = null;
            if (!CollectionUtils.isEmpty(chargeUser)) {
                UserEvaluationVo userEvaluationVo = (UserEvaluationVo)chargeUser.get(0);
                chargeLevlel = userEvaluationVo.getLevel();
            }
            List<UserEvaluationVo> otherUser = userEvaluationVos.stream().filter(item -> !"2".equals(item.getIsCharge())).collect(Collectors.toList());
            Map<Integer, List<UserEvaluationVo>> levelUserMap = otherUser.stream().filter(item -> null != item.getLevel()).collect(Collectors.groupingBy(user -> user.getLevel()));
            if (CollectionUtils.isEmpty((Collection)org.getChildren())) {
                return;
            }
            ArrayList childrenUsers = Lists.newArrayList();
            org.getChildren().forEach(childrenOrg -> {
                OrgVo orgVo = (OrgVo)((Object)((Object)((Object)childrenOrg)));
                List childrenUserEvaluationVos = (List)orgUserListMap.get(orgVo.getId());
                if (CollectionUtils.isEmpty((Collection)childrenUserEvaluationVos)) {
                    return;
                }
                childrenUsers.addAll(childrenUserEvaluationVos);
            });
            Map<Integer, List<UserEvaluationVo>> childrenLevelUserMap = childrenUsers.stream().filter(item -> null != item.getLevel()).collect(Collectors.groupingBy(user -> user.getLevel()));
            ExamOrgEvaluation examOrgEvaluation = new ExamOrgEvaluation();
            if (null != OrgEvaluationMap.get(orgId)) {
                examOrgEvaluation = (ExamOrgEvaluation)((Object)((Object)OrgEvaluationMap.get(orgId)));
            }
            examOrgEvaluation.setYear(String.valueOf(year));
            examOrgEvaluation.setOrgId((String)orgId);
            examOrgEvaluation.setOrgName(org.getName());
            examOrgEvaluation.setEvaluationTime(LocalDateTime.now());
            examOrgEvaluation.setShouldCount(userEvaluationVos.size());
            long count = userEvaluationVos.stream().filter(item -> null == item.getLevel()).count();
            examOrgEvaluation.setActualCount(userEvaluationVos.size() - Integer.parseInt(String.valueOf(count)));
            Integer level = this.getOrgEvaluationLevel(chargeLevlel, examOrgEvaluation, otherUser, levelUserMap, childrenUsers, childrenLevelUserMap);
            examOrgEvaluation.setLevel(level);
            orgEvaluations.add(examOrgEvaluation);
        });
        this.saveOrUpdateBatch(orgEvaluations);
    }

    private Integer getOrgEvaluationLevel(Integer chargeLevlel, ExamOrgEvaluation examOrgEvaluation, List<UserEvaluationVo> otherUser, Map<Integer, List<UserEvaluationVo>> levelUserMap, List<UserEvaluationVo> childrenUsers, Map<Integer, List<UserEvaluationVo>> childrenLevelUserMap) {
        if (null == chargeLevlel) {
            return null;
        }
        Integer currentLhCount = 0;
        if (null != levelUserMap.get(ScoreLevelEnum.LH.getType())) {
            currentLhCount = levelUserMap.get(ScoreLevelEnum.LH.getType()).size();
        }
        Integer currentGoodCount = 0;
        if (null != levelUserMap.get(ScoreLevelEnum.GOOD.getType())) {
            currentGoodCount = levelUserMap.get(ScoreLevelEnum.GOOD.getType()).size();
        }
        Integer currentJgCount = 0;
        if (null != levelUserMap.get(ScoreLevelEnum.JG.getType())) {
            currentJgCount = levelUserMap.get(ScoreLevelEnum.JG.getType()).size();
        }
        Integer childrenLhCount = 0;
        if (null != childrenLevelUserMap.get(ScoreLevelEnum.LH.getType())) {
            childrenLhCount = childrenLevelUserMap.get(ScoreLevelEnum.LH.getType()).size();
        }
        Integer childrenGoodCount = 0;
        if (null != childrenLevelUserMap.get(ScoreLevelEnum.GOOD.getType())) {
            childrenGoodCount = childrenLevelUserMap.get(ScoreLevelEnum.GOOD.getType()).size();
        }
        Integer childrenJgCount = 0;
        if (null != childrenLevelUserMap.get(ScoreLevelEnum.JG.getType())) {
            childrenJgCount = childrenLevelUserMap.get(ScoreLevelEnum.JG.getType()).size();
        }
        Integer level = null;
        if (chargeLevlel.equals(ScoreLevelEnum.GOOD.getType()) && (currentLhCount + currentGoodCount == otherUser.size() && childrenLhCount + childrenGoodCount == childrenUsers.size() || currentGoodCount.intValue() == otherUser.size() && childrenLhCount + childrenGoodCount + childrenJgCount == childrenUsers.size())) {
            level = ScoreLevelEnum.GOOD.getType();
        }
        if (chargeLevlel <= ScoreLevelEnum.LH.getType()) {
            if (currentLhCount + currentGoodCount + currentJgCount == otherUser.size() || childrenLhCount + childrenGoodCount + childrenJgCount == childrenUsers.size()) {
                level = ScoreLevelEnum.JG.getType();
            }
            if (currentLhCount + currentGoodCount == otherUser.size() || childrenLhCount + childrenGoodCount + childrenJgCount == childrenUsers.size()) {
                level = ScoreLevelEnum.LH.getType();
            }
        }
        if (chargeLevlel <= ScoreLevelEnum.JG.getType() && currentLhCount + currentGoodCount + currentJgCount == otherUser.size() && childrenLhCount + childrenGoodCount + childrenJgCount == childrenUsers.size()) {
            level = ScoreLevelEnum.GOOD.getType();
        }
        if (null == level) {
            level = ScoreLevelEnum.BJG.getType();
        }
        Integer goodCount = currentGoodCount + childrenGoodCount;
        String excellentRate = new BigDecimal(goodCount).divide(new BigDecimal(examOrgEvaluation.getShouldCount()), 2, 4).multiply(new BigDecimal(100)) + "%";
        examOrgEvaluation.setExcellentRate(excellentRate);
        Integer jgCount = currentLhCount + currentGoodCount + currentJgCount + childrenLhCount + childrenGoodCount + childrenJgCount;
        String passRate = new BigDecimal(jgCount).divide(new BigDecimal(examOrgEvaluation.getShouldCount()), 2, 4).multiply(new BigDecimal(100)) + "%";
        examOrgEvaluation.setPassRate(passRate);
        return level;
    }
}

