package com.artfess.report.bigScreen.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.file.util.CheckFileFormatUtil;
import com.artfess.file.util.MinioUtil;
import com.artfess.report.bigScreen.dao.BladeVisualConfigDao;
import com.artfess.report.bigScreen.dao.BladeVisualDao;
import com.artfess.report.bigScreen.manager.BladeVisualManager;
import com.artfess.report.bigScreen.model.BladeVisual;
import com.artfess.report.bigScreen.model.BladeVisualConfig;
import com.artfess.report.bigScreen.vo.BladeVisualConfigVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.FileInputStream;
import java.util.List;

/**
 * 可视化表 服务实现类
 *
 * @author 向贞好
 * @company 阿特菲斯
 * @since 2021-07-12
 */
@Service
public class BladeVisualManagerImpl extends BaseManagerImpl<BladeVisualDao, BladeVisual> implements BladeVisualManager {
    @Autowired
    private BladeVisualConfigDao bladeVisualConfigDao;

    @Value(value = "${minio.minio_url}")
    private String minioUrl;

    @Override
    public PageList<BladeVisual> queryBladeVisual(QueryFilter<BladeVisual> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BladeVisual> result = baseMapper.queryPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        List<BladeVisual> records = result.getRecords();
        for (BladeVisual record : records) {
            if (StringUtils.isNotBlank(record.getBackgroundUrl()) && !record.getBackgroundUrl().startsWith("https") ) {
                record.setBackgroundUrl(minioUrl + record.getBackgroundUrl());
            }
        }
        return new PageList<BladeVisual>(result);
    }

    @Override
    public String uploadPhoto(MultipartFile positiveFile) throws Exception {
        String uriPhoto = "";
        if (positiveFile != null) {
            //String id = manageVehicleEntity.getId();
               /* if (StringUtils.isBlank(manageVehicleEntity.getId())) {
                    manageVehicleEntity.setId(Sid.nextShort());
                    id = Sid.nextShort();
                }*/
            //上传图片
            //验证图片类型
            String ext = CheckFileFormatUtil.getFileType((FileInputStream) positiveFile.getInputStream());
            if (ext == null) {
                throw new RuntimeException("不能识别的文件格式");
            }

            if ("bmp,jpg,png,tif,gif,svg,jpeg".indexOf(ext) == -1) {
                throw new RuntimeException("请上传图片格式文件");
            }
            String originalFilename = positiveFile.getOriginalFilename();
            String fileType = originalFilename.substring(originalFilename.lastIndexOf("."));
            uriPhoto = MinioUtil.uploadRelative(positiveFile, "", RandomStringUtils.randomAlphanumeric(100) + fileType, "big-screen");


        }
        return uriPhoto;

    }

    @Override
    public BladeVisualConfigVo getVisualConfig(String id) {
        BladeVisualConfigVo bladeVisualConfigVo = new BladeVisualConfigVo();
        BladeVisual bladeVisual = this.get(id);
        QueryWrapper<BladeVisualConfig> wrapper = new QueryWrapper<>();
        wrapper.eq(StringUtils.isNotBlank(id), "visual_id", id);
        BladeVisualConfig bladeVisualConfig = bladeVisualConfigDao.selectOne(wrapper);
        bladeVisualConfigVo.setConfig(bladeVisualConfig);
        bladeVisualConfigVo.setVisual(bladeVisual);
        return bladeVisualConfigVo;
    }

    @Override
    public String saveBladeVisualConfigVo(BladeVisualConfigVo bladeVisualConfigVo) {
        BladeVisual visual = bladeVisualConfigVo.getVisual();
        if (visual != null) {
            visual.setIsDele("0");
            this.save(visual);
            BladeVisualConfig config = bladeVisualConfigVo.getConfig();
            if (config != null) {
                config.setVisualId(visual.getId());
                this.bladeVisualConfigDao.insert(config);
            }
        }

        //assert visual != null;
        return visual.getId();
    }

    @Override
    public void updateBladeVisualConfigVo(BladeVisualConfigVo bladeVisualConfigVo) {
        if (bladeVisualConfigVo.getVisual() != null) {
            this.updateById(bladeVisualConfigVo.getVisual());
        }
        if (bladeVisualConfigVo.getConfig() != null) {
            this.bladeVisualConfigDao.updateById(bladeVisualConfigVo.getConfig());
        }
    }



}
