package com.artfess.job.job;

import com.artfess.base.constants.SystemConstants;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.WorkflowFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.job.model.BaseJob;
import com.artfess.uc.api.impl.util.ContextUtil;
import org.quartz.JobExecutionContext;


/**
 * 任务催办定时计划
 * @author liyg
 */
public class TaskReminderJob extends BaseJob{
	@Override
	public void executeJob(JobExecutionContext context) throws Exception {
		WorkflowFeignService bean = AppUtil.getBean(WorkflowFeignService.class);
		String defaultAccount = SystemConstants.SYSTEM_ACCOUNT;
		// 定时任务中没有当前登录用户，所以需要设置到当前用户上下文中
		ContextUtil.setCurrentUserByAccount(defaultAccount);
		CommonResult<String> executeTaskReminderJob = bean.executeTaskReminderJob();
		if(!executeTaskReminderJob.getState()){
			throw new BaseException(StringUtil.isNotEmpty(executeTaskReminderJob.getMessage())?executeTaskReminderJob.getMessage():"执行催办任务失败");
		}
	}
	
}
