package com.artfess.bo.model;

import org.springframework.util.Assert;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * BO和流程关系分组
 */
public class BoBpmShipGroup implements Serializable {
    private static final long serialVersionUID = -6784653712175927956L;
    private String flowKey;            /*流程定义key*/
    private String flowName;        /*流程名称*/
    private List<BoBpmShip> ships;    /*bo和流程的关系*/

    /**
     * 构造器
     *
     * @param flowKey
     * @param flowName
     * @return
     */
    public static BoBpmShipGroup build(String flowKey, String flowName) {
        BoBpmShipGroup boBpmShipGroup = new BoBpmShipGroup();
        boBpmShipGroup.setFlowKey(flowKey);
        boBpmShipGroup.setFlowName(flowName);
        boBpmShipGroup.setShips(new ArrayList<>());
        return boBpmShipGroup;
    }

    /**
     * 添加一个关系
     *
     * @return
     */
    public BoBpmShipGroup addShip(String flowId, String version, boolean isMain) {
        Assert.notNull(this.ships, "ships属性不能为空");
        // 该flowId不存在时才添加
        if (!this.ships.stream().anyMatch(e -> e.getFlowId().equals(flowId))) {
            this.ships.add(new BoBpmShip(flowId, version, isMain));
        }
        return this;
    }

    public String getFlowKey() {
        return flowKey;
    }

    public void setFlowKey(String flowKey) {
        this.flowKey = flowKey;
    }

    public String getFlowName() {
        return flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public List<BoBpmShip> getShips() {
        return ships;
    }

    public void setShips(List<BoBpmShip> ships) {
        this.ships = ships;
    }

    class BoBpmShip implements Serializable {
        private static final long serialVersionUID = 4642319367954742750L;
        private String flowId;        /*流程定义ID*/
        private String version;        /*版本号*/
        private boolean isMain;        /*是否主版本*/

        public BoBpmShip(String flowId, String version, boolean isMain) {
            this.setFlowId(flowId);
            this.setVersion(version);
            this.setMain(isMain);
        }

        public String getFlowId() {
            return flowId;
        }

        public void setFlowId(String flowId) {
            this.flowId = flowId;
        }

        public String getVersion() {
            return version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public boolean isMain() {
            return isMain;
        }

        public void setMain(boolean isMain) {
            this.isMain = isMain;
        }
    }
}
