package com.artfess.examine.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 *
 *试卷题目配置表
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Data
@ApiModel(value="ExamPaperQuestionSetting对象", description="")
public class ExamPaperQuestionSetting extends BaseModel<ExamPaperQuestionSetting> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "试卷基础信息ID")
    @TableField("paper_base_id_")
    private String paperBaseId;

    @ApiModelProperty(value = "考试科目")
    @TableField("subject_id_")
    private String subjectId;

    @ApiModelProperty(value = "试题题型【字典】（1：单选，2：多选，3：判断，4：填空，5：简答，6：操作）")
    @TableField("question_type_")
    private String questionType;

    @ApiModelProperty(value = "出题数量")
    @TableField("numuber_")
    private Integer numuber;

    @ApiModelProperty(value = "总数量")
    @TableField("total_numuber_")
    private Integer totalNumuber;

    @ApiModelProperty(value = "题目分数")
    @TableField("score_")
    private BigDecimal score;

    @ApiModelProperty(value = "题目id")
    @TableField("question_id_")
    private String questionId;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;


    @ApiModelProperty(value = "题目信息")
    @TableField(exist = false)
    private ExamQuestionsInfo questionsInfo;


}
