package com.artfess.data.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 档案信息vo
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-04
 */
@Data
public class UserExamVo {

    private static final long serialVersionUID = 1L;

    private String id;

    @ApiModelProperty(value = "年份")
    private String year;

    @ApiModelProperty(value = "总分数")
    private String totalScore;

    @ApiModelProperty(value = "考核得分")
    private String score;

    @ApiModelProperty(value = "应考课目数")
    private Long shouldCount;

    @ApiModelProperty(value = "参与课目数")
    private Long actualCount;

    @ApiModelProperty(value = "优秀课目数")
    private Long excellentCount;

    @ApiModelProperty(value = "良好课目数")
    private Long goodCount;

    @ApiModelProperty(value = "及格课目数")
    private Long passCount;

    @ApiModelProperty(value = "不及格课目数")
    private Long noPassCount;

    @ApiModelProperty(value = "课目名称")
    private String subjectName;

    @ApiModelProperty(value = "课目ID")
    private String subjectId;

    @ApiModelProperty(value = "岗位id")
    private String positionId;

    @ApiModelProperty(value = "岗位名称")
    private String posName;

    @ApiModelProperty(value = "用户id")
    private String userId;

    @ApiModelProperty(value = "用户姓名")
    private String userName;

    @ApiModelProperty(value = "评定等级")
    private String level;

    @ApiModelProperty(value = "擅长课目1")
    private String subjectName1;

    @ApiModelProperty(value = "擅长课目2")
    private String subjectName2;

    @ApiModelProperty(value = "擅长课目3")
    private String subjectName3;

    @ApiModelProperty(value = "擅长课目4")
    private String subjectName4;

}
