/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.controller;

import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.CommonRedisKey;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.QuestionStateEnum;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.examine.manager.ExamUserRecordManager;
import com.artfess.examine.model.ExamPaperBase;
import com.artfess.examine.model.ExamUserRecord;
import com.artfess.examine.vo.ApplyPaperReqVo;
import com.artfess.examine.vo.ExamReqVo;
import com.artfess.examine.vo.MyExamInfoVo;
import com.artfess.examine.vo.SubmitAnswerReqVo;
import com.artfess.examine.vo.YearSubjectScoreVO;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import com.artfess.redis.util.RedisLockUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u8003\u8bd5\u7ba1\u7406-\u8003\u8bd5\u8bc4\u5377"})
@RequestMapping(value={"/exam/user/record"})
@ApiGroup(group={"group_biz"})
public class ExamUserRecordController
extends BaseController<ExamUserRecordManager, ExamUserRecord> {
    private static final Logger log = LoggerFactory.getLogger(ExamUserRecordController.class);
    @Autowired
    private RedisLockUtils redisLockUtils;
    @Autowired
    private ExamUserRecordManager userRecordManager;
    @Resource
    BaseContext baseContext;

    @PostMapping(value={"/myPaper"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6211\u7684\u8bd5\u5377")
    public PageList<ExamUserRecord> myPaper(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserRecord> queryFilter) {
        queryFilter.addFilter("user_id_", (Object)AuthenticationUtil.getCurrentUserId(), QueryOP.EQUAL);
        return ((ExamUserRecordManager)this.baseService).myPaper(queryFilter);
    }

    @ApiOperation(value="\u9605\u5377-\u4fdd\u5b58\u5206\u6570")
    @PostMapping(value={"/saveScore"})
    public CommonResult saveScore(@RequestBody SubmitAnswerReqVo reqVo) {
        log.info("\u4fdd\u5b58\u5f97\u5206\u300b\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqVo));
        ((ExamUserRecordManager)this.baseService).saveScore(reqVo);
        return new CommonResult();
    }

    @GetMapping(value={"/getTaskInfo/{id}"})
    @ApiOperation(value="\u6211\u7684\u8bd5\u5377\u5c01\u9762")
    public ExamPaperBase getTaskInfo(@ApiParam(name="id", value="\u8003\u8bd5\u8bb0\u5f55id") @PathVariable String id) {
        ExamPaperBase examPaperTask = this.userRecordManager.findByMyRecord(id);
        return examPaperTask;
    }

    @GetMapping(value={"/getUserRecord/{id}"})
    @ApiOperation(value="\u7b54\u5377\u8bb0\u5f55")
    public MyExamInfoVo getUserRecord(@ApiParam(name="id", value="\u8003\u8bd5\u8bb0\u5f55id") @PathVariable String id) {
        MyExamInfoVo myExamInfoVo = this.userRecordManager.getUserRecord(id);
        return myExamInfoVo;
    }

    @GetMapping(value={"/myPaperInfo/{id}"})
    @ApiOperation(value="\u6211\u7684\u7b54\u9898\u8bb0\u5f55\uff08\u5305\u62ec\u6210\u7ee9\u4fe1\u606f\uff09")
    public MyExamInfoVo myPaperInfo(@ApiParam(name="id", value="\u8003\u8bd5\u8bb0\u5f55id") @PathVariable String id) {
        MyExamInfoVo myExamInfoVo = this.userRecordManager.myPaperInfo(id);
        return myExamInfoVo;
    }

    @PostMapping(value={"/startExam"})
    @ApiOperation(value="\u5f00\u59cb\u8003\u8bd5-\u8fdb\u5165\u6211\u7684\u8bd5\u5377\u5f00\u59cb\u7b54\u9898")
    public MyExamInfoVo startExam(@RequestBody ExamReqVo reqVo) {
        String currentUserId = AuthenticationUtil.getCurrentUserId();
        reqVo.setUserId(currentUserId);
        log.info("\u5f00\u59cb\u8003\u8bd5\u300b\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqVo));
        MyExamInfoVo myExamInfoVo = this.userRecordManager.startExam(reqVo);
        log.info("\u5f00\u59cb\u8003\u8bd5\u300b\u54cd\u5e94\uff1a{}", (Object)JSON.toJSONString((Object)myExamInfoVo));
        return myExamInfoVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/submitAnswer"})
    @ApiOperation(value="\u63d0\u4ea4\u7b54\u5377")
    public CommonResult submitAnswer(@RequestBody SubmitAnswerReqVo vo) {
        Assert.hasText((String)vo.getRecordId(), (String)"\u8003\u8bd5\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("\u63d0\u4ea4\u7b54\u5377\u300b\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)vo));
        CommonRedisKey commonLockType = CommonRedisKey.SUBMIT_ANSWER_KEY;
        boolean lock = this.redisLockUtils.tryLock(commonLockType.name() + ":" + vo.getRecordId(), 10L, TimeUnit.SECONDS);
        if (!lock) {
            throw new RuntimeException("\u7cfb\u7edf\u7e41\u5fd9");
        }
        try {
            String currentUserId = AuthenticationUtil.getCurrentUserId();
            vo.setUserId(currentUserId);
            this.userRecordManager.submitAnswer(vo);
            CommonResult commonResult = new CommonResult();
            return commonResult;
        }
        catch (BaseException e) {
            log.error("\u63d0\u4ea4\u7b54\u5377:{}", (Object)e.getMessage());
            CommonResult commonResult = new CommonResult();
            return commonResult;
        }
        finally {
            this.redisLockUtils.unLock(commonLockType.name() + ":" + vo.getRecordId());
        }
    }

    @GetMapping(value={"/switchCount/{id}"})
    @ApiOperation(value="\u589e\u52a0\u9875\u9762\u5207\u6362\u6b21\u6570")
    public CommonResult switchCount(@ApiParam(name="id", value="\u8003\u8bd5\u8bb0\u5f55id") @PathVariable String id) {
        this.userRecordManager.switchCount(id);
        return new CommonResult();
    }

    @GetMapping(value={"/updateStatus/{id}"})
    @ApiOperation(value="\u8bbe\u4e3a\u4f5c\u5f0a")
    public CommonResult updateStatus(@ApiParam(name="id", value="\u8003\u8bd5\u8bb0\u5f55id") @PathVariable String id) {
        this.userRecordManager.updateStatus(id);
        return new CommonResult();
    }

    @GetMapping(value={"/applyExamPaper/{id}"})
    @ApiOperation(value="\u7533\u8bf7\u8865\u8003\uff08\u8bd5\u5377\u5df2\u7ed3\u675f \u663e\u793a\u8be5\u6309\u94ae\uff09")
    public CommonResult applyExamPaper(@ApiParam(name="id", value="\u8003\u8bd5\u8bb0\u5f55id") @PathVariable String id) {
        this.userRecordManager.applyExamPaper(id);
        return new CommonResult();
    }

    @PostMapping(value={"/applyPaperRecord"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8865\u8003\u7533\u8bf7")
    public PageList<ExamUserRecord> applyPaperRecord(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserRecord> queryFilter) {
        queryFilter.addFilter("s.status_", (Object)"6", QueryOP.EQUAL);
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("s.apply_time_", Direction.DESC));
        queryFilter.setSorter(sorter);
        List currentAndChildOrgIds = this.baseContext.getCurrentAndChildOrgIds();
        queryFilter.addFilter("b.create_org_id_", (Object)currentAndChildOrgIds, QueryOP.IN);
        return ((ExamUserRecordManager)this.baseService).myPaper(queryFilter);
    }

    @PostMapping(value={"/modifyStatus"})
    @ApiOperation(value="\u8865\u8003\u7533\u8bf7\u5ba1\u6279")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.UPDATE, description="\u8865\u8003\u7533\u8bf7\u5ba1\u6279")
    public CommonResult<String> modifyEnabled(@ApiParam(name="model", value="\u516c\u544a") @RequestBody ApplyPaperReqVo reqVo) {
        log.info("\u8865\u8003\u7533\u8bf7\u5ba1\u6279\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)reqVo));
        boolean b = ((ExamUserRecordManager)this.baseService).modifyStatus(reqVo);
        log.info("\u8865\u8003\u7533\u8bf7\u5ba1\u6279\u54cd\u5e94\u7ed3\u679c:{}", (Object)b);
        if (!b) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"/paperQuery"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8003\u8bd5\u67e5\u8be2")
    public PageList<ExamUserRecord> paperQuery(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserRecord> queryFilter) {
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("s.status_", Direction.DESC));
        queryFilter.setSorter(sorter);
        List currentAndChildOrgIds = this.baseContext.getCurrentAndChildOrgIds();
        queryFilter.addFilter("b.create_org_id_", (Object)currentAndChildOrgIds, QueryOP.IN);
        return ((ExamUserRecordManager)this.baseService).myPaper(queryFilter);
    }

    @PostMapping(value={"/paperEvaluationQuery"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8003\u8bd5\u8bc4\u5377")
    public PageList<ExamUserRecord> paperEvaluationQuery(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserRecord> queryFilter) {
        queryFilter.addFilter("s.status_", (Object)"3", QueryOP.EQUAL);
        List currentAndChildOrgIds = this.baseContext.getCurrentAndChildOrgIds();
        queryFilter.addFilter("b.create_org_id_", (Object)currentAndChildOrgIds, QueryOP.IN);
        return ((ExamUserRecordManager)this.baseService).myPaper(queryFilter);
    }

    @PostMapping(value={"/myResultsQuery"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6211\u7684\u6210\u7ee9")
    public PageList<ExamUserRecord> myResultsQuery(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserRecord> queryFilter) {
        queryFilter.addFilter("user_id_", (Object)AuthenticationUtil.getCurrentUserId(), QueryOP.EQUAL);
        queryFilter.addFilter("s.status_", (Object)QuestionStateEnum.finish.getType(), QueryOP.EQUAL);
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("s.end_time_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return ((ExamUserRecordManager)this.baseService).myPaper(queryFilter);
    }

    @PostMapping(value={"/resultsQuery"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6210\u7ee9\u67e5\u8be2")
    public PageList<ExamUserRecord> resultsQuery(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserRecord> queryFilter) {
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("s.end_time_", Direction.DESC));
        queryFilter.setSorter(sorter);
        List currentAndChildOrgIds = this.baseContext.getCurrentAndChildOrgIds();
        queryFilter.addFilter("b.create_org_id_", (Object)currentAndChildOrgIds, QueryOP.IN);
        return ((ExamUserRecordManager)this.baseService).myPaper(queryFilter);
    }

    @ApiOperation(value="\u6210\u7ee9\u5bfc\u5165")
    @PostMapping(value={"/importExcel"})
    public CommonResult<String> importExcel(@RequestParam(value="file") MultipartFile file) {
        try {
            return new CommonResult();
        }
        catch (Exception e) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
    }

    @ApiOperation(value="\u6210\u7ee9\u5bfc\u51fa")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserRecord> queryFilter) throws Exception {
        queryFilter.addFilter("s.status_", (Object)QuestionStateEnum.finish.getType(), QueryOP.EQUAL);
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("s.end_time_", Direction.DESC));
        queryFilter.setSorter(sorter);
        PageList<ExamUserRecord> page = ((ExamUserRecordManager)this.baseService).myPaper(queryFilter);
        ExcelUtils util = new ExcelUtils(ExamUserRecord.class);
        util.exportExcel(response, request, page.getRows(), "\u6210\u7ee9\u4fe1\u606f");
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    @GetMapping(value={"/downModel"})
    public void downTemplate(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/\u5bfc\u5165\u6a21\u677f.xlsx");
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u5bfc\u5165\u6a21\u677f.xlsx");
        }
        catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException("\u4f60\u6240\u4e0b\u8f7d\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5e74\u5ea6\u79d1\u76ee\u6210\u7ee9")
    @GetMapping(value={"/getSubjectScore/{userId}/{year}"})
    public CommonResult<List<YearSubjectScoreVO>> getYearSubjectScore(@ApiParam(name="userId", value="\u7528\u6237ID") @PathVariable String userId, @ApiParam(name="year", value="\u67e5\u8be2\u7684\u5e74\u4efd") @PathVariable Integer year) {
        List<YearSubjectScoreVO> list = ((ExamUserRecordManager)this.baseService).getYearSubjectScore(userId, year);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", list);
    }
}

