/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.manager.impl;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.WordUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.data.dao.BizUserAchieveDetailDao;
import com.artfess.data.dao.BizUserAchieveStaticDao;
import com.artfess.data.dao.BizUserBasicDao;
import com.artfess.data.dao.BizUserGradeDao;
import com.artfess.data.dao.BizUserGradeStaticDao;
import com.artfess.data.dao.BizUserThroughDetailDao;
import com.artfess.data.dao.BizUserThroughStaticDao;
import com.artfess.data.dao.BizUserWorkDetailDao;
import com.artfess.data.dto.EditPersonalProfileDto;
import com.artfess.data.dto.PersonalProfileDto;
import com.artfess.data.manager.BizSubjectScoreCountManager;
import com.artfess.data.manager.BizUserAchieveStaticManager;
import com.artfess.data.manager.BizUserBasicManager;
import com.artfess.data.manager.BizUserGradeStaticManager;
import com.artfess.data.manager.BizUserThroughStaticManager;
import com.artfess.data.model.BizSubjectScoreCount;
import com.artfess.data.model.BizUserAchieveDetail;
import com.artfess.data.model.BizUserAchieveStatic;
import com.artfess.data.model.BizUserBasic;
import com.artfess.data.model.BizUserGrade;
import com.artfess.data.model.BizUserGradeStatic;
import com.artfess.data.model.BizUserThroughDetail;
import com.artfess.data.model.BizUserThroughStatic;
import com.artfess.data.model.BizUserWorkDetail;
import com.artfess.data.vo.ExamUserEvaluationVo;
import com.artfess.data.vo.PersonalProfileVo;
import com.artfess.examine.dao.ExamUserEvaluationDao;
import com.artfess.examine.dao.ExamUserEvaluationDetailDao;
import com.artfess.examine.dao.ExamUserEvaluationDetailTyDao;
import com.artfess.examine.model.ExamUserEvaluation;
import com.artfess.examine.model.ExamUserEvaluationDetailTy;
import com.artfess.file.util.CheckFileFormatUtil;
import com.artfess.file.util.MinioUtil;
import com.artfess.poi.util.FileDownloadUtil;
import com.artfess.uc.api.impl.service.UserServiceImpl;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.api.client.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizUserBasicManagerImpl
extends BaseManagerImpl<BizUserBasicDao, BizUserBasic>
implements BizUserBasicManager {
    private final BizUserBasicDao bizUserBasicDao;
    private final BizUserAchieveDetailDao bizUserAchieveDetailDao;
    private final BizUserAchieveStaticDao bizUserAchieveStaticDao;
    private final BizUserGradeDao bizUserGradeDao;
    private final BizUserGradeStaticDao bizUserGradeStaticDao;
    private final BizUserThroughStaticDao bizUserThroughStaticDao;
    private final BizUserThroughDetailDao bizUserThroughDetailDao;
    private final BizUserWorkDetailDao bizUserWorkDetailDao;
    private final UserServiceImpl userServiceImpl;
    private final ExamUserEvaluationDao examUserEvaluationDao;
    private final ExamUserEvaluationDetailDao examUserEvaluationDetailDao;
    private final ExamUserEvaluationDetailTyDao examUserEvaluationDetailTyDao;
    private final BizUserThroughStaticManager bizUserThroughStaticManager;
    private final BizUserGradeStaticManager bizUserGradeStaticManager;
    private final BizUserAchieveStaticManager bizUserAchieveStaticManager;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    private BizSubjectScoreCountManager subjectScoreCountManager;

    public BizUserBasicManagerImpl(BizUserBasicDao bizUserBasicDao, BizUserAchieveDetailDao bizUserAchieveDetailDao, BizUserAchieveStaticDao bizUserAchieveStaticDao, BizUserGradeDao bizUserGradeDao, BizUserGradeStaticDao bizUserGradeStaticDao, BizUserThroughStaticDao bizUserThroughStaticDao, BizUserThroughDetailDao bizUserThroughDetailDao, BizUserWorkDetailDao bizUserWorkDetailDao, UserServiceImpl userServiceImpl, ExamUserEvaluationDao examUserEvaluationDao, ExamUserEvaluationDetailDao examUserEvaluationDetailDao, ExamUserEvaluationDetailTyDao examUserEvaluationDetailTyDao, BizUserThroughStaticManager bizUserThroughStaticManager, BizUserGradeStaticManager bizUserGradeStaticManager, BizUserAchieveStaticManager bizUserAchieveStaticManager) {
        this.bizUserBasicDao = bizUserBasicDao;
        this.bizUserAchieveDetailDao = bizUserAchieveDetailDao;
        this.bizUserAchieveStaticDao = bizUserAchieveStaticDao;
        this.bizUserGradeDao = bizUserGradeDao;
        this.bizUserGradeStaticDao = bizUserGradeStaticDao;
        this.bizUserThroughStaticDao = bizUserThroughStaticDao;
        this.bizUserThroughDetailDao = bizUserThroughDetailDao;
        this.bizUserWorkDetailDao = bizUserWorkDetailDao;
        this.userServiceImpl = userServiceImpl;
        this.examUserEvaluationDao = examUserEvaluationDao;
        this.examUserEvaluationDetailDao = examUserEvaluationDetailDao;
        this.examUserEvaluationDetailTyDao = examUserEvaluationDetailTyDao;
        this.bizUserThroughStaticManager = bizUserThroughStaticManager;
        this.bizUserGradeStaticManager = bizUserGradeStaticManager;
        this.bizUserAchieveStaticManager = bizUserAchieveStaticManager;
    }

    @Override
    public PersonalProfileVo getPersonalProfile() {
        String userId = ContextUtil.getCurrentUserId();
        PersonalProfileVo personalProfileVo = new PersonalProfileVo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id_", (Object)userId);
        BizUserBasic bizUserBasic = (BizUserBasic)((Object)this.bizUserBasicDao.selectOne((Wrapper)queryWrapper));
        personalProfileVo.setBizUserBasic(bizUserBasic);
        if (bizUserBasic != null) {
            BizUserAchieveStatic bizUserAchieveStatic = (BizUserAchieveStatic)((Object)this.bizUserAchieveStaticDao.selectOne((Wrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)bizUserBasic.getId())));
            personalProfileVo.setBizUserAchieveStatic(bizUserAchieveStatic);
            BizUserGradeStatic bizUserGradeStatic = (BizUserGradeStatic)((Object)this.bizUserGradeStaticDao.selectOne((Wrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)bizUserBasic.getId())));
            personalProfileVo.setBizUserGradeStatic(bizUserGradeStatic);
            List bizUserThroughStaticList = this.bizUserThroughStaticDao.selectList((Wrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)bizUserBasic.getId()));
            personalProfileVo.setBizUserThroughStaticList(bizUserThroughStaticList);
            List bizUserWorkDetailList = this.bizUserWorkDetailDao.selectList((Wrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)bizUserBasic.getId()));
            personalProfileVo.setBizUserWorkDetailList(bizUserWorkDetailList);
            ArrayList<ExamUserEvaluationVo> examUserEvaluationVoList = new ArrayList<ExamUserEvaluationVo>();
            QueryWrapper examUserEvaluationVoQueryWrapper = new QueryWrapper();
            examUserEvaluationVoQueryWrapper.eq((Object)"user_id_", (Object)userId);
            List examUserEvaluations = this.examUserEvaluationDao.selectList((Wrapper)examUserEvaluationVoQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)examUserEvaluations)) {
                for (ExamUserEvaluation examUserEvaluation : examUserEvaluations) {
                    ExamUserEvaluationVo examUserEvaluationVo = new ExamUserEvaluationVo();
                    examUserEvaluationVo.setYear(examUserEvaluation.getYear());
                    examUserEvaluationVo.setExamUserEvaluation(examUserEvaluation);
                    List examUserEvaluationDetailTyList = this.examUserEvaluationDetailTyDao.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id_", (Object)userId)).eq((Object)"year_", (Object)examUserEvaluation.getYear()));
                    examUserEvaluationVo.setProfessionalCommonDetail(examUserEvaluationDetailTyList.stream().filter(e -> e.getType() == 1).collect(Collectors.toList()));
                    examUserEvaluationVo.setProfessionalXXDetail(examUserEvaluationDetailTyList.stream().filter(e -> e.getType() == 2).collect(Collectors.toList()));
                    examUserEvaluationVo.setXXCommonDetail(examUserEvaluationDetailTyList.stream().filter(e -> e.getType() == 3).collect(Collectors.toList()));
                    examUserEvaluationVo.setXXSportsDetail(examUserEvaluationDetailTyList.stream().filter(e -> e.getType() == 4).collect(Collectors.toList()));
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(BizSubjectScoreCount::getUserArchiveId, (Object)bizUserBasic.getId());
                    wrapper.eq(BizSubjectScoreCount::getYear, (Object)Integer.parseInt(examUserEvaluation.getYear()));
                    wrapper.orderByAsc(BizSubjectScoreCount::getSn);
                    examUserEvaluationVo.setSubjectScoreCounts(this.subjectScoreCountManager.list((Wrapper)wrapper));
                    List bizUserAchieveDetailList = this.bizUserAchieveDetailDao.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)bizUserBasic.getId())).eq((Object)"td_year_", (Object)Integer.parseInt(examUserEvaluation.getYear())));
                    examUserEvaluationVo.setBizUserAchieveDetailList(bizUserAchieveDetailList);
                    List bizUserGradeList = this.bizUserGradeDao.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)bizUserBasic.getId())).eq((Object)"td_year_", (Object)Integer.parseInt(examUserEvaluation.getYear())));
                    examUserEvaluationVo.setBizUserGradeList(bizUserGradeList);
                    List bizUserThroughDetailList = this.bizUserThroughDetailDao.selectList((Wrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)bizUserBasic.getId()));
                    examUserEvaluationVo.setBizUserThroughDetailList(bizUserThroughDetailList);
                    examUserEvaluationVoList.add(examUserEvaluationVo);
                }
            }
            personalProfileVo.setExamUserEvaluationVoList(examUserEvaluationVoList);
        }
        return personalProfileVo;
    }

    @Override
    public PersonalProfileVo getPersonalProfile(String year, String userId) {
        PersonalProfileVo personalProfileVo = new PersonalProfileVo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id_", (Object)userId);
        BizUserBasic bizUserBasic = (BizUserBasic)((Object)this.bizUserBasicDao.selectOne((Wrapper)queryWrapper));
        personalProfileVo.setBizUserBasic(bizUserBasic);
        if (bizUserBasic != null) {
            BizUserAchieveStatic bizUserAchieveStatic = (BizUserAchieveStatic)((Object)this.bizUserAchieveStaticDao.selectOne((Wrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)bizUserBasic.getId())));
            personalProfileVo.setBizUserAchieveStatic(bizUserAchieveStatic);
            BizUserGradeStatic bizUserGradeStatic = (BizUserGradeStatic)((Object)this.bizUserGradeStaticDao.selectOne((Wrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)bizUserBasic.getId())));
            personalProfileVo.setBizUserGradeStatic(bizUserGradeStatic);
            List bizUserThroughStaticList = this.bizUserThroughStaticDao.selectList((Wrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)bizUserBasic.getId()));
            personalProfileVo.setBizUserThroughStaticList(bizUserThroughStaticList);
            List bizUserWorkDetailList = this.bizUserWorkDetailDao.selectList((Wrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)bizUserBasic.getId()));
            personalProfileVo.setBizUserWorkDetailList(bizUserWorkDetailList);
            ArrayList<ExamUserEvaluationVo> examUserEvaluationVoList = new ArrayList<ExamUserEvaluationVo>();
            QueryWrapper examUserEvaluationVoQueryWrapper = new QueryWrapper();
            examUserEvaluationVoQueryWrapper.eq((Object)"user_id_", (Object)userId);
            examUserEvaluationVoQueryWrapper.eq((Object)"year_", (Object)year);
            ExamUserEvaluation examUserEvaluation = (ExamUserEvaluation)((Object)this.examUserEvaluationDao.selectOne((Wrapper)examUserEvaluationVoQueryWrapper));
            if (!Objects.isNull((Object)examUserEvaluation)) {
                ExamUserEvaluationVo examUserEvaluationVo = new ExamUserEvaluationVo();
                examUserEvaluationVo.setYear(examUserEvaluation.getYear());
                examUserEvaluationVo.setExamUserEvaluation(examUserEvaluation);
                List examUserEvaluationDetailTyList = this.examUserEvaluationDetailTyDao.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id_", (Object)userId)).eq((Object)"year_", (Object)examUserEvaluation.getYear()));
                examUserEvaluationVo.setProfessionalCommonDetail(examUserEvaluationDetailTyList.stream().filter(e -> e.getType() == 1).collect(Collectors.toList()));
                examUserEvaluationVo.setProfessionalXXDetail(examUserEvaluationDetailTyList.stream().filter(e -> e.getType() == 2).collect(Collectors.toList()));
                examUserEvaluationVo.setXXCommonDetail(examUserEvaluationDetailTyList.stream().filter(e -> e.getType() == 3).collect(Collectors.toList()));
                examUserEvaluationVo.setXXSportsDetail(examUserEvaluationDetailTyList.stream().filter(e -> e.getType() == 4).collect(Collectors.toList()));
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(BizSubjectScoreCount::getUserArchiveId, (Object)bizUserBasic.getId());
                wrapper.eq(BizSubjectScoreCount::getYear, (Object)Integer.parseInt(year));
                wrapper.orderByAsc(BizSubjectScoreCount::getSn);
                examUserEvaluationVo.setSubjectScoreCounts(this.subjectScoreCountManager.list((Wrapper)wrapper));
                List bizUserAchieveDetailList = this.bizUserAchieveDetailDao.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)bizUserBasic.getId())).eq((Object)"td_year_", (Object)Integer.parseInt(examUserEvaluation.getYear())));
                examUserEvaluationVo.setBizUserAchieveDetailList(bizUserAchieveDetailList);
                List bizUserGradeList = this.bizUserGradeDao.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)bizUserBasic.getId())).eq((Object)"td_year_", (Object)Integer.parseInt(examUserEvaluation.getYear())));
                examUserEvaluationVo.setBizUserGradeList(bizUserGradeList);
                List bizUserThroughDetailList = this.bizUserThroughDetailDao.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)bizUserBasic.getId())).eq((Object)"td_year_", (Object)Integer.parseInt(examUserEvaluation.getYear())));
                examUserEvaluationVo.setBizUserThroughDetailList(bizUserThroughDetailList);
                examUserEvaluationVoList.add(examUserEvaluationVo);
            }
            personalProfileVo.setExamUserEvaluationVoList(examUserEvaluationVoList);
        }
        return personalProfileVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editPersonalProfile(EditPersonalProfileDto editPersonalProfileDto) {
        List<BizUserWorkDetail> bizUserWorkDetailList;
        List<BizUserAchieveDetail> bizUserAchieveDetailList;
        List<BizUserThroughDetail> bizUserThroughDetailList;
        String userId = editPersonalProfileDto.getUserId();
        Integer year = editPersonalProfileDto.getPersonalProfileDto().getYear();
        BizUserBasic oldBasic = (BizUserBasic)((Object)this.bizUserBasicDao.selectOne((Wrapper)new QueryWrapper().eq((Object)"user_id_", (Object)userId)));
        if (oldBasic != null) {
            this.bizUserBasicDao.delete((Wrapper)new QueryWrapper().eq((Object)"user_id_", (Object)userId));
            this.bizUserAchieveDetailDao.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)oldBasic.getId())).eq((Object)"td_year_", (Object)year));
            this.bizUserGradeDao.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)oldBasic.getId())).eq((Object)"td_year_", (Object)year));
            this.bizUserThroughDetailDao.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)oldBasic.getId())).eq((Object)"td_year_", (Object)year));
            this.bizUserWorkDetailDao.delete((Wrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)oldBasic.getId()));
            this.examUserEvaluationDetailDao.delete((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id_", (Object)userId)).eq((Object)"year_", (Object)year.toString())).eq((Object)"category_", (Object)"3")).eq((Object)"category_", (Object)"4"));
            this.examUserEvaluationDetailTyDao.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id_", (Object)userId)).eq((Object)"year_", (Object)year.toString()));
            this.examUserEvaluationDao.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id_", (Object)userId)).eq((Object)"year_", (Object)year.toString()));
            this.subjectScoreCountManager.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSubjectScoreCount::getUserArchiveId, (Object)oldBasic.getId())).eq(BizSubjectScoreCount::getYear, (Object)year));
        }
        BizUserBasic basic = new BizUserBasic();
        if (oldBasic != null) {
            basic.setId(oldBasic.getId());
        }
        basic.setUserId(editPersonalProfileDto.getUserId());
        IUser userById = this.userServiceImpl.getUserById(editPersonalProfileDto.getUserId());
        CommonResult objectNode = this.ucFeignService.getUserById(userId);
        if (BeanUtils.isNotEmpty((Object)objectNode)) {
            String idCard = ((JsonNode)objectNode.getValue()).get("idCard").asText();
            basic.setIdentCard(idCard);
        }
        basic.setLoginName(userById.getAccount());
        basic.setUserArchive(userById.getFullname() + " + " + editPersonalProfileDto.getIdentCard());
        basic.setUserName(userById.getFullname());
        basic.setArchiveUnitName(editPersonalProfileDto.getArchiveUnitName());
        basic.setArchiveYear(editPersonalProfileDto.getArchiveYear());
        basic.setSex(editPersonalProfileDto.getSex());
        basic.setIdentCard(editPersonalProfileDto.getIdentCard());
        basic.setPhoneNum(editPersonalProfileDto.getPhoneNum());
        basic.setBirthDate(editPersonalProfileDto.getBirthDate());
        basic.setRwDate(editPersonalProfileDto.getRwDate());
        basic.setXjxDate(editPersonalProfileDto.getXjxDate());
        basic.setJobDescription(editPersonalProfileDto.getJobDescription());
        basic.setRdDate(editPersonalProfileDto.getRdDate());
        basic.setNation(editPersonalProfileDto.getNation());
        basic.setNativePlace(editPersonalProfileDto.getNativePlace());
        basic.setPoliticalOutlook(editPersonalProfileDto.getPoliticalOutlook());
        basic.setBloodType(editPersonalProfileDto.getBloodType());
        basic.setRwAddress(editPersonalProfileDto.getRwAddress());
        basic.setRegisteredResidence(editPersonalProfileDto.getRegisteredResidence());
        basic.setHighEducation(editPersonalProfileDto.getHighEducation());
        basic.setUserClass(editPersonalProfileDto.getUserClass());
        basic.setUserPhotoUrl(editPersonalProfileDto.getUserPhotoUrl());
        this.bizUserBasicDao.insert((Object)basic);
        PersonalProfileDto personalProfileDto = editPersonalProfileDto.getPersonalProfileDto();
        if (Objects.isNull(personalProfileDto)) {
            throw new RuntimeException("\u4e2a\u4eba\u6863\u6848\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ExamUserEvaluation examUserEvaluation = personalProfileDto.getExamUserEvaluation();
        examUserEvaluation.setUserId(userId);
        examUserEvaluation.setUserName(userById.getFullname());
        examUserEvaluation.setYear(year.toString());
        this.examUserEvaluationDao.insert((Object)examUserEvaluation);
        ArrayList examUserEvaluationDetailTyList = new ArrayList();
        personalProfileDto.getProfessionalCommonDetail().forEach(professionalCommonDetail -> {
            professionalCommonDetail.setType(1);
            examUserEvaluationDetailTyList.add(professionalCommonDetail);
        });
        personalProfileDto.getProfessionalXXDetail().forEach(professionalCommonDetail -> {
            professionalCommonDetail.setType(2);
            examUserEvaluationDetailTyList.add(professionalCommonDetail);
        });
        personalProfileDto.getXXCommonDetail().forEach(professionalCommonDetail -> {
            professionalCommonDetail.setType(3);
            examUserEvaluationDetailTyList.add(professionalCommonDetail);
        });
        personalProfileDto.getXXSportsDetail().forEach(professionalCommonDetail -> {
            professionalCommonDetail.setType(4);
            examUserEvaluationDetailTyList.add(professionalCommonDetail);
        });
        for (ExamUserEvaluationDetailTy examUserEvaluationDetailTy : examUserEvaluationDetailTyList) {
            examUserEvaluationDetailTy.setYear(year.toString());
            examUserEvaluationDetailTy.setPositionId(examUserEvaluation.getPositionId());
            examUserEvaluationDetailTy.setUserId(userId);
            examUserEvaluationDetailTy.setUserName(userById.getFullname());
            this.examUserEvaluationDetailTyDao.insert((Object)examUserEvaluationDetailTy);
        }
        List<BizSubjectScoreCount> subjectScoreCounts = personalProfileDto.getSubjectScoreCounts();
        subjectScoreCounts.forEach(subjectScoreCount -> {
            subjectScoreCount.setUserArchiveId(basic.getId());
            subjectScoreCount.setYear(year);
        });
        this.subjectScoreCountManager.saveBatch(subjectScoreCounts);
        List<BizUserGrade> bizUserGradeList = personalProfileDto.getBizUserGradeList();
        if (CollectionUtils.isNotEmpty(bizUserGradeList)) {
            for (BizUserGrade bizUserGrade : bizUserGradeList) {
                bizUserGrade.setId(null);
                bizUserGrade.setUserArchiveId(basic.getId());
                bizUserGrade.setUserName(basic.getUserName());
                bizUserGrade.setIdentiCard(basic.getIdentCard());
                bizUserGrade.setTdYear(personalProfileDto.getYear());
                this.bizUserGradeDao.insert((Object)bizUserGrade);
            }
            BizUserGradeStatic bizUserGradeStatic = (BizUserGradeStatic)((Object)this.bizUserGradeStaticDao.selectOne((Wrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)basic.getId())));
            if (Objects.isNull((Object)bizUserGradeStatic)) {
                bizUserGradeStatic = new BizUserGradeStatic();
            }
            bizUserGradeStatic.setUserArchiveId(basic.getId());
            bizUserGradeStatic.setUserName(basic.getUserName());
            bizUserGradeStatic.setIdentiCard(basic.getIdentCard());
            bizUserGradeStatic.setYear(personalProfileDto.getYear());
            List bizUserGrades = this.bizUserGradeDao.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)basic.getId())).ne((Object)"td_year_", (Object)year));
            bizUserGrades.addAll(bizUserGradeList);
            bizUserGradeStatic.setGradeContent(bizUserGrades.stream().map(BizUserGrade::getGradeContent).collect(Collectors.joining(System.lineSeparator())));
            String rewardsContent = bizUserGrades.stream().map(BizUserGrade::getRewardsContent).collect(Collectors.joining(System.lineSeparator()));
            bizUserGradeStatic.setRewardsContent(rewardsContent);
            this.bizUserGradeStaticManager.saveOrUpdate((Object)bizUserGradeStatic);
        }
        if (CollectionUtils.isNotEmpty(bizUserThroughDetailList = personalProfileDto.getBizUserThroughDetailList())) {
            for (BizUserThroughDetail bizUserThroughDetail2 : bizUserThroughDetailList) {
                bizUserThroughDetail2.setId(null);
                bizUserThroughDetail2.setUserArchiveId(basic.getId());
                bizUserThroughDetail2.setUserName(basic.getUserName());
                bizUserThroughDetail2.setIdentiCard(basic.getIdentCard());
                bizUserThroughDetail2.setTdYear(personalProfileDto.getYear());
                this.bizUserThroughDetailDao.insert((Object)bizUserThroughDetail2);
            }
            BizUserThroughStatic bizUserThroughStatic1 = (BizUserThroughStatic)((Object)this.bizUserThroughStaticDao.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)basic.getId())).eq((Object)"type_", (Object)"1")));
            if (Objects.isNull((Object)bizUserThroughStatic1)) {
                bizUserThroughStatic1 = new BizUserThroughStatic();
            }
            bizUserThroughStatic1.setUserArchiveId(basic.getId());
            bizUserThroughStatic1.setUserName(basic.getUserName());
            bizUserThroughStatic1.setIdentiCard(basic.getIdentCard());
            List bizUserThroughDetails = this.bizUserThroughDetailDao.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)basic.getId())).ne((Object)"td_year_", (Object)year));
            bizUserThroughDetails.addAll(bizUserThroughDetailList);
            List bizUserThroughDetailList1 = bizUserThroughDetails.stream().filter(bizUserThroughDetail -> "1".equals(bizUserThroughDetail.getType())).collect(Collectors.toList());
            bizUserThroughStatic1.setType("1");
            String field1 = bizUserThroughDetailList1.stream().sorted(Comparator.comparing(BizUserThroughDetail::getTdYear)).map(BizUserThroughDetail::getField1).collect(Collectors.joining(System.lineSeparator()));
            bizUserThroughStatic1.setField1(field1);
            String field2 = bizUserThroughDetailList1.stream().sorted(Comparator.comparing(BizUserThroughDetail::getTdYear)).map(BizUserThroughDetail::getField2).collect(Collectors.joining(System.lineSeparator()));
            bizUserThroughStatic1.setField2(field2);
            String field3 = bizUserThroughDetailList1.stream().sorted(Comparator.comparing(BizUserThroughDetail::getTdYear)).map(BizUserThroughDetail::getField3).collect(Collectors.joining(System.lineSeparator()));
            bizUserThroughStatic1.setField3(field3);
            String field4 = bizUserThroughDetailList1.stream().sorted(Comparator.comparing(BizUserThroughDetail::getTdYear)).map(BizUserThroughDetail::getField4).collect(Collectors.joining(System.lineSeparator()));
            bizUserThroughStatic1.setField4(field4);
            this.bizUserThroughStaticManager.saveOrUpdate((Object)bizUserThroughStatic1);
            List bizUserThroughDetailList2 = bizUserThroughDetails.stream().filter(bizUserThroughDetail -> "2".equals(bizUserThroughDetail.getType())).collect(Collectors.toList());
            BizUserThroughStatic bizUserThroughStatic2 = (BizUserThroughStatic)((Object)this.bizUserThroughStaticDao.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_archive_id_", (Object)basic.getId())).eq((Object)"type_", (Object)"2")));
            if (Objects.isNull((Object)bizUserThroughStatic2)) {
                bizUserThroughStatic2 = new BizUserThroughStatic();
            }
            bizUserThroughStatic2.setUserArchiveId(basic.getId());
            bizUserThroughStatic2.setUserName(basic.getUserName());
            bizUserThroughStatic2.setIdentiCard(basic.getIdentCard());
            bizUserThroughStatic2.setType("2");
            field1 = bizUserThroughDetailList2.stream().sorted(Comparator.comparing(BizUserThroughDetail::getTdYear)).map(BizUserThroughDetail::getField1).collect(Collectors.joining(System.lineSeparator()));
            bizUserThroughStatic2.setField1(field1);
            field2 = bizUserThroughDetailList2.stream().sorted(Comparator.comparing(BizUserThroughDetail::getTdYear)).map(BizUserThroughDetail::getField2).collect(Collectors.joining(System.lineSeparator()));
            bizUserThroughStatic2.setField2(field2);
            this.bizUserThroughStaticManager.saveOrUpdate((Object)bizUserThroughStatic2);
        }
        if (CollectionUtils.isNotEmpty(bizUserAchieveDetailList = personalProfileDto.getBizUserAchieveDetailList())) {
            for (BizUserAchieveDetail bizUserAchieveDetail : bizUserAchieveDetailList) {
                bizUserAchieveDetail.setUserArchiveId(basic.getId());
                bizUserAchieveDetail.setUserName(basic.getUserName());
                bizUserAchieveDetail.setIdentiCard(basic.getIdentCard());
                bizUserAchieveDetail.setTdYear(personalProfileDto.getYear());
                this.bizUserAchieveDetailDao.insert((Object)bizUserAchieveDetail);
            }
            List bizUserAchieveDetails = this.bizUserAchieveDetailDao.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizUserAchieveDetail::getUserArchiveId, (Object)basic.getId())).ne(BizUserAchieveDetail::getTdYear, (Object)year));
            bizUserAchieveDetails.addAll(bizUserAchieveDetailList);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BizUserAchieveStatic::getUserArchiveId, (Object)basic.getId());
            BizUserAchieveStatic bizUserAchieveStatic = (BizUserAchieveStatic)((Object)this.bizUserAchieveStaticDao.selectOne((Wrapper)queryWrapper));
            if (Objects.isNull((Object)bizUserAchieveStatic)) {
                bizUserAchieveStatic = new BizUserAchieveStatic();
            }
            bizUserAchieveStatic.setUserArchiveId(basic.getId());
            bizUserAchieveStatic.setUserName(basic.getUserName());
            bizUserAchieveStatic.setIdentiCard(basic.getIdentCard());
            bizUserAchieveStatic.setProfessionAssess(this.joinAssessments(bizUserAchieveDetails, BizUserAchieveDetail::getProfessionAssess));
            bizUserAchieveStatic.setTeachAssess(this.joinAssessments(bizUserAchieveDetails, BizUserAchieveDetail::getTeachAssess));
            bizUserAchieveStatic.setVocationAssess(this.joinAssessments(bizUserAchieveDetails, BizUserAchieveDetail::getVocationAssess));
            bizUserAchieveStatic.setPracticeAssess(this.joinAssessments(bizUserAchieveDetails, BizUserAchieveDetail::getPracticeAssess));
            bizUserAchieveStatic.setArchivement(this.joinAssessments(bizUserAchieveDetails, BizUserAchieveDetail::getArchivement));
            this.bizUserAchieveStaticManager.saveOrUpdate((Object)bizUserAchieveStatic);
        }
        if (CollectionUtils.isNotEmpty(bizUserWorkDetailList = editPersonalProfileDto.getBizUserWorkDetailList())) {
            for (BizUserWorkDetail bizUserWorkDetail : bizUserWorkDetailList) {
                bizUserWorkDetail.setUserArchiveId(basic.getId());
                bizUserWorkDetail.setUserName(basic.getUserName());
                bizUserWorkDetail.setIdentiCard(basic.getIdentCard());
                bizUserWorkDetail.setTdYear(personalProfileDto.getYear());
                this.bizUserWorkDetailDao.insert((Object)bizUserWorkDetail);
            }
        }
    }

    @Override
    public String uploadImage(MultipartFile file) {
        String uriPhoto = "";
        if (file != null) {
            String ext;
            try {
                ext = CheckFileFormatUtil.getFileType((FileInputStream)((FileInputStream)file.getInputStream()));
                ext = ext.toLowerCase();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (StringUtils.isEmpty((String)ext)) {
                throw new RuntimeException("\u4e0d\u80fd\u8bc6\u522b\u7684\u6587\u4ef6\u683c\u5f0f");
            }
            if (!"bmp,jpg,png,tif,gif,svg,jpeg".contains(ext)) {
                throw new RuntimeException("\u8bf7\u4e0a\u4f20\u56fe\u7247\u683c\u5f0f\u6587\u4ef6");
            }
            String originalFilename = file.getOriginalFilename();
            assert (originalFilename != null);
            String fileType = originalFilename.substring(originalFilename.lastIndexOf("."));
            try {
                uriPhoto = MinioUtil.uploadRelative((MultipartFile)file, (String)"", (String)(RandomStringUtils.randomAlphanumeric((int)100) + fileType), (String)"user");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return uriPhoto;
    }

    @Override
    public void download(String fileName, HttpServletResponse response) {
        try {
            fileName = fileName.replace("user/", "");
            InputStream minioFile = MinioUtil.getMinioFile((String)"user", (String)fileName, (boolean)true);
            if (minioFile != null) {
                response.setContentType("application/force-download");
                response.addHeader("Content-Disposition", "attachment;fileName=" + fileName);
                IOUtils.copy((InputStream)minioFile, (OutputStream)response.getOutputStream());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void export(List<String> userIds, Integer year, HttpServletResponse response) {
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        String zipPath = "";
        try {
            Path tmpCustomPrefix = Files.createTempDirectory("ftl" + UniqueIdUtil.getSuid(), new FileAttribute[0]);
            zipPath = tmpCustomPrefix.toString();
            String tmpPath = zipPath + "/";
            for (String userId : userIds) {
                String name;
                ObjectNode user;
                UCFeignService service;
                PersonalProfileVo personalProfile = this.getPersonalProfile(String.valueOf(year), userId);
                if (Objects.isNull((Object)personalProfile.getBizUserBasic())) {
                    service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
                    user = (ObjectNode)service.getUserById(userId).getValue();
                    name = user.get("fullname").asText();
                    throw new RuntimeException(name + "\u6863\u6848\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff01");
                }
                if (CollectionUtils.isEmpty(personalProfile.getExamUserEvaluationVoList())) {
                    service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
                    user = (ObjectNode)service.getUserById(userId).getValue();
                    name = user.get("fullname").asText();
                    throw new RuntimeException(name + year + "\u5e74\u6863\u6848\u4e0d\u5b8c\u5584\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff01");
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("vo", personalProfile);
                map.put("vo2", personalProfile.getExamUserEvaluationVoList().get(0));
                String fileOnlyName = "\u4e2a\u4eba\u6863\u6848_" + personalProfile.getBizUserBasic().getUserName() + ".doc";
                File file = new File(tmpPath + fileOnlyName);
                WordUtil.createWord((HttpServletResponse)response, map, (String)"documentModel.ftl", (String)file.getPath(), (String)fileOnlyName);
            }
            ZipUtil.zip((String)zipPath, (Boolean)true);
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (File)new File(zipPath + ".zip"), (String)"\u4e2a\u4eba\u6863\u6848.zip");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            FileUtil.deleteFile((String)(zipPath + ".zip"));
            File file = new File(zipPath);
            FileUtil.deleteDir((File)file);
        }
    }

    private String joinAssessments(List<BizUserAchieveDetail> detailList, Function<BizUserAchieveDetail, String> assessFunction) {
        return detailList.stream().sorted(Comparator.comparing(BizUserAchieveDetail::getTdYear)).map(assessFunction).collect(Collectors.joining(System.lineSeparator()));
    }
}

